package com.artfess.reform.fill.vo;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 改革需求分析-需求库表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-07
 */
@Data
@ApiModel(value="需求统计对象", description="改革需求分析-需求统计对象")
public class DemandAnalysisLibraryNumVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "上报单位_id")
    private String unitId;

    @ApiModelProperty(value = "上报单位_name")
    private String unitName;

    @ApiModelProperty(value = "需求上报单位CODE（关联组织机构表编码）")
    private String unitCode;

    @ApiModelProperty(value = "需求上报单位GRADE（关联组织机构表级别）")
    private String unitGrade;

    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    @TableField("DEMAND_DATE_")
    private Date demandDate;

    @ApiModelProperty(value = "需求上报年份")
    private Integer demandYear;

    @ApiModelProperty(value = "需求上报月份")
    private Integer demandMonth;

    @ApiModelProperty(value = "需求上报季度")
    private Integer demandQuarter;

    @ApiModelProperty("需求总数量")
    private Integer demandNum = 0;

    @ApiModelProperty("纳入需求全量库数量")
    private Integer libraryNum = 0;

    @ApiModelProperty("转化为清单的数量")
    private Integer listNum = 0;

    @ApiModelProperty("转化为市级重大项目的数量")
    private Integer projectNum = 0;

    @ApiModelProperty("不采纳数量")
    private Integer stopNum = 0;

    @ApiModelProperty("纳入需求全量库转化率")
    private BigDecimal libraryRate = new BigDecimal(0);

    @ApiModelProperty("清单转化率")
    private BigDecimal listRate = new BigDecimal(0);

    @ApiModelProperty("转化为市级重大项目转化率")
    private BigDecimal projectRate = new BigDecimal(0);

    @ApiModelProperty("不通过率")
    private BigDecimal stopRate = new BigDecimal(0);

    @ApiModelProperty("质效指数（本单位提出的改革需求被转化为需求清单项目的数量+转化为重大项目的数量×5）/需求清单项目总量×100）" )
    private BigDecimal qualityRate  = new BigDecimal(0);

    @ApiModelProperty("需求总量排名")
    private Integer demandRank = 0;

    @ApiModelProperty("纳入需求全量库排名")
    private Integer libraryRank = 0;

    @ApiModelProperty("按清单转化数量排名")
    private Integer listRank = 0;

    @ApiModelProperty("转化为市级重大项目排名")
    private Integer projectRank = 0;

    @ApiModelProperty("不采纳排名")
    private Integer stopRank = 0;



}
