package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;

/**
 * 工作报告管理
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-09
 */
@TableName("BIZ_REFORM_WORK_REPORT")
@ApiModel(value="BizReformWorkReport对象", description="工作报告管理")
@Data
public class BizReformWorkReport extends AutoFillFullModel<BizReformWorkReport> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId("ID_")
    private String id;

    @ApiModelProperty(value = "报告类型（1：区县季报，2：改革委月报）")
    @TableField("REPORT_NAME_")
    private String reportName;

    @ApiModelProperty(value = "报告年")
    @TableField("REPORT_YEAR_")
    private Integer reportYear;

    @ApiModelProperty(value = "报告季度")
    @TableField("REPORT_QUARTER_")
    private Integer reportQuarter;

    @ApiModelProperty(value = "报告月")
    @TableField("REPORT_MONTH_")
    private Integer reportMonth;

    @ApiModelProperty(value = "报告日期")
    @TableField("REPORT_DATE_")
    private LocalDate reportDate;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;
    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele="0";


    @ApiModelProperty(value = "附件id")
    @TableField(exist = false)
    private List<String> ids;

    @ApiModelProperty(value = "附件集合")
    @TableField(exist = false)
    private List<DefaultFile> fileList;
}
