package com.artfess.reform.fill.model;

import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 推动数字重庆建设
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-08-23
 */

@Data
@TableName("BIZ_DIGITAL_ADVANCE_CONSTRUCTION")
@ApiModel(value="BizDigitalAdvanceConstruction对象", description="推动数字重庆建设")
public class BizDigitalAdvanceConstruction extends BaseModel<BizDigitalAdvanceConstruction> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "数字重庆id")
    @TableField("DIGITAL_ID_")
    private String digitalId;

    @ApiModelProperty(value = " 推进表id")
    @TableField("PUSH_ID_")
    private String pushId;

    @ApiModelProperty(value = "所属类型")
    @TableField("CATEGORY_TYPE_")
    private Integer categoryType;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    @TableLogic
    private String isDele="0";

}
