package com.artfess.reform.fill.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizReformDemandAnalysisLibrary;
import com.artfess.reform.statistics.vo.CountyChartVo;

import java.util.List;

/**
 * 改革需求分析-需求库表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-07
 */
public interface BizReformDemandAnalysisLibraryManager extends BaseManager<BizReformDemandAnalysisLibrary> {

    /**
     * 添加改革需求基础信息
     * @param demand
     * @Return: boolean
     * @Author: chens
     * @Date: 2021/10/14 14:40
     */
    String insertDemand(BizReformDemandAnalysisLibrary demand);


    /**
     * 修改改革需求基础信息
     * @param demand
     * @Return: boolean
     * @Author: chens
     * @Date: 2021/10/14 14:40
     */
    String updateDemand(BizReformDemandAnalysisLibrary demand);

    /**
     * 修改审批状态
     * @param  demand 审批状态（0：草稿，1：已上报待审核，2：审核驳回，3：审核通过改革办待审核 ， 4：改革办审核确认驳回 ， 5：改革办审核确认完成）
     * @Return: boolean
     * @Author: chens
     * @Date: 2021/10/14 14:40
     */
    String updateAuditStatus(BizReformDemandAnalysisLibrary demand);

    /**
     * 修改采纳状态
     * @param  demand
     * @Return: boolean
     * @Author: chens
     * @Date: 2021/10/14 14:40
     */
    String updateAdoptStatus(BizReformDemandAnalysisLibrary demand);

    /**
     * 批量删除
     * @param  ids
     * @Return: boolean
     * @Author: chens
     * @Date: 2021/10/14 14:40
     */
    boolean deleteBatchByIds(List<String> ids);

    List<CountyChartVo> chartDataForLargeScreen(Integer year,Integer month);

    /**
     *分页查询数据以及第一次提交审核时间
     * @param queryFilter
     * @return
     */
    PageList<BizReformDemandAnalysisLibrary> queryByPage(QueryFilter<BizReformDemandAnalysisLibrary> queryFilter);
}
