package com.artfess.reform.fill.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizBlockageCardTransferRecord;
import com.artfess.reform.fill.model.BizEffectDryingCompetition;
import com.artfess.reform.fill.model.BizEffectEffectiveness;
import com.artfess.reform.fill.vo.EffectDryingCompetitionExportVo;

/**
 * 成效晾晒比拼（品牌显示度） 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-08
 */
public interface BizEffectDryingCompetitionManager extends BaseManager<BizEffectDryingCompetition> {

    /**
     * @Description: 成效晾晒的录入
     * @param blockageCard
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/3/22 14:16
     */
    String inertInfo(BizEffectDryingCompetition blockageCard);

    /**
     * @Description: 成效晾晒的修改
     * @param blockageCard
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/3/22 14:16
     */
    CommonResult<String> updateInfo(BizEffectDryingCompetition blockageCard);

    /**
     * @Description: 成效晾晒的删除
     * @param id
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/3/22 14:16
     */
    CommonResult<String> deleteById(String id);

    /**
     * @Description: 审核列表的分页查询
     * @param queryFilter
     * @Return: com.artfess.base.query.PageList<com.artfess.reform.fill.model.BizBlockageCardTransfer>
     * @Author: chens
     * @Date: 2023/3/22 16:38
     */
    PageList<EffectDryingCompetitionExportVo> queryAudit(QueryFilter<BizEffectDryingCompetition> queryFilter,String status);

    /**
     * @Description: 专项小组绑定的所属领域，查询项目相关详情
     * @param queryFilter
     * @Return: com.artfess.base.query.PageList<com.artfess.reform.fill.model.BizBlockageCardTransfer>
     * @Author: chens
     * @Date: 2023/3/22 16:38
     */
    PageList<EffectDryingCompetitionExportVo> queryGroup(QueryFilter<BizEffectDryingCompetition> queryFilter,String code);

    /**
     * @Description: 根据ID查询堵点卡点信息
     * @param id
     * @Return: com.artfess.reform.fill.model.BizBlockageCardTransfer
     * @Author: chens
     * @Date: 2023/3/22 17:14
     */
    BizEffectDryingCompetition queryById(String id);


    /**
     * @Description: 修改审核状态
     * @param record  具体详情记录表
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/3/22 10:21
     */
    void updateAuditStatus(BizEffectEffectiveness record);

}
