package com.artfess.reform.fill.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizBlockageCardTransfer;
import com.artfess.reform.fill.model.BizBlockageCardTransferRecord;
import com.artfess.reform.fill.vo.BlockageCardTransferVo;

import java.util.List;

/**
 * 堵点卡点转交办表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-08
 */
public interface BizBlockageCardTransferManager extends BaseManager<BizBlockageCardTransfer> {

    /**
    * @Description: 堵点开的录入
    * @param blockageCard
    * @Return: java.lang.String
    * @Author: chens
    * @Date: 2023/3/22 14:16
    */
    String inertInfo(BizBlockageCardTransfer blockageCard);

    /**
    * @Description: 根据主表ID查询推进记录
    * @param projectId  堵点卡点主表ID
    * @Return: java.util.List<com.artfess.reform.fill.model.BizBlockageCardTransferRecord>
    * @Author: chens
    * @Date: 2023/3/22 14:21
    */
    List<BizBlockageCardTransferRecord> records(String projectId);

    /**
     * @Description: 堵点开的录入
     * @param id 堵点卡点的删除
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/3/22 14:16
     */
    CommonResult<String> deleteById(String id);

    /**
     * @Description: 录入列表的分页查询
     * @param queryFilter
     * @Return: com.artfess.base.query.PageList<com.artfess.reform.fill.model.BizBlockageCardTransfer>
     * @Author: chens
     * @Date: 2023/3/22 16:38
     */
    PageList<BizBlockageCardTransfer> queryPageList(QueryFilter<BizBlockageCardTransfer> queryFilter);

    /**
    * @Description: 审核列表的分页查询
    * @param queryFilter
    * @Return: com.artfess.base.query.PageList<com.artfess.reform.fill.model.BizBlockageCardTransfer>
    * @Author: chens
    * @Date: 2023/3/22 16:38
    */
    PageList<BizBlockageCardTransfer> queryAudit(QueryFilter<BizBlockageCardTransfer> queryFilter);

    /**
     * @Description: 大屏分页查询堵点卡点的详情
     * @param queryFilter
     * @Return: com.artfess.base.query.PageList<com.artfess.reform.fill.model.BizBlockageCardTransfer>
     * @Author: chens
     * @Date: 2023/3/22 16:38
     */
    PageList<BlockageCardTransferVo> queryBlockageCardDetailList(QueryFilter<BizBlockageCardTransfer> queryFilter);

    /**
    * @Description: 修改主表的推进状态
    * @param id 主表ID
    * @param propulsiveStatus  推进状态 1：未启动，2：推进中，3：已完成
    * @Return: java.lang.String
    * @Author: chens
    * @Date: 2023/3/22 16:53
    */
    boolean updatePropulsiveStatus(String id,Integer propulsiveStatus);

    /**
    * @Description: 根据ID查询堵点卡点信息
    * @param id
    * @Return: com.artfess.reform.fill.model.BizBlockageCardTransfer
    * @Author: chens
    * @Date: 2023/3/22 17:14
    */
    BizBlockageCardTransfer queryById(String id);

    List<BizBlockageCardTransfer> problemSolvingDetail(String unitCode, Integer year,Integer quarter);

}
