package com.artfess.reform.fill.dao;


import com.artfess.reform.fill.model.BizReformRiskInvolvedDistricts;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface BizReformRiskInvolvedDistrictsDao extends BaseMapper<BizReformRiskInvolvedDistricts> {


    /**
    * @Description: 查询风险情况
    * @param riskYear 年
    * @param riskQuarter 季度
    * @param significant  涉及对象（使用字典，0：重大项目，1：区县）
    * @Return: java.util.List<com.artfess.reform.fill.model.BizReformRiskInvolvedDistricts>
    * @Author: chens
    * @Date: 2023/4/6 14:05
    */
    List<BizReformRiskInvolvedDistricts> countRiskForOrg(@Param("riskYear") Integer riskYear, @Param("riskQuarter") Integer riskQuarter, @Param("significant") Integer significant);

}
