package com.artfess.reform.fill.dao;


import com.artfess.reform.fill.model.BizDigitalOneThing;
import com.artfess.reform.fill.vo.OneThingsVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;


import java.time.LocalDateTime;
import java.util.List;

/**
 * 围绕重点领域策划推出“一件事”情况 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-08-23
 */
public interface BizDigitalOneThingDao extends BaseMapper<BizDigitalOneThing> {
    List<BizDigitalOneThing> selectByUnitId(@Param("unitId") String unitId);

    List<BizDigitalOneThing> selectAuditById(@Param("id") String id);

    List<BizDigitalOneThing> selectExamineById(@Param("id") String id,@Param("unitId") String unitId);

    IPage<BizDigitalOneThing> queryByPage(IPage<BizDigitalOneThing> convert2IPage,
                                              @Param(Constants.WRAPPER) Wrapper<BizDigitalOneThing> convert2Wrapper);

    IPage<BizDigitalOneThing> queryByPageAll(IPage<BizDigitalOneThing> convert2IPage,
                                          @Param(Constants.WRAPPER) Wrapper<BizDigitalOneThing> convert2Wrapper);

    IPage<BizDigitalOneThing> queryByPageNew(IPage<BizDigitalOneThing> convert2IPage,
                                             @Param(Constants.WRAPPER) Wrapper<BizDigitalOneThing> convert2Wrapper);

    IPage<BizDigitalOneThing> queryByPageHis(IPage<BizDigitalOneThing> convert2IPage,
                                      @Param("name")String name,
                                      @Param("appertainSystem")Integer appertainSystem,
                                      @Param("appertainSunway")Integer appertainSunway,
                                      @Param("unitName")String unitName,
                                      @Param("status")Integer status,
                                      @Param("auditStatus")Integer auditStatus,
                                      @Param("isDele")String isDele);
}
