package com.artfess.reform.fill.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.DataPermission;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.fill.manager.BizReformSatisfactionDistrictsManager;
import com.artfess.reform.fill.manager.BizReformSatisfactionManagementManager;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizReformSatisfactionDistricts;
import com.artfess.reform.fill.model.BizReformSatisfactionManagement;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/biz/bizReformSatisfactionManagement/v1")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@Api(tags = "区县改革满意度管理")
public class BizReformSatisfactionManagementController extends BaseController<BizReformSatisfactionManagementManager, BizReformSatisfactionManagement> {

    /**
     * 分页查询主表数据
     * @param queryFilter
     * @return 分页数据
     */
    @PostMapping(value="/queryByPage", produces={"application/json; charset=utf-8" })
    @ApiOperation("S-满意度分页查询")
    public PageList<BizReformSatisfactionManagement> queryByPage(@RequestBody QueryFilter<BizReformSatisfactionManagement> queryFilter,boolean isAffirm) {
        queryFilter.addFilter("m.is_dele_", "0", QueryOP.EQUAL);
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("m.last_time_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return baseService.queryByPage(queryFilter,isAffirm);
    }
    /**
     * 保存数据或者修改数据
     * @param bizReformSatisfactionManagement
     * @return
     */
    @PostMapping("/saveOrUpdateSatisfaction")
    @ApiOperation(value = "S-保存修改主子表数据")
    public  CommonResult<String> saveOrUpdateSatisfaction(@ApiParam(name = "BizReformSatisfactionManagement对象") @RequestBody BizReformSatisfactionManagement bizReformSatisfactionManagement) {
        String id = baseService.saveOrUpdateSatisfaction(bizReformSatisfactionManagement);
        if(StringUtil.isEmpty(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>(true,"保存成功！",id);

    }

    @PostMapping("/updateStatusById")
    @ApiOperation(value = "S-根据id修改状态")
    public CommonResult updateStatusById(@RequestParam(name = "id",required = true) String id,
                                         @RequestParam(name = "status",required = false) Integer status,
                                         @RequestParam(name = "fileStatus",required = false) Integer fileStatus,
                                         @RequestParam(name = "approvalComments",required = false) String approvalComments) {
        baseService.updateStatusById(id,status,fileStatus,approvalComments);
        return new CommonResult("修改状态成功");
    }

    @PostMapping("/delete")
    @ApiOperation(value = "S-根据id批量删除数据")
    public CommonResult<String> deleteBatchByIds(@ApiParam(name = "id集合") @RequestParam("id") String id) {
        return baseService.deleteBatchByIds(id);
    }

    @PostMapping("/queryById")
    @ApiOperation(value = "S-根据id查询满意度")
    public BizReformSatisfactionManagement queryById(@RequestParam(name = "id",required = true) String id) {
        BizReformSatisfactionManagement satisfactionManagement =baseService.getById(id);
        return satisfactionManagement;
    }

}