package com.artfess.reform.fill.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.StringUtil;
import com.artfess.reform.fill.manager.BizReformDemandAssignmentRecordManager;
import com.artfess.reform.fill.model.BizReformDemandAssignmentRecord;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 需求交办推进记录表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-07
 */
@RestController
@RequestMapping("/bizReformDemandAssignmentRecord/v1/")
@Api(tags = "改革需求交办推进记录")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizReformDemandAssignmentRecordController extends BaseController<BizReformDemandAssignmentRecordManager, BizReformDemandAssignmentRecord> {


    @PostMapping("/insertInfo")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> insertInfo(@RequestBody BizReformDemandAssignmentRecord assignmentRecord) {
        String id = baseService.insertInfo(assignmentRecord);
        if(StringUtil.isEmpty(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>(true,"保存成功！",id);
    }


    @PostMapping("/updateById")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> update(@RequestBody BizReformDemandAssignmentRecord assignmentRecord) {
        String id = baseService.updateInfo(assignmentRecord);
        if(StringUtil.isEmpty(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>(true,"修改成功！",id);
    }

    @PostMapping("/updateAuditStatus")
    @ApiOperation("修改审核状态")
    public CommonResult<String> updateAuditStatus(@RequestBody BizReformDemandAssignmentRecord assignmentRecord) {
        baseService.updateAuditStatus(assignmentRecord);
        return new CommonResult<String>();
    }

/*
    @GetMapping("/findStatus")
    @ApiOperation("查询是否存在未审核完成的记录")
    public CommonResult<String> findStatus(String projectId) {
        List<Integer> status=new ArrayList<>();
        status.add(1);
        status.add(3);
        status.add(4);
        QueryWrapper<BizReformDemandAssignmentRecord> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("PROJECT_ID_",projectId);
        queryWrapper.eq("IS_DELE_","0");
        queryWrapper.in("STATUS_",status);
        queryWrapper.eq("REPORTING_UNIT_ID_",ContextUtil.getCurrentOrgId());
        if (baseService.list(queryWrapper).size()>0){
            return  new CommonResult<String>(false,"存在未审核完成记录");
        }
        return  new CommonResult<String>(true,"不存在未审核完成记录");
    }*/




}
