package com.artfess.reform.fill.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizMeetingDocumentsConsidered;
import com.artfess.reform.fill.model.BizMeetingEventPush;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.fill.model.BizMeetingDocumentsPush;
import com.artfess.reform.fill.manager.BizMeetingDocumentsPushManager;

import java.util.List;

/**
 * 会议审议通过文件处理推进表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-04-03
 */
@RestController
@RequestMapping("/fill/bizMeetingDocumentsPush/v1/")
@Api(tags = "审议文件推送")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizMeetingDocumentsPushController extends BaseController<BizMeetingDocumentsPushManager, BizMeetingDocumentsPush> {

    @PostMapping("/updateByStatus")
    @ApiOperation("修改审核状态")
    public CommonResult<String> updateByStatus(@RequestBody BizMeetingDocumentsConsidered bizMeetingDocumentsConsidered) {
        return  new CommonResult<>(baseService.updateByStatus(bizMeetingDocumentsConsidered)?"修改审核状态成功":"修改审核状态失败");
    }

    @PostMapping("/insertInfo")
    @ApiOperation("添加实体类")
    public CommonResult<String> insertInfo(@RequestBody BizMeetingDocumentsPush bizMeetingDocumentsPush) {
        return  new CommonResult<>(baseService.insertInfo(bizMeetingDocumentsPush)?"添加成功":"添加失败");
    }

    @PostMapping("/updateInfo")
    @ApiOperation("修改实体类")
    public CommonResult<String> updateInfo(@RequestBody BizMeetingDocumentsPush bizMeetingDocumentsPush) {
        baseService.updateInfo(bizMeetingDocumentsPush);
        return  new CommonResult<>("修改成功");
    }

    @PostMapping("/revSendStatus")
    @ApiOperation("根据交办事项id查询分发的数据是否已填写")
    public CommonResult<String> revSendStatus(@RequestParam("id") String id) {
        Assert.notNull(id,"需查询的id不能为空");
        List<BizMeetingDocumentsPush> list = baseService.list(new QueryWrapper<BizMeetingDocumentsPush>().eq("MEETING_ID_", id).eq("IS_DELE_", "0"));
        if ( list.size()>0){
            return new CommonResult<>(false,"对接责任单位已推进更新,无法撤回");
        }
        return new CommonResult<>(true,"");
    }
}
