package com.artfess.reform.fill.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.manager.BizDigitalAdvanceConstructionManager;
import com.artfess.reform.fill.manager.BizDigitalThreeListsManager;
import com.artfess.reform.fill.model.BizDigitalAdvanceConstruction;
import com.artfess.reform.fill.model.BizDigitalOneThing;
import com.artfess.reform.fill.model.BizDigitalShareApplication;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.fill.model.BizDigitalThreeLists;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 围绕三张清单情况 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-08-23
 */
@RestController
@RequestMapping("/fill/bizDigitalThreeLists/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@Api(tags = "编制应用“三张清单”情况")
public class BizDigitalThreeListsController extends BaseController<BizDigitalThreeListsManager, BizDigitalThreeLists> {

    @Resource
    BizDigitalAdvanceConstructionManager bizDigitalAdvanceConstructionManager;

    @Override
    @DeleteMapping("/{originalId}")
    @ApiOperation("根据id删除数据")
    public CommonResult<String> deleteById(@ApiParam(name="originalId", value="originalId") @PathVariable("originalId") String originalId) {
        //删除列表数据
        QueryWrapper<BizDigitalThreeLists> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("ORIGINAL_ID_",originalId);
        List<BizDigitalThreeLists> list = baseService.list(queryWrapper);
        if (list!=null&&list.size()>0){
            List<String> ids = list.stream().map(BizDigitalThreeLists::getId).collect(Collectors.toList());
            //删除推进表信息
            bizDigitalAdvanceConstructionManager.remove(new QueryWrapper<BizDigitalAdvanceConstruction>().in("PUSH_ID_",ids));
            baseService.removeByIds(ids);
        }
        return CommonResult.success(originalId, "数据删除成功！");
    }

    @PostMapping(value="/queryByPage")
    @ApiOperation("分页查询")
    public PageList<BizDigitalThreeLists> queryPush(@RequestBody QueryFilter<BizDigitalThreeLists> queryFilter) {
        return  baseService.queryByPage(queryFilter);
    }

    @PostMapping(value="/queryByPageNew")
    @ApiOperation("分页查询最新数据")
    public PageList<BizDigitalThreeLists> queryByPageNew(@RequestBody QueryFilter<BizDigitalThreeLists> queryFilter) {
        return  baseService.queryByPageNew(queryFilter);
    }
}
