package com.artfess.reform.statistics.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 区县指标排行榜Vo
 *
 * @author 黎沐华
 * @date 2023/3/31 21:04
 */
@Data
@ApiModel("区县指标排行榜Vo")
public class CountyIndexVo {

    @ApiModelProperty("指标名")
    private String index;

    @ApiModelProperty("入选区县")
    private String county;

    @ApiModelProperty(value = "入榜形式", notes = "即蝉联次数，为0表示新晋")
    private String  holdNum;

    public CountyIndexVo(String index, String county, String holdNum) {
        this.index = index;
        this.county = county;
        this.holdNum = holdNum;
    }

    public CountyIndexVo() {
    }

    public CountyIndexVo(String index) {
        this.index = index;
    }

    public CountyIndexVo(String index, String county) {
        this.index = index;
        this.county = county;
    }
}
