package com.artfess.reform.statistics.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.reform.fill.model.BizEffectEffectiveness;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 区县品牌显示度评分结果
 *
 * @author 黎沐华
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-03-30
 */
@Data
@TableName("BIZ_SCORING_COUNTY_BRAND")
@ApiModel(value = "BizScoringCountyBrand对象", description = "区县品牌显示度评分结果")
public class BizScoringCountyBrand extends BaseModel<BizScoringCountyBrand> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "评比日期")
    @TableField("FILL_DATE_")
    private LocalDate fillDate;

    @ApiModelProperty(value = "评比年")
    @TableField("FILL_YEAR_")
    private Integer fillYear;

    @ApiModelProperty(value = "评比季度")
    @TableField("FILL_QUARTER_")
    private Integer fillQuarter;

    @ApiModelProperty(value = "评比月")
    @TableField("FILL_MONTH_")
    private Integer fillMonth;

    @ApiModelProperty(value = "评比类型（日：D，月：M，季度：Q，年：Y）")
    @TableField("FILL_TYPE_")
    private String fillType;

    @ApiModelProperty(value = "评比区县NAME（关联组织机构表NAME）")
    @TableField("UNIT_NAME_")
    private String unitName;

    @ApiModelProperty(value = "评比区县CODE（关联组织机构表编码）")
    @TableField("UNIT_CODE_")
    private String unitCode;

    @ApiModelProperty(value = "评比区县GRADE（关联组织机构表级别）")
    @TableField("UNIT_GRADE_")
    private Integer unitGrade;

    @ApiModelProperty(value = "改革经验获全国性肯定评价（件次）")
    @TableField("NATIONWIDE_NUM_")
    private Integer nationwideNum = 0;

    @ApiModelProperty(value = "改革经验获全国性肯定评价得分")
    @TableField("NATIONWIDE_SCORE_")
    private BigDecimal nationwideScore = new BigDecimal(0);

    @ApiModelProperty(value = "改革经验获全国性肯定全市排名")
    @TableField("NATIONWIDE_SN_")
    private Integer nationwideSn ;

    @ApiModelProperty(value = "改革经验获全国性肯定全市排名档次（A，B，C，D，E）")
    @TableField("NATIONWIDE_GRADE_")
    private String nationwideGrade ;

    @ApiModelProperty(value = "改革经验获全市推广（件次）")
    @TableField("CITY_NUM_")
    private Integer cityNum  = 0;

    @ApiModelProperty(value = "改革经验获全市推广得分")
    @TableField("CITY_SCORE_")
    private BigDecimal cityScore  = new BigDecimal(0);

    @ApiModelProperty(value = "改革经验获全市推广排名")
    @TableField("CITY_SN_")
    private Integer citySn ;

    @ApiModelProperty(value = "改革经验获全市推广全市排名档次（A，B，C，D，E）")
    @TableField("CITY_GRADE_")
    private String cityGrade ;

    @ApiModelProperty(value = "改革经验被5家中央媒体深度专题报道（件次）")
    @TableField("MEDIA_NUM_")
    private Integer mediaNum  = 0;

    @ApiModelProperty(value = "改革经验被5家中央媒体深度专题报道得分")
    @TableField("MEDIA_SCORE_")
    private BigDecimal mediaScore  =  new BigDecimal(0);

    @ApiModelProperty(value = "改革经验被5家中央媒体深度专题报道全市排名")
    @TableField("MEDIA_SN_")
    private Integer mediaSn ;

    @ApiModelProperty(value = "改革经验被5家中央媒体深度专题报道全市排名档次（A，B，C，D，E）")
    @TableField("media_grade_")
    private String mediaGrade;

    @ApiModelProperty(value = "品牌显示度得分")
    @TableField("BRAND_SCORE_")
    private BigDecimal brandScore  =  new BigDecimal(0);

    @ApiModelProperty(value = "综合得分区域排名")
    @TableField("BRAND_REGION_SN_")
    private Integer brandRegionSn ;

    @ApiModelProperty(value = "综合得分全市排名")
    @TableField("BRAND_ALL_SN_")
    private Integer brandAllSn ;

    @ApiModelProperty(value = "蝉联次数")
    @TableField("HOLD_NUM_")
    private Integer holdNum;


    @ApiModelProperty(value = "创建时间", hidden = true)
    @TableField(updateStrategy = FieldStrategy.NOT_NULL, value = "create_time_", fill = FieldFill.INSERT, select = true)
    private LocalDateTime createTime;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField(updateStrategy = FieldStrategy.NOT_NULL, value = "LAST_TIME_", fill = FieldFill.INSERT_UPDATE, select = false)
    private Long lastTime;

    @ApiModelProperty(value = "综合得分全市排名趋势（正数就是上升的排名，负数下降排名）")
    @TableField(exist = false)
    private Integer brandAllSnTrend;

    @ApiModelProperty(value = "全国推广全市排名趋势（正数就是上升的排名，负数下降排名）")
    @TableField(exist = false)
    private Integer nationwideSnTrend;

    @ApiModelProperty(value = "全市推广全市排名趋势（正数就是上升的排名，负数下降排名）")
    @TableField(exist = false)
    private Integer citySnTrend;

    @ApiModelProperty(value = "媒体推广全市排名趋势（正数就是上升的排名，负数下降排名）")
    @TableField(exist = false)
    private Integer mediaSnTrend;

    @ApiModelProperty(value = "全国推广+媒体推广数量")
    @TableField(exist = false)
    private Integer nationwideAndmediaNum;

    @ApiModelProperty(value = "全国推广+媒体推广数量全市排名")
    @TableField(exist = false)
    private Integer nationwideAndmediaSn;

    @ApiModelProperty(value = "成效详情数据", notes = "用于区县大屏改革品牌榜详情数据")
    @TableField(exist = false)
    private List<BizEffectEffectiveness> effectDetail;
}
