package com.artfess.reform.statistics.manager.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.fill.dao.BizPilotAdvanceRecordDao;
import com.artfess.reform.fill.dao.BizPilotAdvanceResultDao;
import com.artfess.reform.fill.dao.BizReformRiskManagementDao;
import com.artfess.reform.fill.dao.BizReformSatisfactionDistrictsDao;
import com.artfess.reform.fill.dao.BizReformSatisfactionManagementDao;
import com.artfess.reform.fill.manager.BizBlockageCardTransferManager;
import com.artfess.reform.fill.manager.BizEffectEffectivenessManager;
import com.artfess.reform.fill.manager.BizPilotAdvanceResultManager;
import com.artfess.reform.fill.manager.BizReformDemandAnalysisLibraryManager;
import com.artfess.reform.fill.manager.BizReformDemandAssignmentManager;
import com.artfess.reform.fill.manager.BizReformPilotManagementManager;
import com.artfess.reform.fill.manager.BizReformSatisfactionManagementManager;
import com.artfess.reform.fill.manager.BizReformWorkReportManager;
import com.artfess.reform.fill.model.BizBlockageCardTransfer;
import com.artfess.reform.fill.model.BizEffectEffectiveness;
import com.artfess.reform.fill.model.BizPilotAdvanceRecord;
import com.artfess.reform.fill.model.BizPilotAdvanceResult;
import com.artfess.reform.fill.model.BizReformDemandAnalysisLibrary;
import com.artfess.reform.fill.model.BizReformDemandAssignment;
import com.artfess.reform.fill.model.BizReformPilotManagement;
import com.artfess.reform.fill.model.BizReformRiskManagement;
import com.artfess.reform.fill.model.BizReformSatisfactionDistricts;
import com.artfess.reform.fill.model.BizReformSatisfactionManagement;
import com.artfess.reform.fill.model.BizReformWorkReport;
import com.artfess.reform.fill.vo.PilotAdvanceResultNumVo;
import com.artfess.reform.statistics.dao.BizScoringCountyBrandDao;
import com.artfess.reform.statistics.dao.BizScoringCountyMajorDao;
import com.artfess.reform.statistics.dao.BizScoringCountySynDao;
import com.artfess.reform.statistics.dao.BizScoringCountyWorkableDao;
import com.artfess.reform.statistics.manager.CountyLargeScreeManager;
import com.artfess.reform.statistics.model.BizScoringCountyBrand;
import com.artfess.reform.statistics.model.BizScoringCountyMajor;
import com.artfess.reform.statistics.model.BizScoringCountySyn;
import com.artfess.reform.statistics.model.BizScoringCountyWorkable;
import com.artfess.reform.statistics.vo.BrandCalVo;
import com.artfess.reform.statistics.vo.CoreIndexVo;
import com.artfess.reform.statistics.vo.CountyBrandVo;
import com.artfess.reform.statistics.vo.CountyChartVo;
import com.artfess.reform.statistics.vo.CountyPilotReformVo;
import com.artfess.reform.statistics.vo.CountySynVo;
import com.artfess.reform.statistics.vo.StatementDetailVo;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Maps;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.IsoFields;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/**
 * @author 黎沐华
 * @date 2023/3/31 20:08
 */
@Service
public class CountyLargeScreeManagerImpl implements CountyLargeScreeManager {

    @Resource
    private BizReformPilotManagementManager reformPilotManager;
    @Resource
    private BizPilotAdvanceResultManager advanceResultManager;
    @Resource
    private BizEffectEffectivenessManager effectManager;
    @Resource
    private OrgManager orgManager;
    @Resource
    private BizReformRiskManagementDao riskDao;
    @Resource
    private BizReformDemandAnalysisLibraryManager demandManager;
    @Resource
    private BizReformDemandAssignmentManager demandRecordMaanger;
    @Resource
    private SysDictionaryManager sdm;
    @Resource
    private BizScoringCountyWorkableDao workableDao;
    @Resource
    private BizScoringCountyMajorDao majorDao;
    @Resource
    private BizScoringCountyBrandDao brandDao;
    @Resource
    private BizScoringCountySynDao synDao;
    @Resource
    private BizReformSatisfactionDistrictsDao satisfacttDao;
    @Resource
    private BizReformSatisfactionManagementDao satisfacttMangerDao;
    @Resource
    private BizPilotAdvanceRecordDao pilotRecordDao;
    @Resource
    private BizPilotAdvanceResultDao pilotResultDao;
    @Resource
    private BizBlockageCardTransferManager transferManager;
    @Resource
    private FileManager fileManager;
    @Resource
    private BizReformSatisfactionManagementManager satisfactionManager;
    @Resource
    private BizReformWorkReportManager reportManager;
    @Resource
    private BizReformSatisfactionManagementManager bizReformSatisfactionManagementManager;

    // 获取当前年,季度
    private final int currentYear = LocalDate.now().getYear();

    @Override
    public CoreIndexVo importantIndex(Integer year, Integer quarter) {
        // 获取当前年,季度
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        BizScoringCountyWorkable workableCount = workableDao.statisticsPilotNum(year,quarter);
        BizScoringCountyWorkable workable = workableDao.statisticsLatest(year,quarter);
        BizScoringCountyBrand brand = brandDao.statisticsLatest(year,quarter);
        BizReformSatisfactionDistricts satisfactions = satisfacttDao.qureySatisfactionDistrictsByUnitCode(year,quarter,"500000");
        BizScoringCountyMajor major = majorDao.queryDigit(year, quarter);
        List<BizScoringCountySyn> syn = synDao.queryLatest(year, quarter, null, null);
        CoreIndexVo coreIndexVo =new CoreIndexVo();
        if(workableCount!=null){
            coreIndexVo.setNationalProjectNum(workableCount.getNationalProjectNum());
            coreIndexVo.setNationalAddNum(workableCount.getNationalAddNum());
        }else{
            coreIndexVo.setNationalProjectNum(0);
            coreIndexVo.setNationalAddNum(0);
        }
        if(workable!=null){
            Integer projectEndNum = workable.getProjectEndNum();
            if(projectEndNum ==null || projectEndNum ==0 ){
                coreIndexVo.setNationalPassRate(new BigDecimal(0));
            }else{
                BigDecimal nationalPassRate = new BigDecimal(workable.getNationalPassNum()).divide(new BigDecimal(workable.getNationalEndNum()),4, BigDecimal.ROUND_HALF_UP);
                coreIndexVo.setNationalPassRate(nationalPassRate.multiply(new BigDecimal(100)));
            }
        }else{
            coreIndexVo.setNationalPassRate(new BigDecimal(0.00));
        }

        if(brand!=null){
            coreIndexVo.setNationwideNum(brand.getNationwideNum());
            coreIndexVo.setCityNum(brand.getCityNum());
            coreIndexVo.setMediaNum(brand.getMediaNum());
        }else{
            coreIndexVo.setNationwideNum(0);
            coreIndexVo.setCityNum(0);
            coreIndexVo.setMediaNum(0);
        }
        if(satisfactions!=null){
            coreIndexVo.setSatisfied(satisfactions.getSatisfaction());
        }else{
            coreIndexVo.setSatisfied(new BigDecimal(0.00));
        }
        if(major!=null){
            coreIndexVo.setDigitRate(major.getDigitRate());
            coreIndexVo.setReformRate(major.getReformRate());
            coreIndexVo.setManufacturingIndustryRate(major.getManufacturingIndustryRate());
            coreIndexVo.setListedCompaniesDivide(major.getListedCompaniesDivide());
            coreIndexVo.setCreditRate(major.getCreditRate());
        }else{
            coreIndexVo.setDigitRate(new BigDecimal(0.00));
            coreIndexVo.setReformRate(new BigDecimal(0.00));
            coreIndexVo.setManufacturingIndustryRate(new BigDecimal(0.00));
            coreIndexVo.setListedCompaniesDivide(new BigDecimal(0.00));
            coreIndexVo.setCreditRate(new BigDecimal(0.00));
        }
        if (syn!=null){
            BigDecimal sum = syn.stream().map(BizScoringCountySyn::getScore).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (sum.compareTo(new BigDecimal(0))!=0){
                BigDecimal avgScore = sum.divide(new BigDecimal(syn.size()), 4,BigDecimal.ROUND_HALF_UP);
                coreIndexVo.setAvgScore(avgScore);
            }else {
                coreIndexVo.setAvgScore(new BigDecimal(0.00));
            }

        }
        return coreIndexVo;
    }

    @Override
    public List<CountySynVo> indexRank(Integer year,Integer quarter)    {
        // 获取当前年,季度
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        List<CountySynVo> list  = synDao.indexSynRankBest(year,quarter);
        if(!CollectionUtils.isEmpty(list)){
            for(CountySynVo countySynVo:list){
                if(countySynVo.getSynSn()<=9){
                    countySynVo.setSynGrade("A");
                }else if(17 >= countySynVo.getSynSn() && countySynVo.getSynSn() > 9){
                    countySynVo.setSynGrade("B");
                }else if(25 >= countySynVo.getSynSn() && countySynVo.getSynSn() > 17){
                    countySynVo.setSynGrade("C");
                }else if(33 >= countySynVo.getSynSn() && countySynVo.getSynSn() > 25){
                    countySynVo.setSynGrade("D");
                }else if(countySynVo.getSynSn() > 33){
                    countySynVo.setSynGrade("E");
                }
            }
        }
        return list;
    }

    @Override
    public CountyPilotReformVo pilotReform(Integer year, Integer quarter, String unitCode) {
        CountyPilotReformVo result = new CountyPilotReformVo();
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }

        if (StringUtil.isEmpty(unitCode)) {
                Map<Integer, List<CountyChartVo>> lineChartData = reformPilotManager.lineChartDataForLargeScreen(year,quarter).stream().collect(Collectors.groupingBy(CountyChartVo::getLegend));
            result.setChart(lineChartData);
        }

        List<CountyPilotReformVo> achievement = Lists.newArrayList();
        List<CountyPilotReformVo> totalAR = advanceResultManager.count(0, year, quarter, unitCode);
      /*  Map<Integer, Integer> currentAR = advanceResultManager.count(1, year, quarter, unitCode).stream()
                .collect(Collectors.toMap(CountyPilotReformVo::getAchievementType, CountyPilotReformVo::getTotalAchievement));*/
        Map<Integer, Integer> lastAR = advanceResultManager.count(1, year, quarter, unitCode).stream()
                .collect(Collectors.toMap(CountyPilotReformVo::getAchievementType, CountyPilotReformVo::getTotalAchievement));
        if (totalAR != null && totalAR.size() > 0) {
            totalAR.forEach(t -> {
                CountyPilotReformVo a = new CountyPilotReformVo(t.getAchievementType(), t.getTotalAchievement());
                Integer current =t.getTotalAchievement();
                Integer last = lastAR.get(t.getAchievementType());
                if (current != null) {
                    a.setTotalAchievement(current);
                    if (last != null) {
                        a.setGapQAchievement(last);
                    } else {
                        a.setGapQAchievement(0);
                    }
                } else {
                    a.setTotalAchievement(0);
                    a.setGapQAchievement(0);
                }
                achievement.add(a);
            });
        }

        result.setAchievement(achievement);

        return result;
    }

    @Override
    public PageList<BizPilotAdvanceResult> pilotResultDetail(QueryFilter<BizPilotAdvanceResult> queryFilter) {
        return advanceResultManager.pilotResultDetail(queryFilter);
    }

    @Override
    public CountyBrandVo brandReform(Integer year,Integer quarter,String unitId, List<Integer> effectForm) {
        CountyBrandVo result = new CountyBrandVo();
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        int fillMonth =  quarter * 3;

        // 图表数据
       Map<String, List<BrandCalVo>> chart = brandDao.brandReformChart(year,unitId).stream().collect(Collectors.groupingBy(BrandCalVo::getEffectType));

        chart.entrySet().forEach(en -> {
            List<BrandCalVo> list = en.getValue();
            list.forEach(l -> l.setEffectType(null));
            // 判断是否存在完整的十二个月份
            boolean existsTwelveMonths = IntStream.rangeClosed(1, 12)
                    .allMatch(month -> list.stream().anyMatch(vo -> vo.getEffectMonth() == month));
            // 如果不存在完整的十二个月份，则添加新的对象
            if (!existsTwelveMonths) {
                IntStream.rangeClosed(1, 12)
                        .filter(month -> list.stream().noneMatch(vo -> vo.getEffectMonth() == month))
                        .mapToObj(month -> new BrandCalVo(month, 0)) // 创建新的VO对象
                        .forEach(list::add); // 将新的VO对象添加到List中
            }
            // 按月份升序排序
            list.sort(Comparator.comparingInt(BrandCalVo::getEffectMonth));
        });


        result.setChart(chart);

        // 品牌数据及详情
        List<BizScoringCountyBrand> brandData = this.citywidePromotionRank(year,quarter,2);
      //  QueryWrapper<BizEffectEffectiveness> queryWrapper = new QueryWrapper<BizEffectEffectiveness>();
     /*   Map<String, List<BizEffectEffectiveness>> brandEffect = effectManager.list(new QueryWrapper<BizEffectEffectiveness>()
                        .eq("STATUS_", 5)
                        .in("EFFECT_FORM_",effectForm)
                        .eq("COMPLETION_YEAR_", year)
                        .le("COMPLETION_QUARTER_", quarter)
                        .lt("create_time_",LocalDate.now()))
                .stream().collect(Collectors.groupingBy(BizEffectEffectiveness::getOrgCode));
        brandData.forEach(bd -> {
            List<BizEffectEffectiveness> detail = brandEffect.get(bd.getUnitCode());
            bd.setEffectDetail(detail == null ? Lists.newArrayList() : detail);
        });*/

        result.setBrand(brandData);

        return result;
    }

    @Override
    public String satisfactionRealityDate(Integer year, Integer quarter) {
        Assert.notNull(year, "查询年不能为空！");
        Assert.notNull(quarter, "查询季度不能为空！");
        BizReformSatisfactionManagement  satisfaction = satisfacttMangerDao.queryLatest(year, quarter);
        String str = "";

           Integer now = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);

        if(satisfaction!=null){
            if(satisfaction.getScoringYear().compareTo(year)==0 && satisfaction.getScoringQuarter().compareTo(quarter) == 0){
                str = "";
            }else{
                if (now>=quarter){
                    str = "注：本数据列表展示的是"+satisfaction.getScoringYear()+"年第"+satisfaction.getScoringQuarter()+"季度的满意度调查数据，暂无"+year+"年第"+quarter+"季度满意度调查结果。";
                }else {
                    str = "注：暂无"+year+"年第"+quarter+"季度满意度调查结果。";
                }

            }
        }else{
            str = "注：目前还没有上传满意度调查结论或满意度调查还没通过审批。";
        }
        return str;
    }

    @Override
    public List<BizEffectEffectiveness> brandReformDetails(String unitCode, Integer year, Integer quarter,QueryFilter<BizEffectEffectiveness> queryFilter) {
        Assert.notNull(unitCode, "区县编码不能为空！");
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        Org org = orgManager.getByCode(unitCode);
        Assert.notNull(org, "传入的编码未找到区县数据！");
        String unitId = org.getId();
        List<BizEffectEffectiveness> list = effectManager.brandDetails(unitId, year,quarter,queryFilter);
//        if(BeanUtils.isNotEmpty(list)){
//            for(BizEffectEffectiveness record:list){
//                QueryWrapper<DefaultFile> fileQuery = new QueryWrapper<>();
//                fileQuery.eq("biz_id_",record.getId());
//                List<DefaultFile> filesList = fileManager.list(fileQuery);
//                record.setFiles(filesList);
//            }
//        }
        return list;
    }

    @Override
    public List<BizScoringCountyBrand> citywidePromotionRank(Integer year,Integer quarter,Integer type) {
        // 获取当前年,季度
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        List<BizScoringCountyBrand> brandList = brandDao.queryLatest(year, quarter, null,null);
        List<BizScoringCountyBrand> lastBrandList = brandDao.queryLatest(year, quarter-1, null,null);
        Map<String, List<BizScoringCountyBrand>> lastBrandMap = lastBrandList.stream().collect(Collectors.groupingBy(BizScoringCountyBrand::getUnitCode));
        if(brandList!=null && brandList.size()>0){
            brandList.forEach(brand->{
//                brand.setNationwideAndmediaNum(brand.getNationwideNum()+brand.getMediaNum());
                if(!lastBrandMap.isEmpty()){
                    BizScoringCountyBrand lastBrand = lastBrandMap.get(brand.getUnitCode()).get(0);
                    if(lastBrand!=null){
                        brand.setCitySnTrend(lastBrand.getCitySn() - brand.getCitySn());
                        brand.setBrandAllSnTrend(lastBrand.getBrandAllSn()-brand.getBrandAllSn());
                    }else{
                        brand.setCitySnTrend(0);
                        brand.setBrandAllSnTrend(0);
                    }
                }else{
                    brand.setCitySnTrend(0);
                    brand.setBrandAllSnTrend(0);
                }
            });
          /*  if(type == 1){
                brandList = brandList.stream().sorted((s1, s2) -> -s1.getCityNum().compareTo(s2.getCityNum())).collect(Collectors.toList());
                List<Map.Entry<Integer, List<BizScoringCountyBrand>>> nationwideSnList = brandList.stream().collect(Collectors.groupingBy(BizScoringCountyBrand::getCityNum)).entrySet()
                        .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
            }else if(type == 2) {
                //全国推广与媒体次数的全市排名
                brandList = brandList.stream().sorted((s1, s2) -> -s1.getNationwideAndmediaNum().compareTo(s2.getNationwideAndmediaNum())).collect(Collectors.toList());
                List<Map.Entry<Integer, List<BizScoringCountyBrand>>> nationwideSnList = brandList.stream().collect(Collectors.groupingBy(BizScoringCountyBrand::getNationwideAndmediaNum)).entrySet()
                        .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
                Integer index = 1;
                for (Map.Entry<Integer, List<BizScoringCountyBrand>> entry : nationwideSnList) {
                    for (BizScoringCountyBrand workable : entry.getValue()) {
                        workable.setNationwideAndmediaSn(index);
                    }
                    // 100 100 99 98 98 97 对应名次 1 1 3 4 4 6
                    index = index + entry.getValue().size();
                    // 100 100 99 98 98 97 对应名次 1 1 2 3 3 4
                    //index = ++index;
                }
            }*/

        }
        return brandList;
    }

    @Override
    public PageList<BizEffectEffectiveness> cityPromotionDetail(QueryFilter<BizEffectEffectiveness> queryFilter) {
        return effectManager.cityPromotionDetail(queryFilter);
    }

    @Override
    public JSONArray gisIndex(String type,Integer year,Integer quarter) {
        JSONArray result = new JSONArray();
        // 获取当前年,季度
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        QueryWrapper wrapper = new QueryWrapper<>().eq("FILL_YEAR_", year).eq("FILL_QUARTER_", quarter);
        switch (type) {
            // 综合评价指数
            // 改革满意度指数, 写入数据库时满意度写到综合里面了，这里一起拿
            case "satisfaction":
            case "composite":
                List<BizScoringCountySyn> synList = synDao.queryLatest(year, quarter, null, null);
                result.addAll(synList);
                break;
            // 改革落实力指数
            case "workable":
                List<BizScoringCountyWorkable> workable = workableDao.queryLatest(year, quarter, null, null);
                result.addAll(workable);
                break;
            // 品牌显示度指数
            case "brand":
                List<BizScoringCountyBrand> brand = brandDao.queryLatest(year, quarter, null, null);
                result.addAll(brand);
                break;
            // 风险管控力指数
            case "risk":
                List<BizReformRiskManagement> risk = riskDao.queyList(year,quarter,null,null,1);
                result.addAll(risk);
                break;
            default:
                throw new RuntimeException("type传递错误，允许的值：composite 综合评价指数、workable 改革落实力、brand 品牌显示度、satisfaction 改革满意度、risk 风险管控力");
        }
        return result;
    }
/*
    @Override
    public JSONObject demandHeatList(Integer year,Integer quarter) {
        JSONObject result = new JSONObject();
        // 获取当前年,季度
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }

        List<CountyChartVo> chartData = demandManager.chartDataForLargeScreen(year,quarter);
        result.put("chart", chartData);

        // 取出根数据并合并
        List<DemandAnalysisLibraryNumVo> demandData = demandAnalysisLibraryDao.countNum(year,quarter,null);

        QueryWrapper<BizReformDemandAssignment> queryWrapper =new QueryWrapper<>();
        queryWrapper.eq("year(MEETING_DATE_)", year).le("quarter(MEETING_DATE_)", quarter);
        int count = demandRecordMaanger.count(queryWrapper);
        if(count>0){
            for(DemandAnalysisLibraryNumVo numVo:demandData){
                int f =numVo.getListNum() + (5*numVo.getProjectNum());
                BigDecimal qualityRate = new BigDecimal(f).divide(new BigDecimal(count),2,BigDecimal.ROUND_HALF_UP);
                numVo.setQualityRate(qualityRate);
            }
        }
        result.put("demandRank", demandData);

        return result;
    }

    @Override
    public JSONObject demandDetailList(QueryFilter<BizReformDemandAssignment> queryFilter) {
        JSONObject result = new JSONObject();
        List<QueryField> querys = queryFilter.getQuerys();
        Object flagYear = null;
        Object flagQuarter = null;
        if (querys != null && querys.size() > 0) {
            for (QueryField field : querys) {
                if (field.getProperty().trim().toLowerCase().equals("a.propulsive_year_") || field.getProperty().trim().toLowerCase().equals("a.propulsiveyear")) {
                    flagYear = field.getValue();
                    continue;
                }
                if (field.getProperty().trim().toLowerCase().equals("a.propulsive_quarter_") || field.getProperty().trim().toLowerCase().equals("a.propulsivequarter")) {
                    flagQuarter = field.getValue();
                    continue;
                }

            }
        }
        if (flagYear == null) {
            flagYear = currentYear;
            queryFilter.addFilter("a.PROPULSIVE_YEAR_", flagYear, QueryOP.EQUAL);

        }
        if(flagQuarter == null){
            flagQuarter =currentQuarter;
            queryFilter.addFilter("a.PROPULSIVE_QUARTER_", flagQuarter, QueryOP.LESS_EQUAL);
        }
        // 所有统计数据
        List<BizReformDemandAnalysisLibrary> demandData = demandManager.list(new QueryWrapper<BizReformDemandAnalysisLibrary>().eq("DEMAND_YEAR_", flagYear).le("DEMAND_QUARTER_", flagQuarter).eq("STATUS_", 5));
        // 领域分类
        List<DictModel> ssly = sdm.queryDictListItemsByCode("ggbb_ssly");
        Map<Integer, List<BizReformDemandAnalysisLibrary>> domainGroupDeman = demandData.stream().collect(Collectors.groupingBy(BizReformDemandAnalysisLibrary::getDemandField));
        List<CountyChartVo> domainChart = Lists.newArrayList();
        domainGroupDeman.entrySet().forEach(en -> domainChart.add(new CountyChartVo(BizUtils.getDicValueByCode(ssly, en.getKey()), en.getValue().size())));
        result.put("domainChart", domainChart);
        // 过程管理
        List<DictModel> cyzt = sdm.queryDictListItemsByCode("ggbb_cyzt");
        Map<Integer, List<BizReformDemandAnalysisLibrary>> processGroupDeman = demandData.stream().collect(Collectors.groupingBy(BizReformDemandAnalysisLibrary::getDemandAdoptionStatus));
        List<CountyChartVo> processChart = Lists.newArrayList();
        processGroupDeman.entrySet().forEach(en -> processChart.add(new CountyChartVo(BizUtils.getDicValueByCode(cyzt, en.getKey()), en.getValue().size())));

        Map<Integer, List<BizReformDemandAssignment>> processStatuasGroup = demandRecordMaanger.list(new QueryWrapper<BizReformDemandAssignment>().eq("PROPULSIVE_YEAR_", flagYear).le("PROPULSIVE_QUARTER_",
                flagQuarter).isNotNull("DEMAND_STATUS_")).stream().collect(Collectors.groupingBy(BizReformDemandAssignment::getDemandStatus));
        AtomicInteger pushNum = new AtomicInteger();
        processStatuasGroup.entrySet().forEach(psg -> {
            if (psg.getKey() == 1) {
                pushNum.set(pushNum.get() + psg.getValue().size());
            }
            if (psg.getKey() == 2) {
                pushNum.set(pushNum.get() + psg.getValue().size());
            }
            if (psg.getKey() == 3) {
                processChart.add(new CountyChartVo("完成销号", psg.getValue().size()));
            }
        });
        processChart.add(new CountyChartVo("交办区县落实", pushNum.get()));
        result.put("processChart", processChart);

        // 清单数据
        queryFilter.addFilter("a.is_dele_", "0", QueryOP.EQUAL);
        PageList<DemandAssignmentVo> recordList = demandRecordMaanger.queryDemandAssignment(queryFilter);
        result.put("recordList", recordList);

        return result;
    }*/

    @Override
    public List<CountyChartVo> pilotLedger(Integer year, Integer quarter) {
        List<CountyChartVo> result = Lists.newArrayList();
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }

        List<DictModel> ssly = sdm.queryDictListItemsByCode("ggbb_ssly");
        List<DictModel> sdcj = sdm.queryDictListItemsByCode("sdcj");
        List<DictModel> tjzt = sdm.queryDictListItemsByCode("sd_tjzt");
        QueryWrapper<BizReformPilotManagement> queryWrapper= new QueryWrapper<BizReformPilotManagement>();
        Integer finalYear = year;
        Integer finalQuarter = quarter;

//        queryWrapper.eq("STATUS_",5).inSql("ID_","SELECT PILOT_ID_ FROM BIZ_PILOT_ADVANCE_RECORD WHERE IS_DELE_='0' AND STATUS_=12")
//
//                .and(q -> q.lt("YEAR(START_TIME_)",finalYear).or(qr -> qr.eq("YEAR(START_TIME_)", finalYear).le("QUARTER(START_TIME_)", finalQuarter)));
//        List<BizReformPilotManagement> pilots = reformPilotManager.list(queryWrapper);
        List<BizReformPilotManagement> pilots = reformPilotManager.pilotLedger(year, quarter);
        Map<Integer, List<BizReformPilotManagement>> pilotsLevelGroup = pilots.stream().collect(Collectors.groupingBy(BizReformPilotManagement::getPilotLevel));
        pilotsLevelGroup.entrySet().forEach(en -> {
            CountyChartVo level = new CountyChartVo(BizUtils.getDicValueByCode(sdcj, en.getKey()), en.getValue().size());
            Map<String, List<CountyChartVo>> subData = Maps.newHashMap();
            List<CountyChartVo> field = Lists.newArrayList();
            Map<Integer, List<BizReformPilotManagement>> fieldMap = en.getValue().stream().filter(e -> e.getPilotField() != null).collect(Collectors.groupingBy(BizReformPilotManagement::getPilotField));
            ssly.forEach(dictModel -> {
                int size = 0;
                if(fieldMap.get(Integer.valueOf(dictModel.getValue()))!=null){
                    size = fieldMap.get(Integer.valueOf(dictModel.getValue())).size();
                }
                field.add(new CountyChartVo(BizUtils.getDicValueByCode(ssly, dictModel.getValue()), size));

            });

           //en.getValue().stream().filter(e -> e.getPilotField() != null).collect(Collectors.groupingBy(BizReformPilotManagement::getPilotField)).entrySet().forEach(fen -> field.add(new CountyChartVo
            // (BizUtils.getDicValueByCode(ssly, fen.getKey()), fen.getValue().size())));

            subData.put("field", field);

            List<CountyChartVo> ledger = Lists.newArrayList();
            long n = en.getValue().stream().filter(e -> e.getPropulsiveStatus() == null).count();
            Map<Integer, List<BizReformPilotManagement>> ledgerMap = en.getValue().stream().filter(e -> e.getPropulsiveStatus() != null).collect(Collectors.groupingBy(BizReformPilotManagement::getPropulsiveStatus));
            tjzt.forEach(dictModel -> {
                int size = 0;
                if(ledgerMap.get(Integer.valueOf(dictModel.getValue()))!=null){
                    size = ledgerMap.get(Integer.valueOf(dictModel.getValue())).size();
                }
                if(dictModel.getValue().equals("1")){
                    ledger.add(new CountyChartVo(BizUtils.getDicValueByCode(tjzt, dictModel.getValue()), Math.toIntExact(size + n)));
                } else{
                    ledger.add(new CountyChartVo(BizUtils.getDicValueByCode(tjzt, dictModel.getValue()), size));
                }

            });
           // Map<String,List<BizReformPilotManagement>> map = en.getValue().stream().filter(e -> e.getPropulsiveStatus() != null).collect(Collectors.groupingBy(BizReformPilotManagement::getPropulsiveStatus));
                    /*     map.entrySet().forEach(pen ->{
                             if(pen.getKey()==1){
                                ledger.add(new CountyChartVo(BizUtils.getDicValueByCode(tjzt, pen.getKey()), Math.toIntExact(pen.getValue().size() + n)));
                            }else{
                                 ledger.add(new CountyChartVo(BizUtils.getDicValueByCode(tjzt, pen.getKey()), pen.getValue().size()));
                             }
                         }
                   );*/
            subData.put("ledger", ledger);

            level.setSubData(subData);
            result.add(level);

        });

        return result;
    }

    @Override
    public PageList<BizReformPilotManagement> pilotLedgerDetail(QueryFilter<BizReformPilotManagement> queryFilter) {
        PageList<BizReformPilotManagement> data = reformPilotManager.queryDetail(queryFilter);
        return data;
    }

    @Override
    public PageList<BizReformPilotManagement> pilotLedgerDetailSpc(QueryFilter<BizReformPilotManagement> queryFilter) {
        PageList<BizReformPilotManagement> data = reformPilotManager.queryDetailSpc(queryFilter);
        return data;
    }

    @Override
    public  BizReformPilotManagement pilotPushDetail(String pilotId,String unitCode){
        Assert.hasText(pilotId,"请选择试点项目");
        Assert.hasText(unitCode,"请选择试点项目的推进区县");
        BizReformPilotManagement pilotManagement =reformPilotManager.getById(pilotId);
        if(pilotManagement!=null){
            List<BizPilotAdvanceRecord> list = pilotRecordDao.queryLatest(pilotId,null,unitCode);
            if(list!=null && list.size()>0){
                BizPilotAdvanceRecord record =  list.get(0);
                QueryWrapper<BizPilotAdvanceResult> queryWrapper = new QueryWrapper<>();
                queryWrapper.eq("PILOT_ID_", pilotId);
                queryWrapper.eq("RECORD_ID_",record.getId());

                pilotManagement.setExistingProblems(record == null ? null : record.getExistingProblems());
                pilotManagement.setWorkPlan(record == null ? null : record.getWorkPlan());
                pilotManagement.setPropulDetails(record == null ? null : record.getPropulsiveDetails());
                pilotManagement.setRecordsStatus(record.getStatus());
                List<PilotAdvanceResultNumVo> rList = pilotResultDao.countByPilot(pilotId,null,null,unitCode);
               // List<BizPilotAdvanceResult> rList = pilotResultManager.list(queryWrapper);
                pilotManagement.setResultNumList(rList);
                pilotManagement.setAncPropulsiveStatus(record.getPropulsiveStatus());
            }
        }
        return pilotManagement;
    }

    @Override
    public JSONObject historyStatementFile(Integer year) {
        JSONObject result = new JSONObject();

        // 满意度历史报告
        List<BizReformSatisfactionManagement> satisList = satisfactionManager
                .list(new QueryWrapper<BizReformSatisfactionManagement>()
                        .eq("STATUS_", 5)
                        .eq("is_dele_", 0)
                        .eq("SCORING_YEAR_", year == null ? currentYear : year));
        List<String> satisfactionIDs = satisList.stream().map(BizReformSatisfactionManagement::getId).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(satisfactionIDs)) {
            List<DefaultFile> satFiles = fileManager.list(new QueryWrapper<DefaultFile>().in("biz_id_", satisfactionIDs));
            // 添加季度数据并分组
            JSONObject quarterGroup = new JSONObject();
            satisList.forEach(s -> satFiles
                    .stream()
                    .filter(sf -> s.getId().equals(sf.getBizId()))
                    .forEach(sf -> quarterGroup.put(String.valueOf(s.getScoringQuarter()), sf))
            );
            result.put("satisfaction", BeanUtils.isNotEmpty(satFiles) ? quarterGroup : currentYear + "年" + " 暂无满意度报告数据！");
        } else {
            result.put("satisfaction", currentYear + "年" + " 暂无满意度报告数据！");
        }

        // 满意度历史报告
        List<BizReformWorkReport> reportList = reportManager
                .list(new QueryWrapper<BizReformWorkReport>()
                        .eq("is_dele_", 0)
                        .orderByDesc("REPORT_DATE_")
                        .last("limit 1"));
        List<String> reportIDs = reportList.stream().map(BizReformWorkReport::getId).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(reportIDs)) {
            List<DefaultFile> reportFiles = fileManager.list(new QueryWrapper<DefaultFile>().in("biz_id_", reportIDs));
            // 添加季度数据并分组
            JSONObject quarterGroup = new JSONObject();
            reportList.forEach(r -> reportFiles
                    .stream()
                    .filter(rf -> r.getId().equals(rf.getBizId()))
                    .forEach(rf -> quarterGroup.put(String.valueOf(r.getReportQuarter()), rf))
            );
            result.put("composite", BeanUtils.isNotEmpty(reportFiles) ? quarterGroup : currentYear + "年 暂无满意度报告数据！");
        } else {
            result.put("composite", currentYear + "年 暂无满意度报告数据！");
        }

        return result;
    }

    @Override
    public JSONObject currentStatementFile(Integer year,Integer quarter) {
        JSONObject result = new JSONObject();
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        // 满意度报告
        BizReformSatisfactionManagement satis = satisfactionManager
                .getOne(new QueryWrapper<BizReformSatisfactionManagement>()
                        .eq("STATUS_", 5)
                        .eq("is_dele_", 0)
                        .eq("SCORING_YEAR_", year)
                        .eq("SCORING_QUARTER_", quarter ));
        String currentSatisId = BeanUtils.isNotEmpty(satis) ? satis.getId() : null;
        DefaultFile satisCurrentFile = fileManager.getOne(new QueryWrapper<DefaultFile>().eq("biz_id_", currentSatisId));
        result.put("satisfaction", satisCurrentFile);
        // 综合报告
        BizReformWorkReport report = reportManager
                .getOne(new QueryWrapper<BizReformWorkReport>()
                        .eq("is_dele_", 0)
                        .eq("REPORT_YEAR_",year)
                        .eq("REPORT_QUARTER_",quarter)
                        .orderByDesc("REPORT_DATE_")
                        .last("limit 1"));
        String reportId = BeanUtils.isNotEmpty(report) ? report.getId() : null;
        DefaultFile reportCurrentFile = fileManager.getOne(new QueryWrapper<DefaultFile>().eq("biz_id_", reportId));
        result.put("composite", reportCurrentFile);

        return result;
    }

    @Override
    public CoreIndexVo queryCoreIndex(String unitCode, Integer year, Integer quarter) {
        Assert.hasText(unitCode, "查询区县核心指数的区县编码不能为空！");
        // 获取当前年,季度
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        //查询最新数据
        List<BizScoringCountyBrand> currentBrands = brandDao.queryLatest(year, quarter, null, unitCode);
        List<BizScoringCountyWorkable> currentWorkables = workableDao.queryLatest(year, quarter, null, unitCode);
        List<BizScoringCountySyn> currentSyns = synDao.queryLatest(year, quarter, null, unitCode);
        List<BizScoringCountyMajor> currentMajors = majorDao.queryLatest(year, quarter, null, unitCode);
        //查询上一季度
        List<BizScoringCountyBrand> lastBrands = new ArrayList<>();
        List<BizScoringCountyWorkable> lastWorkables = new ArrayList<>();
        List<BizScoringCountySyn> lastSyns = new ArrayList<>();
        List<BizScoringCountyMajor> lastMajors = new ArrayList<>();
        if (quarter != 1) {
            int lastQuarter = quarter - 1;
            lastBrands = brandDao.queryLatest(year, lastQuarter, "Q", unitCode);
            lastWorkables = workableDao.queryLatest(year, lastQuarter, "Q", unitCode);
            lastSyns = synDao.queryLatest(year, lastQuarter, "Q", unitCode);
            lastMajors=majorDao.queryLatest(year,lastQuarter,"Q",unitCode);
        }

        CoreIndexVo coreIndexVo = new CoreIndexVo();
        //总档位及满意度
        if (currentSyns != null && currentSyns.size() > 0) {
            BizScoringCountySyn currentSyn = currentSyns.get(0);
            coreIndexVo.setFillDate(currentSyn.getFillDate());
            coreIndexVo.setFillYear(currentSyn.getFillYear());
            coreIndexVo.setUnitCode(unitCode);
            coreIndexVo.setUnitName(currentSyn.getUnitName());
            coreIndexVo.setUnitGrade(currentSyn.getUnitGrade());
            coreIndexVo.setSatisfied(currentSyn.getSatisfied());
            coreIndexVo.setSatisfiedAllSn(currentSyn.getSatisfiedAllSn() == null ? 0 : currentSyn.getSatisfiedAllSn());
            coreIndexVo.setSatisfiedGrade(currentSyn.getSatisfiedGrade());

            coreIndexVo.setScore(currentSyn.getScore());
            coreIndexVo.setAllSn(currentSyn.getAllSn());
            coreIndexVo.setAllGrade(currentSyn.getGrade());

            if (lastSyns != null && lastSyns.size() > 0) {
                int satisfiedTrend =0;
                if(currentSyn.getSatisfiedAllSn()!=null && lastSyns.get(0).getSatisfiedAllSn()!=null){
                    satisfiedTrend = lastSyns.get(0).getSatisfiedAllSn() - currentSyn.getSatisfiedAllSn();
                }
                coreIndexVo.setSatisfiedAllTrend(satisfiedTrend);

                int allTrend =0;
                if(currentSyn.getAllSn()!=null && lastSyns.get(0).getAllSn()!=null){
                    allTrend = lastSyns.get(0).getAllSn() - currentSyn.getAllSn();
                }
                coreIndexVo.setAllTrend(allTrend);
            } else {
                coreIndexVo.setSatisfiedAllTrend(0);
                coreIndexVo.setAllTrend(0);
            }
        }

      //五大板块:数数字重庆建设进展，国企改革进展，制造业“亩均论英雄”改革进展，建立企业上市助推机制进，打造“信用重庆”升级版进展
        if (currentMajors!=null&&currentMajors.size()>0){
            BizScoringCountyMajor major = currentMajors.get(0);
            coreIndexVo.setDigitRate(major.getDigitRate());
            coreIndexVo.setDigitGrade(major.getDigitGrade());
            coreIndexVo.setDigitSn(major.getDigitSn());
            coreIndexVo.setReformRate(major.getReformRate());
            coreIndexVo.setReformGrade(major.getReformGrade());
            coreIndexVo.setReformSn(major.getReformSn());
            coreIndexVo.setManufacturingIndustryRate(major.getManufacturingIndustryRate());
            coreIndexVo.setManufacturingIndustryGrade(major.getManufacturingIndustryGrade());
            coreIndexVo.setManufacturingIndustrySn(major.getManufacturingIndustrySn());
            coreIndexVo.setListedCompaniesDivide(major.getListedCompaniesDivide());
            coreIndexVo.setListedCompaniesGrade(major.getListedCompaniesGrade());
            coreIndexVo.setListedCompaniesSn(major.getListedCompaniesSn());
            coreIndexVo.setCreditRate(major.getCreditRate());
            coreIndexVo.setCreditGrade(major.getCreditGrade());
            coreIndexVo.setCreditSn(major.getCreditSn());
            if (lastMajors != null && lastMajors.size() > 0) {
                int digitTrend=0;
                int reformTrend=0;
                int manufacturingIndustryTrend=0;
                int listedCompaniesTrend=0;
                int creditTrend=0;

                if(lastMajors.get(0).getDigitSn()!=null&&major.getDigitSn()!=null)
                    digitTrend = lastMajors.get(0).getDigitSn() - major.getDigitSn();
                if(lastMajors.get(0).getReformSn()!=null&&major.getReformSn()!=null)
                    reformTrend = lastMajors.get(0).getReformSn() - major.getReformSn();
                if(lastMajors.get(0).getManufacturingIndustrySn()!=null&&major.getManufacturingIndustrySn()!=null)
                    manufacturingIndustryTrend = lastMajors.get(0).getManufacturingIndustrySn() - major.getManufacturingIndustrySn();
                if(lastMajors.get(0).getListedCompaniesSn()!=null&&major.getListedCompaniesSn()!=null)
                    listedCompaniesTrend = lastMajors.get(0).getListedCompaniesSn() - major.getListedCompaniesSn();
                if(lastMajors.get(0).getCreditSn()!=null&&major.getCreditSn()!=null)
                    creditTrend = lastMajors.get(0).getCreditSn() - major.getCreditSn();
                coreIndexVo.setDigitTrend(digitTrend);
                coreIndexVo.setReformTrend(reformTrend);
                coreIndexVo.setManufacturingIndustryTrend(manufacturingIndustryTrend);
                coreIndexVo.setListedCompaniesTrend(listedCompaniesTrend);
                coreIndexVo.setCreditTrend(creditTrend);
            } else {
                coreIndexVo.setDigitTrend(0);
                coreIndexVo.setReformTrend(0);
                coreIndexVo.setManufacturingIndustryTrend(0);
                coreIndexVo.setListedCompaniesTrend(0);
                coreIndexVo.setCreditTrend(0);
            }
        }
//改革试点板块
        if (currentWorkables != null && currentWorkables.size() > 0) {
            BizScoringCountyWorkable currentWorkable = currentWorkables.get(0);
            //国家级试点数量
            coreIndexVo.setNationalProjectNum(currentWorkable.getNationalProjectNum());
            coreIndexVo.setNationalProjectSn(currentWorkable.getNationalProjectSn());
            coreIndexVo.setNationalProjectGrade(currentWorkable.getNationalProjectGrade());
            //国家级试点验收率
            coreIndexVo.setNationalPassRate(currentWorkable.getNationalPassRate());
            coreIndexVo.setNationalPassSn(currentWorkable.getNationalPassSn());
            coreIndexVo.setNationalPassGrade(currentWorkable.getNationalPassGrade());
            //国家级新增试点数
            coreIndexVo.setNationalAddNum(currentWorkable.getNationalAddNum());
            coreIndexVo.setNationalAddGrade(currentWorkable.getNationalAddGrade());
            coreIndexVo.setNationalAddSn(currentWorkable.getNationalAddSn());

            if (lastWorkables != null && lastWorkables.size() > 0) {
                int nationalProjectTrend = lastWorkables.get(0).getNationalProjectSn() - currentWorkable.getNationalProjectSn();
                int nationalPassTrend = lastWorkables.get(0).getNationalPassSn() - currentWorkable.getNationalPassSn();
                int nationalAddTrend = lastWorkables.get(0).getNationalAddSn() - currentWorkable.getNationalAddSn();

                coreIndexVo.setNationalProjectTrend(nationalProjectTrend);
                coreIndexVo.setNationalPassTrend(nationalPassTrend);
                coreIndexVo.setNationalAddTrend(nationalAddTrend);
            } else {
                coreIndexVo.setNationalProjectTrend(0);
                coreIndexVo.setNationalPassTrend(0);
                coreIndexVo.setNationalAddTrend(0);
            }
        }
   //改革成效板块
        if (currentBrands != null && currentBrands.size() > 0) {
            BizScoringCountyBrand currentBrand = currentBrands.get(0);
            coreIndexVo.setNationwideNum(currentBrand.getNationwideNum());
            coreIndexVo.setNationwideSn(currentBrand.getNationwideSn());
            coreIndexVo.setNationwideGrade(currentBrand.getNationwideGrade());

            coreIndexVo.setCityNum(currentBrand.getCityNum());
            coreIndexVo.setCitySn(currentBrand.getCitySn());
            coreIndexVo.setCityGrade(currentBrand.getCityGrade());

            coreIndexVo.setBrandScore(currentBrand.getBrandScore());
            coreIndexVo.setBrandAllSn(currentBrand.getBrandAllSn());
            if (lastBrands != null && lastBrands.size() > 0) {
                int nationwideTrend = lastBrands.get(0).getNationwideSn() - currentBrand.getNationwideSn();
                int cityTrend = lastBrands.get(0).getCitySn() - currentBrand.getCitySn();
                coreIndexVo.setNationwideTrend(nationwideTrend);
                coreIndexVo.setCityTrend(cityTrend);
            } else {
                coreIndexVo.setNationwideTrend(0);
                coreIndexVo.setCityTrend(0);
                coreIndexVo.setBrandAllTrend(0);
            }
        }
//        if (quarter>2){
//            coreIndexVo.setAllSn(0);
//            coreIndexVo.setAllGrade(null);
//            coreIndexVo.setScore(new BigDecimal(0));
//            coreIndexVo.setDigitGrade(null);
//            coreIndexVo.setDigitSn(0);
//            coreIndexVo.setDigitTrend(0);
//            coreIndexVo.setReformTrend(0);
//            coreIndexVo.setManufacturingIndustryTrend(0);
//            coreIndexVo.setListedCompaniesTrend(0);
//            coreIndexVo.setCreditTrend(0);
//            //国家级试点数量
//            coreIndexVo.setNationalProjectSn(0);
//            coreIndexVo.setNationalProjectGrade(null);
//            //国家级试点验收率
//            coreIndexVo.setNationalPassSn(0);
//            coreIndexVo.setNationalPassGrade(null);
//            //国家级新增试点数
//            coreIndexVo.setNationalAddGrade(null);
//            coreIndexVo.setNationalAddSn(0);
//            coreIndexVo.setNationalProjectTrend(0);
//            coreIndexVo.setNationalPassTrend(0);
//            coreIndexVo.setNationalAddSn(0);
//            coreIndexVo.setBrandAllSn(0);
//            coreIndexVo.setNationwideSn(0);
//            coreIndexVo.setNationwideGrade(null);
//            coreIndexVo.setCitySn(0);
//            coreIndexVo.setCityGrade(null);
//            coreIndexVo.setNationwideTrend(0);
//            coreIndexVo.setCityTrend(0);
//            coreIndexVo.setBrandAllTrend(0);
//        }
        return coreIndexVo;
    }

    @Override
    public CoreIndexVo queryIndexSn(String unitCode, Integer year, Integer quarter) {
        Assert.hasText(unitCode, "查询区县核心指数的区县编码不能为空！");
        // 获取当前年,季度
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        List<BizScoringCountyWorkable> currentWorkables = workableDao.queryLatest(year, quarter, null, unitCode);
        List<BizScoringCountyWorkable> passAndPush = workableDao.queryPassAndPush(year,quarter, unitCode);
        List<BizScoringCountyWorkable> lastWorkables = new ArrayList<>();
        if (quarter != 1) {
            int lastQuarter = quarter - 1;
            lastWorkables = workableDao.queryLatest(year, lastQuarter, "Q", unitCode);

        }
        CoreIndexVo coreIndexVo = new CoreIndexVo();
        if (currentWorkables != null && currentWorkables.size() > 0) {
            BizScoringCountyWorkable workable = currentWorkables.get(0);
            coreIndexVo.setFillDate(workable.getFillDate());
            coreIndexVo.setFillYear(workable.getFillYear());
            coreIndexVo.setUnitCode(unitCode);
            coreIndexVo.setUnitName(workable.getUnitName());
            coreIndexVo.setUnitGrade(Integer.valueOf(workable.getUnitGrade()));
            coreIndexVo.setNationalProjectNum(workable.getNationalProjectNum());
            coreIndexVo.setNationalProjectSn(workable.getNationalProjectSn());
            coreIndexVo.setNationalAddNum(workable.getNationalAddNum());
            if (lastWorkables != null && lastWorkables.size() > 0) {
                int nationalProjectAdd = workable.getNationalProjectNum() - lastWorkables.get(0).getNationalProjectNum();
                int cityProjectAdd = workable.getCityProjectNum() - lastWorkables.get(0).getCityProjectNum();
                coreIndexVo.setNationalProjectAddNum(nationalProjectAdd);
                coreIndexVo.setCityProjectAddNum(cityProjectAdd);
            } else {
                coreIndexVo.setNationalProjectAddNum(workable.getNationalProjectNum());
                coreIndexVo.setCityProjectAddNum(workable.getCityProjectNum());
            }
            if (passAndPush != null && passAndPush.size() > 0) {
                coreIndexVo.setNationalPassNum(passAndPush.get(0).getNationalPassNum());
                coreIndexVo.setNationalPushNum(passAndPush.get(0).getNationalPushNum());
//                coreIndexVo.setCityPassNum(passAndPush.get(0).getCityPassNum());
                coreIndexVo.setCityPushNum(passAndPush.get(0).getCityPushNum());
            } else {
                coreIndexVo.setNationalPassNum(0);
                coreIndexVo.setNationalPushNum(0);
                coreIndexVo.setCityPushNum(0);
            }
        }
        return coreIndexVo;
    }

    @Override
    public List<StatementDetailVo> statementDetail(Integer year, Integer quarter) {
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        List<StatementDetailVo> result = synDao.statementDetail(year, quarter);
        if(!CollectionUtils.isEmpty(result)){
            List<CountySynVo> list  = synDao.indexSynRankBest(year,quarter);
            if(!CollectionUtils.isEmpty(list)){
                for(CountySynVo countySynVo:list){
                    if(countySynVo.getSynSn()<=9){
                        countySynVo.setSynGrade("A");
                    }else if(17 >= countySynVo.getSynSn() && countySynVo.getSynSn() > 9){
                        countySynVo.setSynGrade("B");
                    }else if(25 >= countySynVo.getSynSn() && countySynVo.getSynSn() > 17){
                        countySynVo.setSynGrade("C");
                    }else if(33 >= countySynVo.getSynSn() && countySynVo.getSynSn() > 25){
                        countySynVo.setSynGrade("D");
                    }else if(countySynVo.getSynSn() > 33){
                        countySynVo.setSynGrade("E");
                    }
                    for(StatementDetailVo statementDetailVo:result){
                        if(statementDetailVo.getUnitCode().equals(countySynVo.getUnitCode())){
                            statementDetailVo.setAllSn(countySynVo.getSynSn());
                            statementDetailVo.setAllGrade(countySynVo.getSynGrade());
                            statementDetailVo.setScore(new BigDecimal(countySynVo.getSynScore()==null?0:countySynVo.getSynScore()));
                            continue;
                        }
//                        if (quarter>2){
//                            statementDetailVo.setAllGrade(null);
//                            statementDetailVo.setNationalPassGrade(null);
//                            statementDetailVo.setWorkableAddGrade(null);
//                            statementDetailVo.setNationalProjectGrade(null);
//                            statementDetailVo.setNationwideGrade(null);
//                            statementDetailVo.setCityGrade(null);
//                        }
                    }
                }
            }
           result.sort(Comparator.comparingInt(StatementDetailVo::getAllSn).thenComparing(StatementDetailVo::getOrderNo));
        }


        return result;
    }

    @Override
    public JSONObject reformDemand(Integer year, Integer quarter,String unitCode) {
        Assert.notNull(unitCode, "区县编码不能为空！");
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        JSONObject result = new JSONObject();

        List<DictModel> cyzt = sdm.queryDictListItemsByCode("ggbb_cyzt");
        List<DictModel> xqzt = sdm.queryDictListItemsByCode("xqzt");
        List<BizReformDemandAnalysisLibrary> demandDataList =  demandManager.list(new QueryWrapper<BizReformDemandAnalysisLibrary>()
                .eq("RESPONSIBLE_UNIT_CODE_", unitCode)
                .eq("DEMAND_YEAR_", year)
                .le("DEMAND_QUARTER_", quarter)
                .eq("STATUS_", 5));
        Map<Integer, List<BizReformDemandAnalysisLibrary>> demandData =demandDataList.stream().collect(Collectors.groupingBy(BizReformDemandAnalysisLibrary::getDemandAdoptionStatus));
        Map<String,Integer> demandMap = new HashMap<>();
        demandMap.put("totlal", demandDataList.size());
        cyzt.forEach(dictModel -> {
            String key = "";
            if(dictModel.getValue().equals("1")){
                key="incomeNum";
            }else if(dictModel.getValue().equals("2")){
                key="assignNum";
            }else if(dictModel.getValue().equals("3")){
                key="projectNum";
            }else if(dictModel.getValue().equals("4")){
                key="stopNum";
            }
            if(demandData.get(Integer.valueOf(dictModel.getValue()))!=null){
                demandMap.put(key,demandData.get(Integer.valueOf(dictModel.getValue())).size());
            }else{
                demandMap.put(key,0);
            }
        });
        result.put("demand", demandMap);


        List<BizReformDemandAssignment>  assignmentList = demandRecordMaanger.list(new QueryWrapper<BizReformDemandAssignment>().eq("RESPONSIBLE_UNIT_CODE_", unitCode).eq("PROPULSIVE_YEAR_", year).le("PROPULSIVE_QUARTER_", quarter));
        Map<Integer, List<BizReformDemandAssignment>> fulfillData =assignmentList.stream().collect(Collectors.groupingBy(BizReformDemandAssignment::getDemandStatus));
        Map<String,Integer> fulfillMap = new HashMap<>();
        fulfillMap.put("totlal", fulfillData.size());
        xqzt.forEach(dictModel -> {
            String key = "undefined";
            if(dictModel.getValue().equals("1")){
                key="unStartNum";
            }else if(dictModel.getValue().equals("2")){
                key="pushNum";
            }else if(dictModel.getValue().equals("3")){
                key="endNum";
            }
            if(fulfillData.get(Integer.valueOf(dictModel.getValue()))!=null){
                fulfillMap.put(key,fulfillData.get(Integer.valueOf(dictModel.getValue())).size());
            }else{
                fulfillMap.put(key,0);
            }
        });

        result.put("fulfill", fulfillMap);

        return result;
    }

    @Override
    public JSONObject problemSolving(Integer year, Integer quarter, String unitCode) {
        Assert.notNull(unitCode, "区县编码不能为空！");
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        JSONObject result = new JSONObject();
        List<DictModel> tjztDict = sdm.queryDictListItemsByCode("tjzt");
        List <BizBlockageCardTransfer> list = transferManager.list(new QueryWrapper<BizBlockageCardTransfer>()
                .eq("IS_DELE_", "0")
                .eq("UNIT_CODE_", unitCode)
                .eq("BLOCKAGE_YEAR_", year)
                .le("BLOCKAGE_QUARTER_",quarter)
        );
        Map<Integer, List<BizBlockageCardTransfer>> countData =list.stream().collect(Collectors.groupingBy(BizBlockageCardTransfer::getPropulsiveStatus));
        Map<String,Integer> statisticsNum = new HashMap<>();
        statisticsNum.put("totlal", list.size());
        tjztDict.forEach(dictModel -> {
            String key = "undefined";
            if(dictModel.getValue().equals("1")){
                key="unStartNum";
            }else if(dictModel.getValue().equals("2")){
                key="pushNum";
            }else if(dictModel.getValue().equals("3")){
                key="endNum";
            }
            if(countData.get(Integer.valueOf(dictModel.getValue()))!=null){
                statisticsNum.put(key,countData.get(Integer.valueOf(dictModel.getValue())).size());
            }else{
                statisticsNum.put(key,0);
            }
        });
        result.put("count", statisticsNum);

        List<BizBlockageCardTransfer> detail = transferManager.problemSolvingDetail(unitCode, year,quarter);
        result.put("detail", detail);

        return result;
    }

    @Override
    public JSONObject brandBuild(Integer year, Integer quarter,String unitCode,QueryFilter<BizEffectEffectiveness> queryFilter) {
        Assert.notNull(unitCode, "区县编码不能为空！");
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }

        Org org = orgManager.getByCode(unitCode);
        Assert.notNull(org, "传入的编码未找到区县数据！");
        String unitId = org.getId();

        JSONObject result = new JSONObject();
        List<Integer> effectForm =new ArrayList<>();
        effectForm.add(1);
        effectForm.add(2);
//        effectForm.add(3);
        CountyBrandVo brandVo = brandReform(year, quarter,unitId,effectForm);
        result.put("count", brandVo.getChart());

        List<BizEffectEffectiveness> details = effectManager.brandDetails(unitId, year,quarter,queryFilter);
        result.put("details", details);

        return result;
    }

    @Override
    public PageList<BizReformPilotManagement> pilotLedgerDetailSec(QueryFilter<BizReformPilotManagement> queryFilter) {
        queryFilter.addFilter("m.STATUS_", 5, QueryOP.EQUAL);
        queryFilter.addFilter("m.is_dele_", "0", QueryOP.EQUAL);
        PageList<BizReformPilotManagement> data = reformPilotManager.queryDetailForUnit(queryFilter);
        return data;
    }

    @Override
    public BizReformSatisfactionManagement getByFiles(Integer year, Integer quarter) {
        Assert.notNull(year,"年份不能为空");
        Assert.notNull(quarter,"季度不能为空");
        QueryWrapper<BizReformSatisfactionManagement> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("SCORING_YEAR_",year);
        queryWrapper.eq("SCORING_QUARTER_",quarter);
        queryWrapper.eq("STATUS_",5);
        queryWrapper.eq("FILE_STATUS_",5);
        queryWrapper.orderByDesc("CREATE_TIME_");
        queryWrapper.last("LIMIT 1");
        BizReformSatisfactionManagement entity = bizReformSatisfactionManagementManager.getOne(queryWrapper);
        if (entity!=null){
            List<DefaultFile> files = fileManager.queryFileByBizId(entity.getId());
            entity.setFileList(files);
        }
        return entity;
    }

//    @Override
//    public Boolean isLook() {
//        IUser currentUser = ContextUtil.getCurrentUser();
//        if (currentUser.isAdmin())return true;
//        String userId = ContextUtil.getCurrentUserId();
//        List<String> list=new ArrayList();
//        list.add("1641808863084945408");
//        list.add("1641809040134905856");
//        list.add("1641810432106962944");
//        list.add("1641810569076154368");
//        list.add("1641810715616747520");
//        list.add("1641810850128076800");
//        list.add("1641810981120385024");
//        return list.contains(userId);
//    }
}
