package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.reform.majorProjects.manager.*;
import com.artfess.reform.majorProjects.model.*;
import com.artfess.reform.majorProjects.dao.PilotSpecificMeasuresHistoryDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.exception.BaseException;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 改革方案明确的具体举措迭代历史表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@Service
public class PilotSpecificMeasuresHistoryManagerImpl extends BaseManagerImpl<PilotSpecificMeasuresHistoryDao, PilotSpecificMeasuresHistory> implements PilotSpecificMeasuresHistoryManager {
@Resource
PilotSpecificMeasuresManager pilotSpecificMeasuresManager;
@Resource
    PilotSpecificScheduleManager pilotSpecificScheduleManager;
@Resource
PilotMeasuresPushManager pilotMeasuresPushManager;

    @Override
    public PageList<PilotSpecificMeasuresHistory> pageList(QueryFilter<PilotSpecificMeasuresHistory> queryFilter,boolean  isAffirm,boolean isInput) {
        if (!isAffirm&&!ContextUtil.getCurrentUser().isAdmin()){
            queryFilter.addFilter("m.UNIT_ID_",ContextUtil.getCurrentOrgId(),QueryOP.EQUAL);
        }
        queryFilter.addFilter("m.SEND_STATUS_","1",QueryOP.EQUAL);
        queryFilter.addFilter("m.PROJECT_TYPE_",1,QueryOP.EQUAL);
        queryFilter.addFilter("m.IS_DELE_","0",QueryOP.EQUAL);
        IPage<PilotSpecificMeasuresHistory> iPage = baseMapper.queryList(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()),isInput);
        return new PageList<>(iPage);
    }

    @Override
    public PageList<PilotSpecificMeasuresHistory> iterateInfo(QueryFilter<PilotSpecificMeasuresHistory> queryFilter) {
        queryFilter.addFilter("m.IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("h.IS_DELE_","0", QueryOP.EQUAL);
        IPage<PilotSpecificMeasuresHistory> iPage = baseMapper.iterateInfo(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }

    @Override
    public PageList<PilotSpecificMeasuresHistory> auditInfo(QueryFilter<PilotSpecificMeasuresHistory> queryFilter) {
        IPage<PilotSpecificMeasuresHistory> iPage = baseMapper.auditInfo(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }

    @Override
    public PageList<PilotSpecificMeasuresHistory> addInfo(QueryFilter<PilotSpecificMeasuresHistory> queryFilter) {
        queryFilter.addFilter("h.IS_DELE_","0",QueryOP.EQUAL);
        IPage<PilotSpecificMeasuresHistory> iPage = baseMapper.addInfo(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }

    @Override
    @Transactional
    public boolean deleteById(String id,boolean isAffirm) {
        Assert.notNull(id,"需要删除的数据id不能为空!!!");
        PilotSpecificMeasuresHistory entity = super.getById(id);
        if (isAffirm){
            if (entity.getSpecificMeasuresId()!=null){
                QueryWrapper<PilotSpecificMeasures> measuresWrapper=new QueryWrapper<>();
                measuresWrapper.eq("ID_",entity.getSpecificMeasuresId());
                pilotSpecificMeasuresManager.remove(measuresWrapper);
                //删除月度计划推进数据
                QueryWrapper<PilotSpecificSchedule> scheduleWrapper=new QueryWrapper<>();
                scheduleWrapper.eq("MEASURES_ID_",entity.getId());
                List<PilotSpecificSchedule> list = pilotSpecificScheduleManager.list(scheduleWrapper);
                if (list!=null&&list.size()>0) {
                    List<String> ids = list.stream().map(PilotSpecificSchedule::getId).collect(Collectors.toList());
                    pilotMeasuresPushManager.remove(new QueryWrapper<PilotMeasuresPush>().in("PLAN_ID_",ids));
                }
                //删除相关月度计划
                pilotSpecificScheduleManager.remove(scheduleWrapper);
                //删除之前相关联的历史数据
                QueryWrapper<PilotSpecificMeasuresHistory> measuresHisWrapper=new QueryWrapper<>();
                measuresHisWrapper.eq("SPECIFIC_MEASURES_ID_",entity.getSpecificMeasuresId());
                super.remove(measuresHisWrapper);
            }
        }else {
            if (entity.getStatus()==1||entity.getStatus()==3||entity.getStatus()==5) throw new BaseException("数据审核中!!!");
        }
        //删除迭代历史表数据
        return super.removeById(id);
    }
}
