package com.artfess.reform.majorProjects.dao;

import com.artfess.reform.majorProjects.model.PilotExperiencePush;
import com.artfess.reform.majorProjects.model.PilotSpecificSchedule;
import com.artfess.reform.statistics.vo.MonthPlanNumVO;
import com.artfess.reform.statistics.vo.MonthPlanTypeNumVO;
import com.artfess.reform.statistics.vo.ScheduleVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 进度计划表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
public interface PilotSpecificScheduleDao extends BaseMapper<PilotSpecificSchedule> {


    /**
    * @Description: 统计月度计划的完成数据
    * @param year 年
    * @param month 月
    * @param projectId   项目ID
    * @Return: com.artfess.reform.statistics.vo.MonthPlanNumVO
    * @Author: chens
    * @Date: 2023/4/26 10:56
    */
    MonthPlanNumVO queryMonthPlanNum(@Param("year") Integer year, @Param("month") Integer month, @Param("projectId") String projectId);

    /**
    * @Description: 查询各个项目的月度计划完成情况
    * @param year
    * @param month
    * @Return: java.util.List<com.artfess.reform.statistics.vo.MonthPlanNumVO>
    * @Author: chens
    * @Date: 2023/4/26 11:29
    */
    List<MonthPlanNumVO> queryMonthPlanNumAll(@Param("year") Integer year, @Param("month") Integer month, @Param("projectId") String projectId);

    /**
     * @Description: 查询各个项目的月度计划类型个数
     * @param year
     * @param month
     * @Return: java.util.List<com.artfess.reform.statistics.vo.MonthPlanNumVO>
     * @Author: chens
     * @Date: 2023/4/26 11:29
     */
    List<MonthPlanTypeNumVO>  queryMonthPlanNumForType(@Param("year") Integer year, @Param("month") Integer month, @Param("projectId") String projectId);

    /**
     * 查询成果榜统计和环比
     * @param year
     * @param month
     * @param type
     * @return
     */
    Integer achievementCount(@Param("projectId")String projectId,@Param("year") Integer year, @Param("month") Integer month, @Param("type") Integer type);

    /**
     * 各重大项目成果数量
     * @param year
     * @param month
     * @param type
     * @return
     */
    List<ScheduleVo> achievementInvCount(@Param("year") Integer year, @Param("month") Integer month);

    /**
     * 市级大屏进入各项目分驾驶舱月度计划清单查询
     */
    List<PilotSpecificSchedule> schedulePlanInfo(@Param("projectId")String projectId,@Param("year")Integer year,@Param("month")Integer month);

    /**
     * 导出excel查询月度计划推进信息
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<PilotSpecificSchedule> querySchedulePageInfo(IPage<PilotSpecificSchedule> convert2IPage,@Param(Constants.WRAPPER) Wrapper<PilotSpecificSchedule> convert2Wrapper);
}
