package com.artfess.reform.majorProjects.dao;

import com.artfess.reform.majorProjects.model.PilotSpecificMeasuresHistory;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 改革方案明确的具体举措迭代历史表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
public interface PilotSpecificMeasuresHistoryDao extends BaseMapper<PilotSpecificMeasuresHistory> {

    PilotSpecificMeasuresHistory findNewData(@Param("id")String id);

    /**
     * 主页面查询
     * @param convert2IPage
     * @param convert2Wrapper
     * @param isInput
     * @return
     */
    IPage<PilotSpecificMeasuresHistory> queryList(IPage<PilotSpecificMeasuresHistory> convert2IPage,
                                      @Param(Constants.WRAPPER) Wrapper<PilotSpecificMeasuresHistory> convert2Wrapper,
                                      @Param("isInput")boolean isInput);

    /**
     * 迭代原举措查询
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<PilotSpecificMeasuresHistory> iterateInfo(IPage<PilotSpecificMeasuresHistory> convert2IPage,
                                       @Param(Constants.WRAPPER) Wrapper<PilotSpecificMeasuresHistory> convert2Wrapper);

    /**
     * 审核页面查询
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<PilotSpecificMeasuresHistory> auditInfo(IPage<PilotSpecificMeasuresHistory> convert2IPage,
                                         @Param(Constants.WRAPPER) Wrapper<PilotSpecificMeasuresHistory> convert2Wrapper);

    /**
     * 新增举措查询
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<PilotSpecificMeasuresHistory> addInfo(IPage<PilotSpecificMeasuresHistory> convert2IPage,
                                                  @Param(Constants.WRAPPER) Wrapper<PilotSpecificMeasuresHistory> convert2Wrapper);


    List<PilotSpecificMeasuresHistory> pilotSpecificMeasuresHistoryInfo(@Param("projectId")String projectId, @Param("year")Integer year, @Param("month")Integer month);
}
