package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 成效晾晒比拼（品牌显示度）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-08
 */
@TableName("BIZ_EFFECT_DRYING_COMPETITION")
@ApiModel(value="BizEffectDryingCompetition对象", description="成效晾晒比拼（品牌显示度）")
@Data
public class BizEffectDryingCompetition extends AutoFillFullModel<BizEffectDryingCompetition> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "成效晾晒比拼表ID（关联成效晾晒比拼表ID，当选择为已有项目时自动填入以下主表字段）")
    @TableField("DEMAND_ANALYSIS_LIBRARY_ID_")
    private String demandAnalysisLibraryId;

    @ApiModelProperty(value = "改革事项")
    @TableField("EFFECT_CARD_TOPIC_")
    private String effectCardTopic;

    @ApiModelProperty(value = "重大改革项目ID")
    @TableField("PROJECT_ID_")
    private Integer projectId;

    @ApiModelProperty(value = "是否重大改革项目（使用字典，0：是，1：否）")
    @TableField("SIGNIFICANT_")
    private Integer significant;

    @ApiModelProperty(value = "所属领域（使用字典，1：政治，2：经济，3：文化，4：社会，5：生态）")
    @TableField("EFFECT_FIELD_")
    private Integer effectField;

    @ApiModelProperty(value = "所属跑道（使用字典，1：党的建设，2：XX）")
    @TableField("EFFECT_RUNWAY_")
    private Integer effectRunway;

    @ApiModelProperty(value = "主责单位状态最后更新时间")
    @TableField("PROPULSIVE_UPDATE_DATE_")
    private LocalDateTime propulsiveUpdateDate;

    @ApiModelProperty(value = "更新状态（后端字段，0：已更新，1：未更新）")
    @TableField("PROPULSIVE_UPDATE_STATUS_")
    private Integer propulsiveUpdateStatus;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableLogic
    @TableField("IS_DELE_")
    private String isDele="0";


    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "审核状态（0：草稿，1：已录入待审核，2：审核驳回，3：审核通过【改革办待审核】 ， 4：改革办审核确认驳回 ， 5：改革办审核确认完成）")
    @TableField(exist = false)
    private Integer status;

    @ApiModelProperty(value = "成效日期")
    @TableField(exist = false)
    private LocalDate completionDate;

    @ApiModelProperty(value = "成效形式（使用字典，1：获全国性肯定评价，2：获全市推广，3：被5家中央媒体深度专题报道）")
    @TableField(exist = false)
    private Integer effectForm;

    @ApiModelProperty("成效记录")
    @TableField(exist = false)
    private List<BizEffectEffectiveness> records;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("提交审核日期")
    @TableField(exist = false)
    private Date operateDate;

    @ApiModelProperty("附件集合")
    @TableField(exist = false)
    private List<String> ids;


}
