package com.artfess.reform.fill.manager.impl;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.*;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.fill.dto.OneThingsDTO;
import com.artfess.reform.fill.manager.BizDigitalOneThingManager;
import com.artfess.reform.fill.model.BizDigitalConstruction;
import com.artfess.reform.fill.model.BizDigitalOnLineApplication;
import com.artfess.reform.fill.model.BizDigitalOneThing;
import com.artfess.reform.fill.dao.BizDigitalOneThingDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.fill.vo.OneThingsVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.List;

/**
 * 围绕重点领域策划推出“一件事”情况 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-08-23
 */
@Service
public class BizDigitalOneThingManagerImpl extends BaseManagerImpl<BizDigitalOneThingDao, BizDigitalOneThing> implements BizDigitalOneThingManager {
    @Resource
    FileManager fileManager;

    @Override
    public List<BizDigitalOneThing> selectByUnitId(String unitId) {
        List<BizDigitalOneThing> list = baseMapper.selectByUnitId(unitId);
        for (BizDigitalOneThing p : list) {
            //判断上传新一图两清单,改革办未通过时,是否超出时间范围
            if (p.getAuditTime() != null&&p.getIsBringInto()!=null&&(p.getIsBringInto()<5)){
                long days = ChronoUnit.DAYS.between(p.getAuditTime(),LocalDateTime.now());
                    if (30>days&&days>=25){
                        p.setIsBringInto(3);
                    }else if (days>=30){
                        p.setIsBringInto(4);
                    }
            }
            //查询附件
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        }
        return list;
    }

    @Override
    public List<BizDigitalOneThing> selectAuditById(String id) {
        List<BizDigitalOneThing> list = baseMapper.selectAuditById(id);
        list.stream().forEach(p->{
            //判断上传新一图两清单,改革办未通过时,是否超出时间范围
            if (p.getAuditTime() != null&&p.getIsBringInto()!=null&&(p.getIsBringInto()<5)){
                long days = ChronoUnit.DAYS.between(p.getAuditTime(),LocalDateTime.now());
                if (30>days&&days>=25){
                    p.setIsBringInto(3);
                }else if (days>=30){
                    p.setIsBringInto(4);
                }
            }
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        });
        return list;
    }

    @Override
    public List<BizDigitalOneThing> selectExamineById(String id,String unitId) {
        List<BizDigitalOneThing> list = baseMapper.selectExamineById(id,unitId);
        list.stream().forEach(p->{
            //判断上传新一图两清单,改革办未通过时,是否超出时间范围
            if (p.getAuditTime() != null&&p.getIsBringInto()!=null&&(p.getIsBringInto()<5)){
                long days = ChronoUnit.DAYS.between(p.getAuditTime(),LocalDateTime.now());
                if (30>days&&days>=25){
                    p.setIsBringInto(3);
                }else if (days>=30){
                    p.setIsBringInto(4);
                }
            }
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        });
        return list;
    }

    @Override
    public PageList<BizDigitalOneThing> queryByPage(QueryFilter<BizDigitalOneThing> queryFilter) {
        queryFilter.addFilter("o.NUM",1, QueryOP.EQUAL);
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("o.CREATE_ORG_ID_", Direction.ASC));
        queryFilter.setSorter(sorter);
        IPage<BizDigitalOneThing> iPage = baseMapper.queryByPage(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        iPage.getRecords().stream().forEach(p->{
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        });
        return new PageList<>(iPage);
    }

    @Override
    public PageList<BizDigitalOneThing> queryByPageAll(QueryFilter<BizDigitalOneThing> queryFilter) {
        queryFilter.addFilter("o.NUM",1, QueryOP.EQUAL);
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("o.CREATE_ORG_ID_",Direction.ASC));
        queryFilter.setSorter(sorter);
        IPage<BizDigitalOneThing> iPage = baseMapper.queryByPageAll(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        iPage.getRecords().stream().forEach(p->{
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        });
        return new PageList<>(iPage);
    }

    @Override
    public PageList<BizDigitalOneThing> queryByPageNew(QueryFilter<BizDigitalOneThing> queryFilter) {
        queryFilter.addFilter("o.NUM",1, QueryOP.EQUAL);
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("o.CREATE_ORG_ID_",Direction.ASC));
        queryFilter.setSorter(sorter);
        IPage<BizDigitalOneThing> iPage = baseMapper.queryByPageNew(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        iPage.getRecords().stream().forEach(p->{
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        });
        return new PageList<>(iPage);
    }

    @Override
    public PageList<BizDigitalOneThing> queryByPageHis(OneThingsDTO dto) {
        PageBean pageBean=new PageBean();
        if (dto.getPage()==null)dto.setPage(0);
        if (dto.getSize()==null)dto.setSize(20);
        pageBean.setPage(dto.getPage());
        pageBean.setPageSize(dto.getSize());
        if (dto.getSize()==0)dto.setSize(20);
        IPage<BizDigitalOneThing> page = baseMapper.queryByPageHis(convert2IPage(pageBean), dto.getName(), dto.getAppertainSystem(), dto.getAppertainSunway(), dto.getUnitName(),dto.getStatus(),dto.getAuditStatus(), dto.getIsDele());
        return new PageList<>(page);
    }
}
