package com.artfess.reform.fill.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizReformSatisfactionDistricts;
import com.artfess.reform.fill.model.BizReformSatisfactionManagement;
import com.artfess.reform.fill.model.BizReformWorkReport;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.fill.model.BizReformSatisfactionProject;
import com.artfess.reform.fill.manager.BizReformSatisfactionProjectManager;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目改革满意度管理 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-09
 */
@RestController
@RequestMapping("/fill/bizReformSatisfactionProject/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@Api(tags = "重大项目改革满意度管理")
public class BizReformSatisfactionProjectController extends BaseController<BizReformSatisfactionProjectManager, BizReformSatisfactionProject> {

    @Resource
    UniversalWayManager universalWayManager;
    @PostMapping("/save")
    @ApiOperation(value = "S-保存数据或者修改数据")
    public CommonResult saveOrUpdateAll(@ApiParam(name = "BizReformSatisfactionProject对象") @RequestBody BizReformSatisfactionProject bizReformSatisfactionProject) {
        String mes = bizReformSatisfactionProject.getId();
        bizReformSatisfactionProject.setIsDele("0");
        if (bizReformSatisfactionProject.getScoringDate()!=null){
            Map<String, Integer> map = universalWayManager.setDate(bizReformSatisfactionProject.getScoringDate());
            bizReformSatisfactionProject.setScoringYear(map.get("year"));
            bizReformSatisfactionProject.setScoringMonth(map.get("month"));
            bizReformSatisfactionProject.setScoringQuarter(map.get("quarter"));
        }
        baseService.saveOrUpdate(bizReformSatisfactionProject);
        //更新附件上传项目id
        if(BeanUtils.isNotEmpty(bizReformSatisfactionProject.getIds())){
            List<String> ids = bizReformSatisfactionProject.getIds();
            universalWayManager.attachmentUpdates(ids,bizReformSatisfactionProject.getId());
        }
        return new CommonResult(mes==null?"添加成功":"修改成功");
    }
    @PostMapping("/update")
    @ApiOperation(value = "S-修改数据")
    public CommonResult update(@RequestBody BizReformSatisfactionProject bizReformSatisfactionProject) {
        baseService.update(bizReformSatisfactionProject);
        return new CommonResult("修改成功");
    }
    @PostMapping("/delete")
    @ApiOperation(value = "S-根据id删除数据")
    public CommonResult deleteById(@ApiParam(name = "id") @RequestParam("id") String id) {
        String[] ids = id.split(",");
        for (String res : ids) {
            //删除对应文件
            universalWayManager.deleteFiles(res);
            //删除主数据
            baseService.removeByIds(res);
        }
        return new CommonResult("删除成功");
    }
    @PostMapping(value="/query", produces={"application/json; charset=utf-8" })
    @ApiOperation("S-分页查询主表和子表数据")
    public PageList<BizReformSatisfactionProject> query(@RequestBody QueryFilter<BizReformSatisfactionProject> queryFilter) {
        return baseService.pageList(queryFilter);
    }
}
