package com.artfess.reform.fill.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.reform.fill.dto.AssignmentDTO;
import com.artfess.reform.fill.dto.BlockageDTO;
import com.artfess.reform.fill.manager.BizProjectCooperativeUnitManager;
import com.artfess.reform.fill.manager.BizReformDemandAnalysisLibraryManager;
import com.artfess.reform.fill.model.BizProjectCooperativeUnit;
import com.artfess.reform.fill.model.BizReformDemandAnalysisLibrary;
import com.artfess.reform.fill.model.BizReformDemandAssignment;
import com.artfess.uc.api.impl.model.permission.OrgPermission;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.fill.model.BizBlockageCardTransfer;
import com.artfess.reform.fill.manager.BizBlockageCardTransferManager;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 堵点卡点转交办表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-08
 */
@RestController
@RequestMapping("/bizBlockageCardTransfer/v1/")
@Api(tags = "堵点卡点基础信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizBlockageCardTransferController extends BaseController<BizBlockageCardTransferManager, BizBlockageCardTransfer> {

    @Override
    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@RequestBody BizBlockageCardTransfer blockageCardTransfer) {
        String id = this.baseService.inertInfo(blockageCardTransfer);
        if(StringUtil.isEmpty(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<String>(true,"成功！",id);
    }

    @PostMapping("/updateInfo")
    @ApiOperation("更新实体")
    public CommonResult<String> updateInfo(@RequestBody BizBlockageCardTransfer bizBlockageCardTransfer) {
        if (baseService.records(bizBlockageCardTransfer.getId()).size()>0){
            return new CommonResult<>(false,"已提交推进记录的交办无法修改");
        }
        return super.updateById(bizBlockageCardTransfer);
    }

    @Override
    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
           return this.baseService.deleteById(id);
    }

    @PostMapping(value="/queryPageList", produces={"application/json; charset=utf-8" })
    @ApiOperation("录入界面的分页查询")
    public PageList<BizBlockageCardTransfer> queryPageList(@RequestBody QueryFilter<BizBlockageCardTransfer> queryFilter) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin() ) {
            queryFilter.addFilter("a.create_org_id_",ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        queryFilter.addFilter("a.is_dele_", "0", QueryOP.EQUAL);
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("a.last_time_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return baseService.queryPageList(queryFilter);
    }


    @PostMapping(value="/queryAudit", produces={"application/json; charset=utf-8" })
    @ApiOperation("审核分页查询")
    public PageList<BizBlockageCardTransfer> queryAudit(@RequestBody QueryFilter<BizBlockageCardTransfer> queryFilter,@RequestParam(name = "isAffirm",required = true) Boolean isAffirm) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin() && !isAffirm) {
            queryFilter.addFilter("a.UNIT_ID_",ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        queryFilter.addFilter("a.is_dele_", "0", QueryOP.EQUAL);
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("r.last_time_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return baseService.queryAudit(queryFilter);
    }

    @PostMapping("/queryById")
    @ApiOperation(value = "根据id查询交办详情与推进审批记录")
    public BizBlockageCardTransfer queryById(@RequestParam(name = "id",required = true) String id) {
        BizBlockageCardTransfer blockageCard =baseService.queryById(id);
        return blockageCard;
    }

}
