package com.artfess.reform.approvalLog.manager.impl;

import com.artfess.reform.approvalLog.manager.AuditResultManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.dao.AchieveStatusLogDao;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.approvalLog.model.AuditResult;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 *  服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-11
 */
@Service
public class AchieveStatusLogManagerImpl extends BaseManagerImpl<AchieveStatusLogDao, AchieveStatusLog> implements AchieveStatusLogManager {


    @Resource
    private AuditResultManager auditResultManager;

    @Override
    public void create(AchieveStatusLog achieveStatusLog) {
        HashMap<String, Object> map = new HashMap<>();
        map.put("BIZ_ID_", achieveStatusLog.getBizId());
        achieveStatusLog.setSn(this.getNextSequence(map));
       // achieveStatusLog.setSn(1);
        if(null == achieveStatusLog.getOperateDate()){
            achieveStatusLog.setOperateDate(LocalDateTime.now());
        }
        super.create(achieveStatusLog);
    }

    @Override
    @Transactional
    public boolean createAchieveStatusLogAndAuditResult(AchieveStatusLogAndAuditResultVo achieveStatusLogAndAuditResultVo) {
        // 1.保存操作记录
        AchieveStatusLog achieveStatusLog = new AchieveStatusLog();
        BeanUtils.copyProperties(achieveStatusLogAndAuditResultVo, achieveStatusLog);
        HashMap<String, Object> map = new HashMap<>();
        map.put("BIZ_ID_", achieveStatusLogAndAuditResultVo.getBizId());
        achieveStatusLog.setSn(this.getNextSequence(map));
       // achieveStatusLog.setSn(1);
        if(null == achieveStatusLog.getOperateDate()){
            achieveStatusLog.setOperateDate(LocalDateTime.now());
        }
        boolean b = this.save(achieveStatusLog);
        // 2.保存审批记录及审批意见
        //  2.1 通过BIZ_ID查询没有结束审批，如果不为空，当前审批人就是上一个的审核单位，并且就是下一次的发送人
        QueryWrapper<AuditResult> auditResultQueryWrapper = new QueryWrapper<>();
        auditResultQueryWrapper.eq("BIZ_ID_", achieveStatusLog.getBizId()).eq("APPROVAL_STATUS_", 0);
        List<AuditResult> auditResultList = auditResultManager.list(auditResultQueryWrapper);
        if(null != auditResultList && auditResultList.size() > 0){
            AuditResult auditResult = auditResultList.get(0);
            if(StringUtils.isNotBlank(achieveStatusLogAndAuditResultVo.getOperateDeptId())){
                auditResult.setReportUnitId(achieveStatusLogAndAuditResultVo.getOperateDeptId());
                auditResult.setReportUnitName(achieveStatusLogAndAuditResultVo.getOperateDeptName());
//                auditResult.setReportUnitCode(achieveStatusLogAndAuditResultVo.);
//                auditResult.setReportUnitGradee();
            }else {
                auditResult.setReportUnitId(achieveStatusLogAndAuditResultVo.getOperateOrgId());
                auditResult.setReportUnitName(achieveStatusLogAndAuditResultVo.getOperateOrgName());
            }
            auditResult.setReportId(achieveStatusLogAndAuditResultVo.getOperateUserId());
            auditResult.setReceiveName(achieveStatusLogAndAuditResultVo.getOperateOrgName());
            auditResult.setReceiveLoginAccount(ContextUtil.getCurrentUserAccount());
            auditResult.setReceiveTime(achieveStatusLogAndAuditResultVo.getOperateDate());
            auditResult.setApprovalResults(achieveStatusLogAndAuditResultVo.getApprovalResults());
            auditResult.setApprovalComments(achieveStatusLogAndAuditResultVo.getApprovalComments());
            auditResult.setApprovalStatus(1);
            auditResultManager.update(auditResult);
        }
        if(!achieveStatusLogAndAuditResultVo.isFinish()){
            AuditResult auditResult = new AuditResult();
            BeanUtils.copyProperties(achieveStatusLogAndAuditResultVo, auditResult);
            if(StringUtils.isNotBlank(achieveStatusLogAndAuditResultVo.getOperateDeptId())){
                auditResult.setSendDeptId(achieveStatusLogAndAuditResultVo.getOperateDeptId());
                auditResult.setSendDeptName(achieveStatusLogAndAuditResultVo.getOperateDeptName());
            }else {
                auditResult.setSendDeptId(achieveStatusLogAndAuditResultVo.getOperateOrgId());
                auditResult.setSendDeptName(achieveStatusLogAndAuditResultVo.getOperateOrgName());
            }
            auditResult.setSendUserId(achieveStatusLogAndAuditResultVo.getOperateUserId());
            auditResult.setSendUserName(achieveStatusLogAndAuditResultVo.getOperateOrgName());
            auditResult.setSendLoginName(ContextUtil.getCurrentUserAccount());
            auditResult.setSendDate(achieveStatusLog.getOperateDate());
            auditResult.setApprovalStatus(0);
            auditResultManager.save(auditResult);
        }
        return b;
    }

    @Override
    @Transactional
    public boolean createAchieveStatusLogAndAuditResultBatch(List<AchieveStatusLogAndAuditResultVo> achieveStatusLogAndAuditResultVoList) {
        // 1.保存操作记录
        if(null != achieveStatusLogAndAuditResultVoList && achieveStatusLogAndAuditResultVoList.size() > 0){
            List<AchieveStatusLog> achieveStatusLogList = new ArrayList<>(achieveStatusLogAndAuditResultVoList.size());
            List<AuditResult> auditResultSaveList = new ArrayList<>(achieveStatusLogAndAuditResultVoList.size());
            List<AuditResult> auditResultUpdateList = new ArrayList<>();
            for (AchieveStatusLogAndAuditResultVo achieveStatusLogAndAuditResultVo : achieveStatusLogAndAuditResultVoList){
                AchieveStatusLog achieveStatusLog = new AchieveStatusLog();
                BeanUtils.copyProperties(achieveStatusLogAndAuditResultVo, achieveStatusLog);
                HashMap<String, Object> map = new HashMap<>();
                map.put("BIZ_ID_", achieveStatusLogAndAuditResultVo.getBizId());
//                achieveStatusLog.setSn(this.getNextSequence(map));
                achieveStatusLog.setSn(1);
                if(null == achieveStatusLog.getOperateDate()){
                    achieveStatusLog.setOperateDate(LocalDateTime.now());
                }
                achieveStatusLogList.add(achieveStatusLog);
                // 2.保存审批记录及审批意见
                //  2.1 通过BIZ_ID查询没有结束审批，如果不为空，当前审批人就是上一个的审核单位，并且就是下一次的发送人
                QueryWrapper<AuditResult> auditResultQueryWrapper = new QueryWrapper<>();
                auditResultQueryWrapper.eq("BIZ_ID_", achieveStatusLog.getBizId()).eq("APPROVAL_STATUS_", 0);
                List<AuditResult> auditResultList = auditResultManager.list(auditResultQueryWrapper);
                if(null != auditResultList && auditResultList.size() > 0){
                    AuditResult auditResult = auditResultList.get(0);
                    if(StringUtils.isNotBlank(achieveStatusLogAndAuditResultVo.getOperateDeptId())){
                        auditResult.setReportUnitId(achieveStatusLogAndAuditResultVo.getOperateDeptId());
                        auditResult.setReportUnitName(achieveStatusLogAndAuditResultVo.getOperateDeptName());
//                auditResult.setReportUnitCode(achieveStatusLogAndAuditResultVo.);
//                auditResult.setReportUnitGradee();
                    }else {
                        auditResult.setReportUnitId(achieveStatusLogAndAuditResultVo.getOperateOrgId());
                        auditResult.setReportUnitName(achieveStatusLogAndAuditResultVo.getOperateOrgName());
                    }
                    auditResult.setReportId(achieveStatusLogAndAuditResultVo.getOperateUserId());
                    auditResult.setReceiveName(achieveStatusLogAndAuditResultVo.getOperateOrgName());
                    auditResult.setReceiveLoginAccount(ContextUtil.getCurrentUserAccount());
                    auditResult.setReceiveTime(achieveStatusLogAndAuditResultVo.getOperateDate());
                    auditResult.setApprovalResults(achieveStatusLogAndAuditResultVo.getApprovalResults());
                    auditResult.setApprovalComments(achieveStatusLogAndAuditResultVo.getApprovalComments());
                    auditResult.setApprovalStatus(1);
                    auditResultUpdateList.add(auditResult);
//                    auditResultManager.update(auditResult);
                }
                if(!achieveStatusLogAndAuditResultVo.isFinish()){
                    AuditResult auditResult = new AuditResult();
                    BeanUtils.copyProperties(achieveStatusLogAndAuditResultVo, auditResult);
                    if(StringUtils.isNotBlank(achieveStatusLogAndAuditResultVo.getOperateDeptId())){
                        auditResult.setSendDeptId(achieveStatusLogAndAuditResultVo.getOperateDeptId());
                        auditResult.setSendDeptName(achieveStatusLogAndAuditResultVo.getOperateDeptName());
                    }else {
                        auditResult.setSendDeptId(achieveStatusLogAndAuditResultVo.getOperateOrgId());
                        auditResult.setSendDeptName(achieveStatusLogAndAuditResultVo.getOperateOrgName());
                    }
                    auditResult.setSendUserId(achieveStatusLogAndAuditResultVo.getOperateUserId());
                    auditResult.setSendUserName(achieveStatusLogAndAuditResultVo.getOperateOrgName());
                    auditResult.setSendLoginName(ContextUtil.getCurrentUserAccount());
                    auditResult.setSendDate(achieveStatusLog.getOperateDate());
                    auditResult.setApprovalStatus(0);
                    auditResultSaveList.add(auditResult);
                }
            }
            boolean b = this.saveBatch(achieveStatusLogList);
            if(null != auditResultUpdateList && auditResultUpdateList.size() > 0){
                auditResultManager.saveOrUpdateBatch(auditResultUpdateList);
            }
            if(null != auditResultSaveList && auditResultSaveList.size() > 0){
                auditResultManager.saveBatch(auditResultSaveList);
            }
        }
        return true;
    }

    @Override
    public AchieveStatusLog queryAchieveStatusLogByBizIdAndStatus(String bizId,Integer status) {
        Assert.hasText("bizId", "业务ID不能为空！");
        QueryWrapper<AchieveStatusLog> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("BIZ_ID_", bizId);
        queryWrapper.eq(com.artfess.base.util.BeanUtils.isNotEmpty(status),"STATUS_", status);
        queryWrapper.orderByDesc("OPERATE_DATE_");
        queryWrapper.last(" limit 1");
        AchieveStatusLog log = this.baseMapper.selectOne(queryWrapper);
        return log;
    }

    @Override
    public List<AchieveStatusLog> process(String bizId) {
        Assert.notNull(bizId,"需要查询的id不能为空");
        List<AchieveStatusLog> list = super.list(new QueryWrapper<AchieveStatusLog>()
                .eq("BIZ_ID_", bizId)
                .orderByAsc("OPERATE_DATE_"));
        return list;
    }
}
