/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.statistics.schedule;

import com.artfess.reform.statistics.manager.BizScoringCountyBrandManager;
import com.artfess.reform.statistics.manager.BizScoringCountySynManager;
import com.artfess.reform.statistics.manager.BizScoringCountyWorkableManager;
import java.time.LocalDate;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class ScoreCalSchedule {
    @Resource
    BizScoringCountyWorkableManager workableManager;
    @Resource
    BizScoringCountyBrandManager brandManager;
    @Resource
    BizScoringCountySynManager synManager;

    @Scheduled(cron="0 50 23 * * ?")
    public void scheduleWorkable() {
        LocalDate countDate = LocalDate.now();
        this.workableManager.countScore(countDate);
        this.brandManager.countScore(countDate);
        this.synManager.countScore(countDate);
    }
}

