/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.statistics.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.fill.vo.SynReportVo;
import com.artfess.reform.majorProjects.dao.PilotSpecificSchedulePushDao;
import com.artfess.reform.majorProjects.vo.PilotQuantitativeTargetListVo;
import com.artfess.reform.statistics.dao.BizScoringProjectSynDao;
import com.artfess.reform.statistics.manager.BizScoringProjectSynManager;
import com.artfess.reform.statistics.model.BizScoringProjectSyn;
import com.artfess.reform.statistics.vo.ProjectRiskScoreVo;
import com.artfess.reform.statistics.vo.ProjectSynScoreVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BizScoringProjectSynManagerImpl
extends BaseManagerImpl<BizScoringProjectSynDao, BizScoringProjectSyn>
implements BizScoringProjectSynManager {
    @Resource
    PilotSpecificSchedulePushDao pilotSpecificSchedulePushDao;

    @Override
    public Map<String, Object> querySynReportByFillYearMonth(Integer fillYear, Integer fillMonth) {
        Calendar calendar;
        if (fillMonth > 12 || fillMonth < 1) {
            calendar = Calendar.getInstance();
            fillMonth = calendar.get(2) + 1;
        }
        if (fillYear == null) {
            calendar = Calendar.getInstance();
            fillYear = calendar.get(1);
        }
        String monthValueFieldName = "";
        if (fillMonth == 1) {
            monthValueFieldName = "JAN_VALUE_";
        } else if (fillMonth == 2) {
            monthValueFieldName = "FEB_VALUE_";
        } else if (fillMonth == 3) {
            monthValueFieldName = "MAR_VALUE_";
        } else if (fillMonth == 4) {
            monthValueFieldName = "APR_VALUE_";
        } else if (fillMonth == 5) {
            monthValueFieldName = "MAY_VALUE_";
        } else if (fillMonth == 6) {
            monthValueFieldName = "JUN_VALUE_";
        } else if (fillMonth == 7) {
            monthValueFieldName = "JUL_VALUE_";
        } else if (fillMonth == 8) {
            monthValueFieldName = "AUG_VALUE_";
        } else if (fillMonth == 9) {
            monthValueFieldName = "SEP_VALUE_";
        } else if (fillMonth == 10) {
            monthValueFieldName = "OCT_VALUE_";
        } else if (fillMonth == 11) {
            monthValueFieldName = "NOV_VALUE_";
        } else if (fillMonth == 12) {
            monthValueFieldName = "DEC_VALUE_";
        }
        List<PilotQuantitativeTargetListVo> scheduleList = this.pilotSpecificSchedulePushDao.queryTargetListByFillYearMonth(fillYear, fillMonth, monthValueFieldName);
        List<SynReportVo> list = ((BizScoringProjectSynDao)this.baseMapper).queryMonthReportByYearMonth(fillYear, fillMonth);
        HashMap<String, Object> report = new HashMap<String, Object>();
        report.put("target", scheduleList);
        report.put("syn", list);
        return report;
    }

    @Override
    public List<BizScoringProjectSyn> countScore(LocalDate countDate) {
        LocalDate now = LocalDate.now();
        if (countDate == null) {
            countDate = now;
        }
        LocalDate lastDay = countDate.with(TemporalAdjusters.lastDayOfMonth());
        List<ProjectRiskScoreVo> riskList = ((BizScoringProjectSynDao)this.baseMapper).statisticsRiskScore(countDate.getYear(), countDate.getMonthValue());
        List<ProjectSynScoreVo> synList = ((BizScoringProjectSynDao)this.baseMapper).statisticsSynScore(countDate);
        Map<String, ProjectRiskScoreVo> riskScoreMap = riskList.stream().collect(Collectors.toMap(ProjectRiskScoreVo::getProjectId, ProjectRiskScoreVo2 -> ProjectRiskScoreVo2));
        Map<String, ProjectSynScoreVo> synScoreMap = synList.stream().collect(Collectors.toMap(ProjectSynScoreVo::getProjectId, ProjectSynScoreVo2 -> ProjectSynScoreVo2));
        List<BizScoringProjectSyn> projectSynList = new ArrayList<BizScoringProjectSyn>();
        if (synScoreMap != null && synScoreMap.size() > 0) {
            int season = BizScoringProjectSynManagerImpl.getSeasonDay(countDate);
            String type = BizScoringProjectSynManagerImpl.getFillType(countDate);
            BizScoringProjectSyn scoringProjectSyn = null;
            for (String key : synScoreMap.keySet()) {
                scoringProjectSyn = new BizScoringProjectSyn();
                ProjectSynScoreVo synVo = synScoreMap.get(key);
                ProjectRiskScoreVo riskScore = riskScoreMap.get(key);
                if (riskScore != null) {
                    BigDecimal synAfterScore = synVo.getSynScore().subtract(riskScore.getScore());
                    scoringProjectSyn.setScore(synAfterScore);
                } else {
                    scoringProjectSyn.setScore(synVo.getSynScore());
                }
                scoringProjectSyn.setProjectId(key);
                scoringProjectSyn.setProjectName(synScoreMap.get(key).getProjectName());
                scoringProjectSyn.setFillDate(countDate);
                scoringProjectSyn.setFillYear(countDate.getYear());
                scoringProjectSyn.setFillQuarter(season);
                scoringProjectSyn.setFillMonth(countDate.getMonthValue());
                scoringProjectSyn.setFillType(type);
                scoringProjectSyn.setOpinionNum(riskScore.getTotleNum());
                scoringProjectSyn.setOpinionScore(riskScore.getScore());
                projectSynList.add(scoringProjectSyn);
            }
            List NO1List = new ArrayList();
            if (countDate.getMonthValue() != 1 && countDate.getDayOfMonth() == lastDay.getDayOfMonth()) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"ALL_SN_", (Object)1);
                queryWrapper.eq((Object)"FILL_YEAR_", (Object)countDate.getYear());
                queryWrapper.eq((Object)"FILL_MONTH_", (Object)(countDate.getMonthValue() - 1));
                queryWrapper.eq((Object)"FILL_TYPE_", (Object)"M");
                NO1List = ((BizScoringProjectSynDao)this.baseMapper).selectList((Wrapper)queryWrapper);
            }
            projectSynList = projectSynList.stream().sorted((s1, s2) -> -s1.getScore().compareTo(s2.getScore())).collect(Collectors.toList());
            List snlist = projectSynList.stream().collect(Collectors.groupingBy(BizScoringProjectSyn::getScore)).entrySet().stream().sorted((s1, s2) -> -((BigDecimal)s1.getKey()).compareTo((BigDecimal)s2.getKey())).collect(Collectors.toList());
            Integer index = 1;
            for (Map.Entry entry : snlist) {
                block2: for (BizScoringProjectSyn syn : (List)entry.getValue()) {
                    syn.setAllSn(index);
                    if (lastDay.getDayOfMonth() != countDate.getDayOfMonth()) continue;
                    if ((NO1List == null || NO1List.size() == 0) && index == 1) {
                        syn.setHoldNum(0);
                        continue;
                    }
                    if (NO1List == null || NO1List.size() <= 0 || index != 1) continue;
                    for (BizScoringProjectSyn NO1 : NO1List) {
                        if (NO1.getProjectId().equals(syn.getProjectId())) {
                            syn.setHoldNum(NO1.getHoldNum() + 1);
                            continue block2;
                        }
                        syn.setHoldNum(0);
                    }
                }
                index = index + ((List)entry.getValue()).size();
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"FILL_DATE_", (Object)countDate);
            ((BizScoringProjectSynDao)this.baseMapper).delete((Wrapper)queryWrapper);
            this.saveBatch(projectSynList);
        }
        return projectSynList;
    }

    public static String getFillType(LocalDate dateTime) {
        LocalDate lastDay;
        String type = "D";
        int month = dateTime.getMonthValue();
        int day = dateTime.getDayOfMonth();
        if (day == (lastDay = dateTime.with(TemporalAdjusters.lastDayOfMonth())).getDayOfMonth()) {
            type = "M";
            if (month == 3 || month == 6 || month == 9 || month == 12) {
                type = "Q";
            }
        }
        return type;
    }

    public static int getSeasonDay(LocalDate dateTime) {
        return Integer.valueOf(dateTime.getMonthValue() + 2) / 3;
    }
}

