/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.statistics.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.JsonUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.reform.fill.manager.BizBlockageCardTransferManager;
import com.artfess.reform.fill.manager.BizReformDemandAnalysisLibraryManager;
import com.artfess.reform.fill.manager.BizReformDemandAssignmentManager;
import com.artfess.reform.fill.manager.BizReformPilotManagementManager;
import com.artfess.reform.fill.manager.BizReformSatisfactionDistrictsManager;
import com.artfess.reform.fill.model.BizBlockageCardTransfer;
import com.artfess.reform.fill.model.BizEffectEffectiveness;
import com.artfess.reform.fill.model.BizPilotAdvanceResult;
import com.artfess.reform.fill.model.BizReformDemandAnalysisLibrary;
import com.artfess.reform.fill.model.BizReformDemandAssignment;
import com.artfess.reform.fill.model.BizReformPilotManagement;
import com.artfess.reform.fill.model.BizReformSatisfactionDistricts;
import com.artfess.reform.fill.vo.BlockageCardTransferVo;
import com.artfess.reform.fill.vo.DemandAssignmentVo;
import com.artfess.reform.statistics.manager.CountyLargeScreeManager;
import com.artfess.reform.statistics.model.BizScoringCountyBrand;
import com.artfess.reform.statistics.vo.CoreIndexVo;
import com.artfess.reform.statistics.vo.CountyBrandVo;
import com.artfess.reform.statistics.vo.CountyChartVo;
import com.artfess.reform.statistics.vo.CountyPilotReformVo;
import com.artfess.reform.statistics.vo.CountySynVo;
import com.artfess.reform.statistics.vo.StatementDetailVo;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u533a\u53bf\u6539\u9769\u62a5\u8868\u5927\u5c4f\u63a5\u53e3"})
@RequestMapping(value={"/county/largeScreen/v1/"})
@ApiGroup(group={"group_biz"})
public class CountyLargeScreeController {
    private static final Logger log = LoggerFactory.getLogger(CountyLargeScreeController.class);
    @Resource
    private CountyLargeScreeManager baseManager;
    @Resource
    private BizReformDemandAnalysisLibraryManager demandAnalysisLibraryManager;
    @Resource
    private BizReformDemandAssignmentManager demandRecordMaanger;
    @Resource
    private BizBlockageCardTransferManager blockageCardTransferManager;
    @Resource
    private BizReformSatisfactionDistrictsManager satisfactionDistrictsManager;
    @Resource
    private BizReformPilotManagementManager pilotManagementManager;
    @Resource
    private SysDictionaryDetailManager sysDictionaryDetailManager;

    @PostMapping(value={"/importantIndex"})
    @ApiOperation(value="\u91cd\u70b9\u5173\u6ce8", notes="\u91cd\u70b9\u5173\u6ce8")
    public CommonResult<String> importantIndex(@RequestParam(required=false) Integer year, @RequestParam(required=false) Integer quarter) {
        CoreIndexVo data = this.baseManager.importantIndex(year, quarter);
        return CommonResult.success((Object)data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/indexRank"})
    @ApiOperation(value="\u9010\u4f18\u699c", notes="\u8ffd\u9010\u4f18\u699c")
    public CommonResult<String> indexRank(@RequestParam(required=false) Integer year, @RequestParam(required=false) Integer quarter) {
        List<CountySynVo> data = this.baseManager.indexRank(year, quarter);
        return CommonResult.success(data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/pilotReform"})
    @ApiOperation(value="\u6539\u9769\u8bd5\u70b9", notes="")
    public CommonResult<String> pilotReform(@RequestParam(required=false) Integer year, @RequestParam(required=false) Integer quarter, @RequestParam(required=false) String unitCode) {
        Assert.isTrue((quarter == null || quarter >= 1 && quarter <= 4 ? 1 : 0) != 0, (String)"\u5b63\u5ea6\u4f20\u9012\u9519\u8bef\uff0c\u5141\u8bb8\u503c\u30101~4\u3011");
        CountyPilotReformVo data = this.baseManager.pilotReform(year, quarter, unitCode);
        return CommonResult.success((Object)data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/pilotResultDetail"})
    @ApiOperation(value="\u6539\u9769\u8bd5\u70b9\u6210\u679c\u8be6\u60c5", notes="\u5207\u6362\u6210\u679c\u7c7b\u578b\uff0c\u67e5\u8be2\u5b57\u6bb5RESULT_FORM_\uff0c\u53c2\u8003\u5b57\u5178ggsd_cgxs")
    public PageList<BizPilotAdvanceResult> pilotResultDetail(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BizPilotAdvanceResult> queryFilter) {
        return this.baseManager.pilotResultDetail(queryFilter);
    }

    @PostMapping(value={"/pilotLedger"})
    @ApiOperation(value="\u6539\u9769\u8bd5\u70b9\u53f0\u8d26")
    public CommonResult<String> pilotLedger(@RequestParam(required=false) Integer year, @RequestParam(required=false) Integer quarter) {
        List<CountyChartVo> data = this.baseManager.pilotLedger(year, quarter);
        return CommonResult.success(data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/pilotLedgerDetail"})
    @ApiOperation(value="\u6539\u9769\u8bd5\u70b9\u53f0\u8d26\u8be6\u60c5\u6570\u636e", notes="\u5207\u6362\u5c42\u7ea7\u53c2\u6570PILOT_LEVEL_\uff0c\uff08\u4f7f\u7528\u5b57\u5178\uff0c1\uff1a\u56fd\u5bb6\u7ea7\uff0c2\uff1a\u5e02\u7ea7\uff09")
    public PageList<BizReformPilotManagement> pilotLedgerDetail(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BizReformPilotManagement> queryFilter) {
        return this.baseManager.pilotLedgerDetail(queryFilter);
    }

    @PostMapping(value={"/pilotLedgerDetailExport"})
    @ApiOperation(value="\u6539\u9769\u8bd5\u70b9\u53f0\u8d26\u8be6\u60c5\u6570\u636e\u5bfc\u51fa", notes="\u5207\u6362\u5c42\u7ea7\u53c2\u6570PILOT_LEVEL_\uff0c\uff08\u4f7f\u7528\u5b57\u5178\uff0c1\uff1a\u56fd\u5bb6\u7ea7\uff0c2\uff1a\u5e02\u7ea7\uff09")
    public void pilotLedgerDetailExport(HttpServletResponse response, @ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BizReformPilotManagement> queryFilter) throws Exception {
        List<BizReformPilotManagement> rows = this.pilotManagementManager.queryLatest(queryFilter);
        ArrayList<Map> list = new ArrayList<Map>();
        String pilotLevelStr = "";
        if (rows != null && rows.size() > 0) {
            for (BizReformPilotManagement demand : rows) {
                String jsonStr = JsonUtil.toJson((Object)((Object)demand));
                Map map = JsonUtil.toMap((String)jsonStr);
                list.add(map);
            }
            String tempName = "\u8bd5\u70b9\u9879\u76ee\u53f0\u8d26\u6570\u636e";
            LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
            exportMaps.put("pilotProjectName", "\u8bd5\u70b9\u9879\u76ee\u540d\u79f0");
            exportMaps.put("docNo", "\u8bd5\u70b9\u9879\u76ee\u6587\u53f7");
            exportMaps.put("pilotLevelText", "\u8bd5\u70b9\u5c42\u7ea7");
            exportMaps.put("pilotSupervisorText", "\u4e3b\u7ba1\u90e8\u59d4");
            exportMaps.put("unitName", "\u5e02\u7ea7\u4e3b\u7ba1\u90e8\u95e8");
            exportMaps.put("pilotFieldText", "\u6240\u5c5e\u9886\u57df");
            exportMaps.put("pilotRunwayText", "\u6240\u5c5e\u8dd1\u9053");
            exportMaps.put("startTime", "\u90e8\u7f72\u65f6\u95f4");
            exportMaps.put("acceptanceTime", "\u9884\u8ba1\u9a8c\u6536\u65f6\u95f4");
            exportMaps.put("invsUnitName", "\u4e0a\u62a5\u533a\u53bf");
            exportMaps.put("propulsiveDetails", "\u5f00\u5c55\u5de5\u4f5c");
            exportMaps.put("invActualTime", "\u5b9e\u9645\u9a8c\u6536\u65f6\u95f4");
            exportMaps.put("propulsiveStatusText", "\u63a8\u8fdb\u72b6\u6001");
            HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)24, exportMaps, list);
            ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
        }
    }

    @PostMapping(value={"/pilotPushDetailforUnit"})
    @ApiOperation(value="\u67e5\u8be2\u533a\u53bf\u6539\u9769\u8bd5\u70b9\u9879\u76ee\u63a8\u8fdb\u8be6\u60c5", notes="\u67e5\u8be2\u533a\u53bf\u6539\u9769\u8bd5\u70b9\u9879\u76ee\u63a8\u8fdb\u8be6\u60c5")
    public BizReformPilotManagement pilotPushDetail(@ApiParam(name="id", value="\u8bd5\u70b9\u9879\u76eeID") @RequestParam String id, @ApiParam(name="unitCode", value="\u8bd5\u70b9\u9879\u76ee\u63a8\u8fdb\u533a\u53bfcode") @RequestParam String unitCode) {
        return this.baseManager.pilotPushDetail(id, unitCode);
    }

    @PostMapping(value={"/brandReform"})
    @ApiOperation(value="\u6539\u9769\u54c1\u724c\u699c", notes="")
    public CommonResult<String> brandReform(@ApiParam(value="\u5e74\u4efd\uff0c\u975e\u5fc5\u8981\uff0c\u9ed8\u8ba4\u5f53\u5e74\uff0c\u53ea\u5f71\u54cd\u56fe\u8868\u6570\u636e") @RequestParam(required=false) Integer year, @RequestParam(required=false) Integer quarter) {
        ArrayList<Integer> effectForm = new ArrayList<Integer>();
        effectForm.add(1);
        effectForm.add(2);
        effectForm.add(3);
        CountyBrandVo data = this.baseManager.brandReform(year, quarter, "", effectForm);
        return CommonResult.success((Object)data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/brandReformDetails"})
    @ApiOperation(value="\u67e5\u8be2\u533a\u53bf\u6539\u9769\u54c1\u724c\u699c\u8be6\u60c5", notes="")
    public CommonResult<String> brandReformDetails(@ApiParam(value="\u533a\u53bf\u7f16\u7801") @RequestParam(required=true) String unitCode, @ApiParam(value="\u5e74\u4efd\uff0c\u975e\u5fc5\u8981\uff0c\u9ed8\u8ba4\u5f53\u5e74\uff0c\u53ea\u5f71\u54cd\u56fe\u8868\u6570\u636e") @RequestParam(required=false) Integer year, @RequestParam(required=false) Integer quarter, @RequestBody QueryFilter<BizEffectEffectiveness> queryFilter) {
        List<BizEffectEffectiveness> details = this.baseManager.brandReformDetails(unitCode, year, quarter, queryFilter);
        return CommonResult.success(details, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/citywidePromotionRank"})
    @ApiOperation(value="\u5168\u5e02\u63a8\u5e7f\u6392\u884c\u699c", notes="type: 1\uff1a\u5168\u5e02\u63a8\u5e7f\uff0c2\uff1a\u5168\u56fd+\u5a92\u4f53\u63a8\u5e7f")
    public CommonResult<String> citywidePromotionRank(@RequestParam(required=false) Integer year, @RequestParam(required=false) Integer quarter, @RequestParam(required=true) Integer type) {
        List<BizScoringCountyBrand> data = this.baseManager.citywidePromotionRank(year, quarter, type);
        return CommonResult.success(data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/cityPromotionDetail"})
    @ApiOperation(value="\u5168\u5e02\u63a8\u5e7f\u4e00\u672c\u8d26\u6570\u636e")
    public PageList<BizEffectEffectiveness> cityPromotionDetail(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BizEffectEffectiveness> queryFilter) {
        return this.baseManager.cityPromotionDetail(queryFilter);
    }

    @PostMapping(value={"/gisIndex"})
    @ApiOperation(value="Gis\u6307\u6570\u6570\u636e", notes="type: composite \u7efc\u5408\u8bc4\u4ef7\u6307\u6570\u3001workable \u6539\u9769\u843d\u5b9e\u529b\u3001brand \u54c1\u724c\u663e\u793a\u5ea6\u3001satisfaction \u6539\u9769\u6ee1\u610f\u5ea6\u3001risk \u98ce\u9669\u7ba1\u63a7\u529b")
    public JSONArray gisIndex(@RequestParam String type, @RequestParam(required=false) Integer year, @RequestParam(required=false) Integer quarter) {
        return this.baseManager.gisIndex(type, year, quarter);
    }

    @PostMapping(value={"/satisfactionRealityDate"})
    @ApiOperation(value="\u6ee1\u610f\u5ea6\u5b9e\u9645\u6570\u636e\u65e5\u671f", notes="\u6ee1\u610f\u5ea6\u5b9e\u9645\u6570\u636e\u65e5\u671f")
    public CommonResult<String> satisfactionRealityDate(@RequestParam(required=false) Integer year, @RequestParam(required=false) Integer quarter) {
        String str = this.baseManager.satisfactionRealityDate(year, quarter);
        return CommonResult.success((Object)str, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/currentStatementFile"})
    @ApiOperation(value="\u62a5\u8868\u7efc\u5408\u5206\u6790\u00b7\u5f53\u524d\u6587\u6863")
    public JSONObject currentStatementFile(@ApiParam(name="year", value="\u5e74\u4efd\uff0c\u975e\u5fc5\u987b\uff0c\u9ed8\u8ba4\u5f53\u5e74") @RequestParam(required=false) Integer year, @ApiParam(name="quarter", value="\u5b63\u5ea6\uff0c\u975e\u5fc5\u987b\uff0c\u9ed8\u8ba4\u5f53\u5e74\u5f53\u5b63") @RequestParam(required=false) Integer quarter) {
        Assert.isTrue((quarter == null || quarter >= 1 && quarter <= 4 ? 1 : 0) != 0, (String)"\u5b63\u5ea6\u4f20\u9012\u9519\u8bef\uff0c\u5141\u8bb8\u503c\u30101~4\u3011");
        return this.baseManager.currentStatementFile(year, quarter);
    }

    @PostMapping(value={"/historyStatementFile"})
    @ApiOperation(value="\u62a5\u8868\u7efc\u5408\u5206\u6790\u00b7\u5386\u53f2\u6587\u6863")
    public JSONObject historyStatementFile(@ApiParam(name="year", value="\u5e74\u4efd\uff0c\u975e\u5fc5\u987b\uff0c\u9ed8\u8ba4\u5f53\u5e74") @RequestParam(required=false) Integer year) {
        return this.baseManager.historyStatementFile(year);
    }

    @PostMapping(value={"/statementDetail"})
    @ApiOperation(value="\u62a5\u8868\u7efc\u5408\u5206\u6790\u00b7\u8be6\u7ec6")
    public List<StatementDetailVo> statementDetail(@ApiParam(name="year", value="\u5e74\u4efd\uff0c\u975e\u5fc5\u987b\uff0c\u53c2\u6570\u53ea\u5f71\u54cd\u5386\u53f2\u62a5\u544a") @RequestParam(required=false) Integer year, @ApiParam(name="quarter", value="\u5b63\u5ea6\uff0c\u975e\u5fc5\u987b\uff0c\u53c2\u6570\u53ea\u5f71\u54cd\u5386\u53f2\u62a5\u544a") @RequestParam(required=false) Integer quarter) {
        Assert.isTrue((quarter == null || quarter >= 1 && quarter <= 4 ? 1 : 0) != 0, (String)"\u5b63\u5ea6\u4f20\u9012\u9519\u8bef\uff0c\u5141\u8bb8\u503c\u30101~4\u3011");
        return this.baseManager.statementDetail(year, quarter);
    }

    @RequestMapping(value={"statementDetailExport"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u533a\u53bf\u62a5\u8868\u5bfc\u51fa", httpMethod="POST", notes="\u533a\u53bf\u62a5\u8868\u5bfc\u51fa")
    public void statementDetailExport(HttpServletResponse response, @ApiParam(name="year", value="\u5e74\u4efd\uff0c\u975e\u5fc5\u987b\uff0c\u53c2\u6570\u53ea\u5f71\u54cd\u5386\u53f2\u62a5\u544a") @RequestParam(required=false) Integer year, @ApiParam(name="quarter", value="\u5b63\u5ea6\uff0c\u975e\u5fc5\u987b\uff0c\u53c2\u6570\u53ea\u5f71\u54cd\u5386\u53f2\u62a5\u544a") @RequestParam(required=false) Integer quarter) throws Exception {
        Assert.isTrue((quarter == null || quarter >= 1 && quarter <= 4 ? 1 : 0) != 0, (String)"\u5b63\u5ea6\u4f20\u9012\u9519\u8bef\uff0c\u5141\u8bb8\u503c\u30101~4\u3011");
        List<StatementDetailVo> rows = this.baseManager.statementDetail(year, quarter);
        ArrayList<Map> list = new ArrayList<Map>();
        if (rows != null && rows.size() > 0) {
            for (StatementDetailVo demand : rows) {
                String jsonStr = JsonUtil.toJson((Object)demand);
                Map map = JsonUtil.toMap((String)jsonStr);
                list.add(map);
            }
        }
        String tempName = "\u533a\u53bf\u6539\u9769\u62a5\u8868\u6570\u636e";
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        exportMaps.put("unitName", "\u533a\u53bf");
        exportMaps.put("allSn", "\u6392\u540d");
        exportMaps.put("allGrade", "\u5206\u6863");
        exportMaps.put("nationalProjectGrade", "\u627f\u63a5\u56fd\u5bb6\u7ea7\u8bd5\u70b9\u9879\u76ee\u6863\u6b21\uff09");
        exportMaps.put("nationalProjectNum", "\u627f\u63a5\u56fd\u5bb6\u7ea7\u8bd5\u70b9\u9879\u76ee\u6570\uff08\u9879\uff09");
        exportMaps.put("cityProjectGrade", "\u627f\u63a5\u5e02\u7ea7\u8bd5\u70b9\u9879\u76ee\u6570\u6863\u6b21");
        exportMaps.put("cityProjectNum", "\u627f\u63a5\u5e02\u7ea7\u8bd5\u70b9\u9879\u76ee\u6570\uff08\u9879\uff09");
        exportMaps.put("workablePassGrade", "\u627f\u63a5\u56fd\u5bb6\u548c\u5e02\u7ea7\u8bd5\u70b9\u6309\u65f6\u901a\u8fc7\u7387\u6863\u6b21");
        exportMaps.put("workablePassRate", "\u627f\u63a5\u56fd\u5bb6\u548c\u5e02\u7ea7\u8bd5\u70b9\u6309\u65f6\u901a\u8fc7\u7387");
        exportMaps.put("workableAddGrade", "\u672c\u5e74\u627f\u63a5\u56fd\u5bb6\u548c\u5e02\u7ea7\u8bd5\u70b9\u6570\u6863\u6b21");
        exportMaps.put("workableAddNum", "\u672c\u5e74\u627f\u63a5\u56fd\u5bb6\u548c\u5e02\u7ea7\u8bd5\u70b9\u6570");
        exportMaps.put("nationwideGrade", "\u6539\u9769\u7ecf\u9a8c\u83b7\u5168\u56fd\u6027\u80af\u5b9a\u8bc4\u4ef7\u6863\u6b21");
        exportMaps.put("nationwideNum", "\u6539\u9769\u7ecf\u9a8c\u83b7\u5168\u56fd\u6027\u80af\u5b9a\u8bc4\u4ef7\uff08\u4ef6\u6b21\uff09");
        exportMaps.put("cityGrade", "\u6539\u9769\u7ecf\u9a8c\u83b7\u5168\u5e02\u63a8\u5e7f\u6863\u6b21");
        exportMaps.put("cityNum", "\u6539\u9769\u7ecf\u9a8c\u83b7\u5168\u5e02\u63a8\u5e7f\uff08\u4ef6\u6b21\uff09");
        exportMaps.put("mediaGrade", "\u6539\u9769\u7ecf\u9a8c\u88ab5\u5bb6\u4e2d\u592e\u5a92\u4f53\u6df1\u5ea6\u4e13\u9898\u62a5\u9053\u6863\u6b21");
        exportMaps.put("mediaNum", "\u6539\u9769\u7ecf\u9a8c\u88ab5\u5bb6\u4e2d\u592e\u5a92\u4f53\u6df1\u5ea6\u4e13\u9898\u62a5\u9053\uff08\u4ef6\u6b21\uff09");
        exportMaps.put("satisfiedGrade", "\u793e\u60c5\u6c11\u610f\u7535\u8bdd\u8c03\u67e5\u6ee1\u610f\u5ea6\u6863\u6b21");
        exportMaps.put("satisfied", "\u793e\u60c5\u6c11\u610f\u7535\u8bdd\u8c03\u67e5\u6ee1\u610f\u5ea6\uff08%\uff09");
        HSSFWorkbook book = ExcelUtil.exportTemplateExcel((String)tempName, exportMaps, list, (int)2, (String)"excel/countyNewReport.xls");
        ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
    }

    @PostMapping(value={"/queryCoreIndex"})
    @ApiOperation(value="\u4e8c\u7ea7\u00b7\u5927\u5c4f\u6838\u5fc3\u6307\u6570")
    public CoreIndexVo queryCoreIndex(@ApiParam(name="year", value="\u5e74\u4efd\uff0c\u975e\u5fc5\u987b\uff0c\u53c2\u6570\u53ea\u5f71\u54cd\u5386\u53f2\u62a5\u544a") @RequestParam(required=false) Integer year, @ApiParam(name="quarter", value="\u5b63\u5ea6\uff0c\u975e\u5fc5\u987b\uff0c\u53c2\u6570\u53ea\u5f71\u54cd\u5386\u53f2\u62a5\u544a") @RequestParam(required=false) Integer quarter, @ApiParam(name="unitCode", value="\u533a\u53bf\u7f16\u7801") @RequestParam(required=true) String unitCode) {
        Assert.isTrue((quarter == null || quarter >= 1 && quarter <= 4 ? 1 : 0) != 0, (String)"\u5b63\u5ea6\u4f20\u9012\u9519\u8bef\uff0c\u5141\u8bb8\u503c\u30101~4\u3011");
        return this.baseManager.queryCoreIndex(unitCode, year, quarter);
    }

    @PostMapping(value={"/queryFieldSatisfaction"})
    @ApiOperation(value="\u4e8c\u7ea7\u00b7\u67e5\u8be25\u4e2a\u9886\u57df\u6ee1\u610f\u5ea6\u6570\u636e")
    public List<BizReformSatisfactionDistricts> queryFieldSatisfaction(@ApiParam(name="year", value="\u5e74\u4efd\uff0c\u975e\u5fc5\u987b\uff0c\u53c2\u6570\u53ea\u5f71\u54cd\u5386\u53f2\u62a5\u544a") @RequestParam(required=false) Integer year, @ApiParam(name="quarter", value="\u5b63\u5ea6\uff0c\u975e\u5fc5\u987b\uff0c\u53c2\u6570\u53ea\u5f71\u54cd\u5386\u53f2\u62a5\u544a") @RequestParam(required=false) Integer quarter, @ApiParam(name="unitCode", value="\u533a\u53bf\u7f16\u7801") @RequestParam(required=true) String unitCode) {
        Assert.isTrue((quarter == null || quarter >= 1 && quarter <= 4 ? 1 : 0) != 0, (String)"\u5b63\u5ea6\u4f20\u9012\u9519\u8bef\uff0c\u5141\u8bb8\u503c\u30101~4\u3011");
        return this.satisfactionDistrictsManager.qureyFieldByUnitCode(unitCode, year, quarter);
    }

    @PostMapping(value={"/queryIndexSn"})
    @ApiOperation(value="\u4e8c\u7ea7\u00b7\u5927\u5c4f\u6307\u6570\u6392\u884c")
    public CoreIndexVo queryIndexSn(@ApiParam(name="year", value="\u5e74\u4efd\uff0c\u975e\u5fc5\u987b\uff0c\u53c2\u6570\u53ea\u5f71\u54cd\u5386\u53f2\u62a5\u544a") @RequestParam(required=false) Integer year, @ApiParam(name="quarter", value="\u5b63\u5ea6\uff0c\u975e\u5fc5\u987b\uff0c\u53c2\u6570\u53ea\u5f71\u54cd\u5386\u53f2\u62a5\u544a") @RequestParam(required=false) Integer quarter, @ApiParam(name="unitCode", value="\u533a\u53bf\u7f16\u7801") @RequestParam(required=true) String unitCode) {
        Assert.isTrue((quarter == null || quarter >= 1 && quarter <= 4 ? 1 : 0) != 0, (String)"\u5b63\u5ea6\u4f20\u9012\u9519\u8bef\uff0c\u5141\u8bb8\u503c\u30101~4\u3011");
        return this.baseManager.queryIndexSn(unitCode, year, quarter);
    }

    @PostMapping(value={"/reformDemand_sec"})
    @ApiOperation(value="\u4e8c\u7ea7\u00b7\u6539\u9769\u9700\u6c42")
    public JSONObject reformDemand(@ApiParam(name="year", value="\u5e74\u4efd\uff0c\u975e\u5fc5\u987b\uff0c\u53c2\u6570\u53ea\u5f71\u54cd\u5386\u53f2\u62a5\u544a") @RequestParam(required=false) Integer year, @ApiParam(name="quarter", value="\u5b63\u5ea6\uff0c\u975e\u5fc5\u987b\uff0c\u53c2\u6570\u53ea\u5f71\u54cd\u5386\u53f2\u62a5\u544a") @RequestParam(required=false) Integer quarter, @RequestParam(required=true) String unitCode) {
        return this.baseManager.reformDemand(year, quarter, unitCode);
    }

    @PostMapping(value={"/reformDemandDetails_sec"})
    @ApiOperation(value="\u4e8c\u7ea7\u00b7\u6539\u9769\u9700\u6c42\u8be6\u60c5")
    public PageList<BizReformDemandAnalysisLibrary> reformDemandDetails(@RequestBody QueryFilter<BizReformDemandAnalysisLibrary> queryFilter) {
        queryFilter.addFilter("STATUS_", (Object)5, QueryOP.EQUAL);
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        return this.demandAnalysisLibraryManager.query(queryFilter);
    }

    @PostMapping(value={"/reformDemandDetailList_sec"})
    @ApiOperation(value="\u4e8c\u7ea7\u00b7\u6539\u9769\u9700\u6c42\u6e05\u5355\u8be6\u60c5")
    public PageList<DemandAssignmentVo> reformDemandDetailList(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BizReformDemandAssignment> queryFilter) {
        queryFilter.addFilter("a.is_dele_", (Object)"0", QueryOP.EQUAL);
        PageList<DemandAssignmentVo> recordList = this.demandRecordMaanger.queryDemandAssignment(queryFilter);
        return recordList;
    }

    @PostMapping(value={"/problemSolving_sec"})
    @ApiOperation(value="\u4e8c\u7ea7\u00b7\u95ee\u9898\u7834\u89e3")
    public JSONObject problemSolving(@ApiParam(name="year", value="\u5e74\u4efd\uff0c\u975e\u5fc5\u987b\uff0c\u53c2\u6570\u53ea\u5f71\u54cd\u5386\u53f2\u62a5\u544a") @RequestParam(required=false) Integer year, @ApiParam(name="quarter", value="\u5b63\u5ea6\uff0c\u975e\u5fc5\u987b\uff0c\u53c2\u6570\u53ea\u5f71\u54cd\u5386\u53f2\u62a5\u544a") @RequestParam(required=false) Integer quarter, @RequestParam(required=true) String unitCode) {
        return this.baseManager.problemSolving(year, quarter, unitCode);
    }

    @PostMapping(value={"/problemSolvingDetail_sec"})
    @ApiOperation(value="\u4e8c\u7ea7\u00b7\u95ee\u9898\u7834\u89e3\u8be6\u60c5")
    public PageList<BlockageCardTransferVo> problemSolving(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BizBlockageCardTransfer> queryFilter) {
        return this.blockageCardTransferManager.queryBlockageCardDetailList(queryFilter);
    }

    @PostMapping(value={"/brandBuild_sec"})
    @ApiOperation(value="\u4e8c\u7ea7\u00b7\u54c1\u724c\u521b\u5efa")
    public JSONObject brandBuild(@ApiParam(name="year", value="\u5e74\u4efd\uff0c\u975e\u5fc5\u987b\uff0c\u53c2\u6570\u53ea\u5f71\u54cd\u5386\u53f2\u62a5\u544a") @RequestParam(required=false) Integer year, @ApiParam(name="quarter", value="\u5b63\u5ea6\uff0c\u975e\u5fc5\u987b\uff0c\u53c2\u6570\u53ea\u5f71\u54cd\u5386\u53f2\u62a5\u544a") @RequestParam(required=false) Integer quarter, @RequestParam(required=true) String unitCode, @RequestBody QueryFilter<BizEffectEffectiveness> queryFilter) {
        return this.baseManager.brandBuild(year, quarter, unitCode, queryFilter);
    }

    @PostMapping(value={"/pilotLedgerDetail_sec"})
    @ApiOperation(value="\u4e8c\u7ea7.\u6539\u9769\u8bd5\u70b9\u53f0\u8d26\u8be6\u60c5\u6570\u636e", notes="\u5207\u6362\u5c42\u7ea7\u53c2\u6570PILOT_LEVEL_\uff0c\uff08\u4f7f\u7528\u5b57\u5178\uff0c1\uff1a\u56fd\u5bb6\u7ea7\uff0c2\uff1a\u5e02\u7ea7\uff09")
    public PageList<BizReformPilotManagement> pilotLedgerDetailSec(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BizReformPilotManagement> queryFilter) {
        return this.baseManager.pilotLedgerDetailSec(queryFilter);
    }
}

