/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.statistics.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.reform.fill.vo.TargetAllVO;
import com.artfess.reform.fill.vo.TargetVO;
import com.artfess.reform.majorProjects.manager.MunicipalMajorProjectManagementManager;
import com.artfess.reform.majorProjects.manager.PilotMeasuresPushManager;
import com.artfess.reform.majorProjects.manager.PilotSpecificScheduleManager;
import com.artfess.reform.majorProjects.model.MunicipalMajorProjectManagement;
import com.artfess.reform.statistics.manager.BizScoringProjectTargetManager;
import com.artfess.reform.statistics.model.BizScoringProjectTarget;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizScoringProjectTarget/v1/"})
@ApiGroup(group={"group_biz"})
@Api(tags={"\u9879\u76ee\u91cf\u5316\u76ee\u6807\u63a8\u8fdb\u529b\u8bc4\u5206\u7ed3\u679c"})
public class BizScoringProjectTargetController
extends BaseController<BizScoringProjectTargetManager, BizScoringProjectTarget> {
    @Resource
    private MunicipalMajorProjectManagementManager municipalMajorProjectManagementManager;
    @Resource
    private PilotSpecificScheduleManager pilotSpecificScheduleManager;
    @Resource
    private PilotMeasuresPushManager pilotMeasuresPushManager;

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<BizScoringProjectTarget> query(@RequestBody QueryFilter<BizScoringProjectTarget> queryFilter) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.orderByDesc((Object)"FILL_DATE_");
        wrapper.last("limit 1");
        BizScoringProjectTarget projects = (BizScoringProjectTarget)((Object)((BizScoringProjectTargetManager)this.baseService).getOne((Wrapper)wrapper));
        if (projects != null) {
            queryFilter.addFilter("FILL_DATE_", (Object)df.format(projects.getFillDate()), QueryOP.EQUAL);
        } else {
            Date date = new Date(System.currentTimeMillis());
            queryFilter.addFilter("FILL_DATE_", (Object)formatter.format(date), QueryOP.EQUAL);
        }
        return super.query(queryFilter);
    }

    @GetMapping(value={"/target"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u91cf\u5316\u76ee\u6807")
    public TargetVO target() {
        TargetVO vo = new TargetVO();
        LocalDateTime now = LocalDateTime.now();
        QueryWrapper projectwrapper = new QueryWrapper();
        projectwrapper.eq((Object)"IS_DELE_", (Object)"0");
        projectwrapper.eq((Object)"CLOSING_", (Object)1);
        List projects = this.municipalMajorProjectManagementManager.list((Wrapper)projectwrapper);
        int allNum = 0;
        int monthNum = 0;
        BigDecimal allRate = new BigDecimal(0);
        for (MunicipalMajorProjectManagement project : projects) {
            QueryWrapper seasonWrapper = new QueryWrapper();
            seasonWrapper.eq((Object)"FILL_YEAR_", (Object)now.getYear());
            seasonWrapper.eq((Object)"FILL_MONTH_", (Object)now.getMonthValue());
            seasonWrapper.eq((Object)"PROJECT_ID_", (Object)project.getId());
            seasonWrapper.orderByDesc((Object)"FILL_DATE_");
            seasonWrapper.last("limit 1");
            BizScoringProjectTarget seasonList = (BizScoringProjectTarget)((Object)((BizScoringProjectTargetManager)this.baseService).getOne((Wrapper)seasonWrapper));
            if (seasonList == null) continue;
            allNum += seasonList.getTargetNum().intValue();
            monthNum += seasonList.getReachNum().intValue();
            if (seasonList.getReachRate().equals(BigDecimal.ZERO)) continue;
            allRate = allRate.add(seasonList.getReachRate());
        }
        vo.setMonthNum(monthNum);
        vo.setAllNum(allNum);
        if (!allRate.equals(BigDecimal.ZERO) && projects.size() > 0) {
            vo.setRate(allRate.divide(new BigDecimal(projects.size()), 2, 4));
        } else {
            vo.setRate(allRate);
        }
        return vo;
    }

    @GetMapping(value={"/targetAll"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u91cf\u5316\u76ee\u6807\u603b\u89c8")
    public List<TargetAllVO> targetAll() {
        ArrayList<TargetAllVO> vos = new ArrayList();
        TargetAllVO vo = new TargetAllVO();
        LocalDateTime now = LocalDateTime.now();
        QueryWrapper projectwrapper = new QueryWrapper();
        projectwrapper.eq((Object)"IS_DELE_", (Object)"0");
        projectwrapper.eq((Object)"CLOSING_", (Object)1);
        List projects = this.municipalMajorProjectManagementManager.list((Wrapper)projectwrapper);
        for (MunicipalMajorProjectManagement project : projects) {
            int allNum = 0;
            int finishNum = 0;
            QueryWrapper scheduleQueryWrapper = new QueryWrapper();
            scheduleQueryWrapper.eq((Object)"PLAN_YEAR_", (Object)now.getYear());
            scheduleQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
            scheduleQueryWrapper.eq((Object)"PROJECT_ID_", (Object)project.getId());
            List schedules = this.pilotSpecificScheduleManager.list((Wrapper)scheduleQueryWrapper);
            allNum += schedules.size();
            QueryWrapper pushQueryWrapper = new QueryWrapper();
            pushQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
            pushQueryWrapper.eq((Object)"PROJECT_ID_", (Object)project.getId());
            pushQueryWrapper.eq((Object)"IS_OVER_", (Object)1);
            List pushes = this.pilotMeasuresPushManager.list((Wrapper)pushQueryWrapper);
            vo.setProjectName(project.getProjectName());
            if ((finishNum += pushes.size()) > 0 && allNum > 0) {
                vo.setRate(new BigDecimal(allNum).divide(new BigDecimal(finishNum), 2, 4));
            } else {
                vo.setRate(BigDecimal.ZERO);
            }
            vos.add(vo);
        }
        vos = vos.stream().sorted(Comparator.comparing(TargetAllVO::getRate).reversed()).collect(Collectors.toList());
        return vos;
    }

    @GetMapping(value={"/testCountScore"})
    public List<BizScoringProjectTarget> testCountScore(LocalDate countDate) {
        return ((BizScoringProjectTargetManager)this.baseService).countScore(countDate);
    }
}

