/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.reform.majorProjects.dao.PilotSpecificScheduleDao;
import com.artfess.reform.majorProjects.manager.PilotSpecificScheduleManager;
import com.artfess.reform.majorProjects.manager.PilotSpecificSchedulePushManager;
import com.artfess.reform.majorProjects.model.PilotSpecificSchedule;
import com.artfess.reform.majorProjects.model.PilotSpecificSchedulePush;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.stereotype.Service;

@Service
public class PilotSpecificScheduleManagerImpl
extends BaseManagerImpl<PilotSpecificScheduleDao, PilotSpecificSchedule>
implements PilotSpecificScheduleManager {
    @Resource
    private PilotSpecificSchedulePushManager pilotSpecificSchedulePushManager;
    @Resource
    private SysDictionaryDetailManager sysDictionaryDetailManager;

    @Override
    public boolean saveBatch(List<PilotSpecificSchedule> entityList) {
        if (null == entityList && entityList.size() < 0) {
            return false;
        }
        boolean b = super.saveOrUpdateBatch(entityList);
        for (PilotSpecificSchedule pilotSpecificSchedule : entityList) {
            List<PilotSpecificSchedulePush> pilotQuantitativeObjectivesPushList = pilotSpecificSchedule.getPilotSpecificSchedulePushList();
            if (null == pilotQuantitativeObjectivesPushList || pilotQuantitativeObjectivesPushList.size() <= 0) continue;
            pilotQuantitativeObjectivesPushList.stream().forEach(p -> {
                p.setObjectivesMeasuresId(pilotSpecificSchedule.getId());
                p.setProjectId(pilotSpecificSchedule.getProjectId());
            });
            this.pilotSpecificSchedulePushManager.saveOrUpdateBatch(pilotQuantitativeObjectivesPushList);
        }
        return b;
    }

    @Override
    public List<PilotSpecificSchedule> queryListByProjectId(String projectId) {
        List list = super.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)projectId)).eq((Object)"PLAN_STATUS_", (Object)1)).eq((Object)"IS_DELE_", (Object)"0")).orderByAsc((Object[])new String[]{"PLAN_YEAR_", "PLAN_QUARTER_", "PLAN_MONTH_"})).orderByDesc((Object)"LAST_TIME_"));
        if (null != list && list.size() > 0) {
            for (PilotSpecificSchedule pilotSpecificSchedule : list) {
                List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList = this.pilotSpecificSchedulePushManager.queryListByObjectivesMeasuresId(pilotSpecificSchedule.getId());
                pilotSpecificSchedule.setPilotSpecificSchedulePushList(pilotSpecificSchedulePushList);
            }
        }
        return list;
    }

    @Override
    public List<PilotSpecificSchedule> queryPilotSpecificScheduleListByProjectId(String projectId) {
        List list = super.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)projectId)).eq((Object)"IS_DELE_", (Object)"0")).orderByAsc((Object[])new String[]{"PLAN_YEAR_", "PLAN_MONTH_"})).orderByDesc((Object)"LAST_TIME_"));
        return list;
    }

    @Override
    public void exportExcel(HttpServletResponse response, QueryFilter<PilotSpecificSchedule> queryFilter, boolean isAffirm) throws Exception {
        IPage<PilotSpecificSchedule> iPage;
        PageList pageList;
        ArrayList list = new ArrayList();
        queryFilter.addFilter("m.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("s.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("m.CLOSING_", (Object)1, QueryOP.EQUAL);
        queryFilter.addFilter("PROJECT_TYPE_", (Object)1, QueryOP.EQUAL);
        if (!ContextUtil.getCurrentUser().isAdmin() && ContextUtil.getCurrentUser() != null && !isAffirm) {
            queryFilter.addFilter("m.UNIT_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        if (BeanUtils.isNotEmpty((Object)(pageList = new PageList(iPage = ((PilotSpecificScheduleDao)this.baseMapper).querySchedulePageInfo((IPage<PilotSpecificSchedule>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<PilotSpecificSchedule>)this.convert2Wrapper(queryFilter, this.currentModelClass())))).getRows())) {
            pageList.getRows().stream().forEach(p -> {
                try {
                    String jsonStr = JsonUtil.toJson((Object)p);
                    Map map = JsonUtil.toMap((String)jsonStr);
                    if (map.get("projectField") != null) {
                        String projectField = map.get("projectField").toString();
                        String projectFieldText = this.sysDictionaryDetailManager.getTextByValue("ggbb_ssly", projectField);
                        map.put("projectFieldText", projectFieldText);
                    } else {
                        map.put("projectFieldText", "");
                    }
                    if (map.get("projectRunWay") != null) {
                        String projectRunWay = map.get("projectRunWay").toString();
                        String projectRunWayText = this.sysDictionaryDetailManager.getTextByValue("ggbb_sspd", projectRunWay);
                        map.put("projectRunWayText", projectRunWayText);
                    } else {
                        map.put("projectRunWayText", "");
                    }
                    if (map.get("planType") != null) {
                        String planType = map.get("planType").toString();
                        String planTypeText = this.sysDictionaryDetailManager.getTextByValue("yd_jhlx", planType);
                        map.put("planTypeText", planTypeText);
                    } else {
                        map.put("planTypeText", "");
                    }
                    if (map.get("planMonth") != null && map.get("planYear") != null) {
                        String planMonth = map.get("planMonth").toString();
                        String planYear = map.get("planYear").toString();
                        map.put("planDate", planYear + "\u5e74" + planMonth + "\u6708");
                    } else {
                        map.put("planDate", "");
                    }
                    if (map.get("progressStatus") != null) {
                        String progressStatus = map.get("progressStatus").toString();
                        String progressStatusText = this.sysDictionaryDetailManager.getTextByValue("tjzt", progressStatus);
                        map.put("progressStatusText", progressStatusText);
                    } else {
                        map.put("progressStatusText", "");
                    }
                    if (map.get("status") != null) {
                        String status = map.get("status").toString();
                        String statusText = this.sysDictionaryDetailManager.getTextByValue("shzt", status);
                        map.put("statusText", statusText);
                    } else {
                        map.put("statusText", "");
                    }
                    list.add(map);
                }
                catch (Exception e) {
                    throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
                }
            });
            String tempName = "\u6708\u5ea6\u8ba1\u5212\u63a8\u8fdb\u66f4\u65b0";
            LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
            exportMaps.put("projectName", "\u9879\u76ee\u540d\u79f0");
            exportMaps.put("leader", "\u7275\u5934\u5e02\u9886\u5bfc");
            exportMaps.put("unitName", "\u8d23\u4efb\u5355\u4f4d");
            exportMaps.put("projectFieldText", "\u6240\u5c5e\u9886\u57df");
            exportMaps.put("projectRunWayText", "\u6240\u5c5e\u8dd1\u9053");
            exportMaps.put("statusText", "\u5ba1\u6838\u72b6\u6001");
            exportMaps.put("planDate", "\u8ba1\u5212\u6708\u5ea6");
            exportMaps.put("planTypeText", "\u8ba1\u5212\u7c7b\u578b");
            exportMaps.put("planContent", "\u8ba1\u5212\u5185\u5bb9");
            exportMaps.put("progressStatusText", "\u63a8\u8fdb\u72b6\u6001");
            exportMaps.put("completedWork", "\u5df2\u5f00\u5c55\u5de5\u4f5c");
            exportMaps.put("problems", "\u6709\u5173\u8be6\u60c5\u53ca\u89e3\u51b3\u95ee\u9898");
            exportMaps.put("workPlan", "\u4e0b\u4e00\u6b65\u5de5\u4f5c\u8ba1\u5212");
            HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)24, exportMaps, list);
            ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
        }
    }
}

