/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.majorProjects.dao.PilotSpecificMeasuresDao;
import com.artfess.reform.majorProjects.manager.MunicipalMajorProjectManagementManager;
import com.artfess.reform.majorProjects.manager.PilotSpecificMeasuresHistoryManager;
import com.artfess.reform.majorProjects.manager.PilotSpecificMeasuresManager;
import com.artfess.reform.majorProjects.manager.PilotSpecificScheduleManager;
import com.artfess.reform.majorProjects.model.MunicipalMajorProjectManagement;
import com.artfess.reform.majorProjects.model.PilotSpecificMeasures;
import com.artfess.reform.majorProjects.model.PilotSpecificMeasuresHistory;
import com.artfess.reform.majorProjects.model.PilotSpecificSchedule;
import com.artfess.reform.majorProjects.vo.IterationExamine;
import com.artfess.reform.majorProjects.vo.IterationExamineAndProjectVo;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.hasor.utils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PilotSpecificMeasuresManagerImpl
extends BaseManagerImpl<PilotSpecificMeasuresDao, PilotSpecificMeasures>
implements PilotSpecificMeasuresManager {
    @Resource
    private PilotSpecificMeasuresHistoryManager pilotSpecificMeasuresHistoryManager;
    @Resource
    private MunicipalMajorProjectManagementManager municipalMajorProjectManagementManager;
    @Resource
    private PilotSpecificScheduleManager pilotSpecificScheduleManager;
    @Resource
    private SysDictionaryManager sysDictionaryManager;
    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;

    @Override
    public List<PilotSpecificMeasures> queryListByProjectId(String projectId) {
        List list = super.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)projectId)).eq((Object)"IS_DELE_", (Object)"0"));
        return list;
    }

    @Override
    @Transactional
    public void iterationSaveAndCommit(List<PilotSpecificMeasuresHistory> pilotSpecificMeasuresList) {
        Assert.notNull(pilotSpecificMeasuresList, (String)"\u8fed\u4ee3\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (null != pilotSpecificMeasuresList && pilotSpecificMeasuresList.size() > 0) {
            for (PilotSpecificMeasuresHistory pilotSpecificMeasures : pilotSpecificMeasuresList) {
                String projectId = pilotSpecificMeasures.getProjectId();
                Assert.notNull((Object)projectId, (String)"\u8fed\u4ee3\u4e3e\u63aa\u4e2d\u9879\u76eeID\u672a\u8bbe\u7f6e\uff0c\u8bf7\u5148\u8bbe\u7f6e\u9879\u76eeID\uff01");
                if (pilotSpecificMeasures.getSpecificMeasuresId() != null) {
                    PilotSpecificMeasuresHistory entity = (PilotSpecificMeasuresHistory)((Object)this.pilotSpecificMeasuresHistoryManager.getById((Serializable)((Object)pilotSpecificMeasures.getId())));
                    if (com.artfess.base.util.BeanUtils.isEmpty((Object)((Object)entity))) {
                        pilotSpecificMeasures.setId(null);
                    } else if (entity.getStatus() == 5 || entity.getStatus() == 2 || entity.getStatus() == 4 || entity == null) {
                        pilotSpecificMeasures.setId(null);
                    }
                    pilotSpecificMeasures.setIteration(1);
                } else {
                    pilotSpecificMeasures.setIteration(0);
                }
                pilotSpecificMeasures.setStatus(1);
                String measuresId = pilotSpecificMeasures.getSpecificMeasuresId();
                HashMap<String, String> map = new HashMap<String, String>();
                if (measuresId == null) {
                    pilotSpecificMeasures.setSn(0);
                } else {
                    map.put("SPECIFIC_MEASURES_ID_", measuresId);
                    pilotSpecificMeasures.setSn(this.pilotSpecificMeasuresHistoryManager.getNextSequence(map));
                }
                pilotSpecificMeasures.setIterationDate(LocalDate.now());
                LocalDate date = pilotSpecificMeasures.getIterationDate();
                pilotSpecificMeasures.setIterationYear(date.getYear());
                pilotSpecificMeasures.setIterationMonth(date.getMonth().getValue());
                pilotSpecificMeasures.setIterationQuarter((date.getMonthValue() + 2) / 3);
                pilotSpecificMeasures.setSynStatus(0);
                this.pilotSpecificMeasuresHistoryManager.saveOrUpdateBatch(pilotSpecificMeasuresList);
                List<String> ids = pilotSpecificMeasuresList.stream().filter(p -> p.getStatus() == 1).map(p -> p.getId()).collect(Collectors.toList());
                if (ids == null || ids.size() <= 0) continue;
                IterationExamine iterationExamine = new IterationExamine();
                iterationExamine.setIds(ids);
                iterationExamine.setStatus(1);
                iterationExamine.setApprovalComments(null);
                iterationExamine.setApprovalResults(null);
                this.createLog(iterationExamine);
            }
            this.addSchedule(pilotSpecificMeasuresList);
        }
    }

    @Override
    @Transactional
    public void iterationSave(List<PilotSpecificMeasures> pilotSpecificMeasuresList) {
        Assert.notNull(pilotSpecificMeasuresList, (String)"\u8fed\u4ee3\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (null != pilotSpecificMeasuresList && pilotSpecificMeasuresList.size() > 0) {
            for (PilotSpecificMeasures pilotSpecificMeasures : pilotSpecificMeasuresList) {
                String projectId = pilotSpecificMeasures.getProjectId();
                Assert.notNull((Object)projectId, (String)"\u8fed\u4ee3\u4e3e\u63aa\u4e2d\u9879\u76eeID\u672a\u8bbe\u7f6e\uff0c\u8bf7\u5148\u8bbe\u7f6e\u9879\u76eeID\uff01");
                String id = pilotSpecificMeasures.getId();
                pilotSpecificMeasures.setDistributionType(1);
                if (StringUtils.isNotBlank((CharSequence)id)) {
                    pilotSpecificMeasures.setId(null);
                    pilotSpecificMeasures.setIteration(1);
                    continue;
                }
                pilotSpecificMeasures.setIteration(0);
            }
            this.saveOrUpdateBatch(pilotSpecificMeasuresList);
        }
    }

    @Override
    @Transactional
    public void iterationAddSave(List<PilotSpecificMeasuresHistory> pilotSpecificMeasuresList) {
        Assert.notNull(pilotSpecificMeasuresList, (String)"\u8fed\u4ee3\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (null != pilotSpecificMeasuresList && pilotSpecificMeasuresList.size() > 0) {
            for (Object pilotSpecificMeasures : pilotSpecificMeasuresList) {
                if (pilotSpecificMeasures.getSpecificMeasuresId() != null) {
                    PilotSpecificMeasuresHistory entity = (PilotSpecificMeasuresHistory)((Object)this.pilotSpecificMeasuresHistoryManager.getById((Serializable)((Object)pilotSpecificMeasures.getId())));
                    if (entity.getStatus() == 5 || entity.getStatus() == 2 || entity.getStatus() == 4 || entity == null) {
                        pilotSpecificMeasures.setId(null);
                    }
                    pilotSpecificMeasures.setIteration(1);
                } else {
                    pilotSpecificMeasures.setIteration(0);
                }
                String projectId = pilotSpecificMeasures.getProjectId();
                Assert.notNull((Object)projectId, (String)"\u8fed\u4ee3\u4e3e\u63aa\u4e2d\u9879\u76eeID\u672a\u8bbe\u7f6e\uff0c\u8bf7\u5148\u8bbe\u7f6e\u9879\u76eeID\uff01");
                pilotSpecificMeasures.setProjectId(pilotSpecificMeasures.getProjectId());
                pilotSpecificMeasures.setStatus(0);
                pilotSpecificMeasures.setIterationDate(LocalDate.now());
                LocalDate date = pilotSpecificMeasures.getIterationDate();
                pilotSpecificMeasures.setIterationYear(date.getYear());
                pilotSpecificMeasures.setIterationMonth(date.getMonth().getValue());
                pilotSpecificMeasures.setIterationQuarter((date.getMonthValue() + 2) / 3);
                pilotSpecificMeasures.setSynStatus(0);
                String measuresId = pilotSpecificMeasures.getSpecificMeasuresId();
                HashMap<String, String> map = new HashMap<String, String>();
                if (measuresId == null) {
                    pilotSpecificMeasures.setSn(0);
                    continue;
                }
                map.put("SPECIFIC_MEASURES_ID_", measuresId);
                pilotSpecificMeasures.setSn(this.pilotSpecificMeasuresHistoryManager.getNextSequence(map));
            }
            ArrayList<String> status = new ArrayList<String>();
            for (PilotSpecificMeasuresHistory pilotSpecificMeasuresHistory : pilotSpecificMeasuresList) {
                PilotSpecificMeasuresHistory entity = (PilotSpecificMeasuresHistory)((Object)this.pilotSpecificMeasuresHistoryManager.getById((Serializable)((Object)pilotSpecificMeasuresHistory.getId())));
                if (entity == null || entity.getStatus() != 0) continue;
                status.add(pilotSpecificMeasuresHistory.getId());
            }
            this.pilotSpecificMeasuresHistoryManager.saveOrUpdateBatch(pilotSpecificMeasuresList);
            IterationExamine iteration = new IterationExamine();
            iteration.setIds(pilotSpecificMeasuresList.stream().filter(p -> !status.contains(p.getId())).map(p -> p.getId()).collect(Collectors.toList()));
            iteration.setStatus(0);
            iteration.setApprovalComments(null);
            iteration.setApprovalResults(null);
            this.createLog(iteration);
            this.addSchedule(pilotSpecificMeasuresList);
        }
    }

    @Override
    public PageList<IterationExamineAndProjectVo> iterationListByPage(QueryFilter<PilotSpecificMeasuresHistory> queryFilter) {
        ArrayList<IterationExamineAndProjectVo> listVo = new ArrayList<IterationExamineAndProjectVo>();
        PageList pageList = this.pilotSpecificMeasuresHistoryManager.query(queryFilter);
        List list = pageList.getRows();
        HashMap<String, MunicipalMajorProjectManagement> map = new HashMap<String, MunicipalMajorProjectManagement>();
        if (null != list && list.size() > 0) {
            for (PilotSpecificMeasuresHistory pilotSpecificMeasuresHistory : list) {
                IterationExamineAndProjectVo vo = new IterationExamineAndProjectVo();
                vo.setPilotSpecificMeasuresHistory(pilotSpecificMeasuresHistory);
                String projectId = pilotSpecificMeasuresHistory.getProjectId();
                MunicipalMajorProjectManagement municipalMajorProjectManagement = (MunicipalMajorProjectManagement)((Object)map.get(projectId));
                if (null == municipalMajorProjectManagement) {
                    municipalMajorProjectManagement = (MunicipalMajorProjectManagement)this.municipalMajorProjectManagementManager.get((Serializable)((Object)projectId));
                    map.put(projectId, municipalMajorProjectManagement);
                }
                vo.setMunicipalMajorProjectManagement(municipalMajorProjectManagement);
                if (pilotSpecificMeasuresHistory.getSpecificMeasuresId() != null) {
                    PilotSpecificMeasures entity = (PilotSpecificMeasures)((Object)super.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ID_", (Object)pilotSpecificMeasuresHistory.getSpecificMeasuresId())).eq((Object)"IS_DELE_", (Object)"0")));
                    vo.setPilotSpecificMeasures(entity);
                }
                listVo.add(vo);
            }
        }
        PageList result = new PageList();
        result.setRows(listVo);
        result.setPage(pageList.getPage());
        result.setPageSize(pageList.getPageSize());
        result.setTotal(pageList.getTotal());
        return result;
    }

    @Override
    @Transactional
    public void iterationCommit(IterationExamine iterationExamine) {
        Assert.notNull((Object)iterationExamine, (String)"\u5ba1\u6838\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull(iterationExamine.getIds(), (String)"\u5ba1\u6838\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)iterationExamine.getStatus(), (String)"\u5ba1\u6838\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        UpdateWrapper pilotSpecificMeasuresUpdateWrapper = (UpdateWrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"STATUS_", (Object)iterationExamine.getStatus())).in((Object)"ID_", iterationExamine.getIds());
        if (5 == iterationExamine.getStatus()) {
            pilotSpecificMeasuresUpdateWrapper.set((Object)"SYN_STATUS_", (Object)1);
        }
        boolean check = this.check(iterationExamine);
        this.pilotSpecificMeasuresHistoryManager.update((Wrapper)pilotSpecificMeasuresUpdateWrapper);
        if (check) {
            this.createLog(iterationExamine);
        }
        if (iterationExamine.getStatus() == 5) {
            this.updateData(iterationExamine);
        }
    }

    @Override
    public int countPilotSpecificMeasuresByParentId(String id) {
        Assert.notNull((Object)id, (String)"\u4e3e\u63aaID\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"PROJECT_ID_", (Object)id)).eq((Object)"DISTRIBUTION_TYPE_", (Object)1)).eq((Object)"IS_DELE_", (Object)0);
        return this.count((Wrapper)queryWrapper);
    }

    private void updateData(IterationExamine iterationExamine) {
        QueryWrapper pilotSpecificMeasuresQueryWrapper = new QueryWrapper();
        pilotSpecificMeasuresQueryWrapper.in((Object)"ID_", iterationExamine.getIds());
        List pilotSpecificMeasuresList = this.pilotSpecificMeasuresHistoryManager.list((Wrapper)pilotSpecificMeasuresQueryWrapper);
        PilotSpecificMeasures measures = new PilotSpecificMeasures();
        for (PilotSpecificMeasuresHistory entity : pilotSpecificMeasuresList) {
            BeanUtils.copyProperties((Object)((Object)measures), (Object)((Object)entity));
            if (entity.getSpecificMeasuresId() == null) {
                measures.setId(null);
            } else {
                measures.setId(entity.getSpecificMeasuresId());
            }
            super.saveOrUpdate((Object)measures);
            UpdateWrapper updateWrapperHis = new UpdateWrapper();
            ((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)updateWrapperHis.eq((Object)"ID_", (Object)entity.getId())).isNull((Object)"SPECIFIC_MEASURES_ID_")).eq((Object)"IS_DELE_", (Object)"0")).set((Object)"SPECIFIC_MEASURES_ID_", (Object)measures.getId());
            this.pilotSpecificMeasuresHistoryManager.update((Wrapper)updateWrapperHis);
            UpdateWrapper updateWrapperSch = new UpdateWrapper();
            ((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)updateWrapperSch.eq((Object)"MEASURES_ID_", (Object)entity.getId())).eq((Object)"IS_DELE_", (Object)"0")).set((Object)"PROJECT_ID_", (Object)entity.getProjectId())).set((Object)"PLAN_STATUS_", (Object)1);
            this.pilotSpecificScheduleManager.update((Wrapper)updateWrapperSch);
        }
    }

    private void addSchedule(List<PilotSpecificMeasuresHistory> pilotSpecificMeasuresHistoryList) {
        for (PilotSpecificMeasuresHistory pilotSpecificMeasuresHistory : pilotSpecificMeasuresHistoryList) {
            if (pilotSpecificMeasuresHistory.getPilotSpecificScheduleList() == null || pilotSpecificMeasuresHistory.getPilotSpecificScheduleList().size() <= 0) continue;
            List<PilotSpecificSchedule> scheduleList = pilotSpecificMeasuresHistory.getPilotSpecificScheduleList();
            for (PilotSpecificSchedule entity : scheduleList) {
                entity.setMeasuresId(pilotSpecificMeasuresHistory.getId());
                entity.setPlanStatus(0);
                entity.setPlanQuarter((entity.getPlanMonth() + 2) / 3);
            }
            this.pilotSpecificScheduleManager.saveOrUpdateBatch(scheduleList);
        }
    }

    @Override
    @Transactional
    public boolean deleteMeasuresById(String id) {
        Assert.notNull((Object)id, (String)"\u4e3e\u63aaID\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"SPECIFIC_MEASURES_ID_", (Object)id);
        this.pilotSpecificMeasuresHistoryManager.getBaseMapper().delete((Wrapper)queryWrapper);
        return this.removeById((Serializable)((Object)id));
    }

    public void createLog(IterationExamine examine) {
        List<String> ids = examine.getIds();
        ArrayList<AchieveStatusLogAndAuditResultVo> resultVoList = new ArrayList<AchieveStatusLogAndAuditResultVo>();
        ids.stream().forEach(p -> {
            List<Integer> statusList = Arrays.asList(0, 1, 3, 5);
            List shzt = this.sysDictionaryManager.queryDictListItemsByCode("shzt");
            AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
            logVo.setBizId((String)p);
            logVo.setModeType(2);
            logVo.setBizType("6-5");
            logVo.setModuleTableName("BIZ_PILOT_SPECIFIC_MEASURES_HISTORY");
            logVo.setStatus(String.valueOf(examine.getStatus()));
            logVo.setOperateInfo(BizUtils.getDicValueByCode((List<DictModel>)shzt, examine.getStatus()));
            PilotSpecificMeasuresHistory entity = (PilotSpecificMeasuresHistory)((Object)((Object)this.pilotSpecificMeasuresHistoryManager.getById((Serializable)((Object)p))));
            MunicipalMajorProjectManagement project = (MunicipalMajorProjectManagement)((Object)((Object)this.municipalMajorProjectManagementManager.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ID_", (Object)entity.getProjectId())).eq((Object)"IS_DELE_", (Object)"0")).last("LIMIT 1"))));
            if (com.artfess.base.util.BeanUtils.isNotEmpty((Object)examine.getApprovalResults()) && examine.getApprovalResults() == 2) {
                if (project != null) {
                    if (examine.getStatus() == 0) {
                        logVo.setItemTitle("\u3010" + project.getProjectName() + "\u3011" + "\u64a4\u56de\u4e3a\u8349\u7a3f");
                        logVo.setOperateInfo("\u64a4\u56de\u4e3a\u8349\u7a3f");
                    } else if (examine.getStatus() == 1) {
                        logVo.setItemTitle("\u3010" + project.getProjectName() + "\u3011" + "\u64a4\u56de\u4e3a\u63d0\u4ea4\u5f85\u5ba1\u6838");
                        logVo.setOperateInfo("\u64a4\u56de\u4e3a\u63d0\u4ea4\u5f85\u5ba1\u6838");
                    } else if (examine.getStatus() == 3) {
                        logVo.setItemTitle("\u3010" + project.getProjectName() + "\u3011" + "\u64a4\u56de\u4e3a\u5ba1\u6838\u901a\u8fc7");
                        logVo.setOperateInfo("\u64a4\u56de\u4e3a\u5ba1\u6838\u901a\u8fc7");
                    }
                    logVo.setApprovalResults(2);
                }
            } else {
                if (null == examine.getApprovalResults() && statusList.contains(examine.getStatus())) {
                    logVo.setApprovalResults(0);
                } else {
                    logVo.setApprovalResults(1);
                }
                logVo.setItemTitle("\u3010" + project.getProjectName() + "\u3011" + BizUtils.getDicValueByCode((List<DictModel>)shzt, examine.getStatus()));
                logVo.setOperateInfo(BizUtils.getDicValueByCode((List<DictModel>)shzt, examine.getStatus()));
            }
            if (examine.getStatus() == 5) {
                logVo.setFinish(true);
            } else {
                logVo.setFinish(false);
            }
            logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
            logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
            logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
            logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
            logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
            logVo.setOperateUserId(ContextUtil.getCurrentUserId());
            logVo.setOperateUserName(ContextUtil.getCurrentUserName());
            logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
            logVo.setOperateDate(LocalDateTime.now());
            logVo.setApprovalComments(examine.getApprovalComments());
            logVo.setModeType(0);
            logVo.setPriority(0);
            resultVoList.add(logVo);
        });
        this.achieveStatusLogManager.createAchieveStatusLogAndAuditResultBatch(resultVoList);
    }

    private boolean check(IterationExamine iterationExamine) {
        List<String> ids = iterationExamine.getIds();
        for (String id : ids) {
            PilotSpecificMeasuresHistory entity = (PilotSpecificMeasuresHistory)((Object)this.pilotSpecificMeasuresHistoryManager.getById((Serializable)((Object)id)));
            if (entity == null || entity.getStatus().intValue() != iterationExamine.getStatus()) continue;
            return false;
        }
        return true;
    }
}

