/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.majorProjects.dao.PilotProjectFillDao;
import com.artfess.reform.majorProjects.manager.MunicipalMajorProjectManagementManager;
import com.artfess.reform.majorProjects.manager.PilotProjectFillManager;
import com.artfess.reform.majorProjects.model.MunicipalMajorProjectManagement;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.reform.majorProjects.vo.FillPushExamineVo;
import com.artfess.reform.majorProjects.vo.PilotProjectFillQueryVo;
import com.artfess.reform.majorProjects.vo.QuantitativeObjectivesPushFillQueryVo;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizPilotProjectFillManagerImpl
extends BaseManagerImpl<PilotProjectFillDao, PilotProjectFill>
implements PilotProjectFillManager {
    @Resource
    private SysDictionaryManager sysDictionaryManager;
    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;
    @Resource
    private PilotProjectFillDao pilotProjectFillDao;
    @Resource
    private MunicipalMajorProjectManagementManager municipalMajorProjectManagementManager;

    @Override
    public PageList<PilotProjectFill> queryPageFillList(QueryFilter<PilotProjectFill> queryFilter, Integer flowType) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<PilotProjectFill> result = ((PilotProjectFillDao)this.baseMapper).queryPageFillList((IPage<PilotProjectFill>)this.convert2IPage(pageBean), (Wrapper<PilotProjectFill>)this.convert2Wrapper(queryFilter, this.currentModelClass()), flowType);
        return new PageList(result);
    }

    @Override
    @Transactional
    public void examineVo(FillPushExamineVo fillPushExamineVo) {
        Assert.notNull((Object)fillPushExamineVo, (String)"\u5ba1\u6838\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)fillPushExamineVo.getId(), (String)"\u5ba1\u6838\u586b\u62a5\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)fillPushExamineVo.getStatus(), (String)"\u5ba1\u6838\u6570\u636e\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        UpdateWrapper pilotProjectFillUpdateWrapper = new UpdateWrapper();
        ((UpdateWrapper)pilotProjectFillUpdateWrapper.set((Object)"STATUS_", (Object)fillPushExamineVo.getStatus())).eq((Object)"ID_", (Object)fillPushExamineVo.getId());
        this.update((Wrapper)pilotProjectFillUpdateWrapper);
        PilotProjectFill pilotProjectFill = (PilotProjectFill)((Object)((PilotProjectFillDao)this.baseMapper).selectById((Serializable)((Object)fillPushExamineVo.getId())));
        pilotProjectFill.setStatus(fillPushExamineVo.getStatus());
        pilotProjectFill.setApprovalComments(fillPushExamineVo.getApprovalComments());
        pilotProjectFill.setApprovalResults(fillPushExamineVo.getApprovalResults());
        pilotProjectFill.setFlowType(fillPushExamineVo.getFlowType());
        this.createLog(pilotProjectFill, fillPushExamineVo.getTitle());
    }

    @Override
    public PageList<PilotProjectFillQueryVo> queyrList(QueryFilter<PilotProjectFill> queryFilter) {
        Assert.notNull(queryFilter, (String)"\u6761\u4ef6\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList pilotProjectFillQueryVoList = new ArrayList();
        IPage<PilotProjectFill> ipageResult = this.pilotProjectFillDao.queryList((IPage<PilotProjectFill>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<PilotProjectFill>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        PageList pilotProjectFillPageList = new PageList(ipageResult);
        List rows = pilotProjectFillPageList.getRows();
        if (null != rows && rows.size() > 0) {
            rows.stream().forEach(p -> {
                PilotProjectFillQueryVo vo = new PilotProjectFillQueryVo();
                vo.setPilotProjectFill((PilotProjectFill)((Object)p));
                MunicipalMajorProjectManagement municipalMajorProjectManagement = this.municipalMajorProjectManagementManager.getMunicipalMajorProjectManagement((Serializable)((Object)p.getProjectId()));
                vo.setMunicipalMajorProjectManagement(municipalMajorProjectManagement);
                pilotProjectFillQueryVoList.add(vo);
            });
        }
        PageList result = new PageList();
        result.setRows(pilotProjectFillQueryVoList);
        result.setPage(pilotProjectFillPageList.getPage());
        result.setPageSize(pilotProjectFillPageList.getPageSize());
        result.setTotal(pilotProjectFillPageList.getTotal());
        return result;
    }

    @Override
    public PageList<QuantitativeObjectivesPushFillQueryVo> queyrQuantitativeObjectivesPushFillList(QueryFilter<PilotProjectFill> queryFilter) {
        Assert.notNull(queryFilter, (String)"\u6761\u4ef6\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList pilotProjectFillQueryVoList = new ArrayList();
        IPage<PilotProjectFill> ipageResult = this.pilotProjectFillDao.queryList((IPage<PilotProjectFill>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<PilotProjectFill>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        PageList pilotProjectFillPageList = new PageList(ipageResult);
        List rows = pilotProjectFillPageList.getRows();
        if (null != rows && rows.size() > 0) {
            rows.stream().forEach(p -> {
                QuantitativeObjectivesPushFillQueryVo vo = new QuantitativeObjectivesPushFillQueryVo();
                vo.setPilotProjectFill((PilotProjectFill)((Object)p));
                MunicipalMajorProjectManagement municipalMajorProjectManagement = this.municipalMajorProjectManagementManager.getMunicipalMajorProjectManagement((Serializable)((Object)p.getProjectId()));
                vo.setMunicipalMajorProjectManagement(municipalMajorProjectManagement);
                pilotProjectFillQueryVoList.add(vo);
            });
        }
        PageList result = new PageList();
        result.setRows(pilotProjectFillQueryVoList);
        result.setPage(pilotProjectFillPageList.getPage());
        result.setPageSize(pilotProjectFillPageList.getPageSize());
        result.setTotal(pilotProjectFillPageList.getTotal());
        return result;
    }

    @Override
    public PilotProjectFill getHistoryPilotProjectFill(String projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"PROJECT_ID_", (Object)projectId);
        queryWrapper.eq((Object)"STATUS_", (Object)5);
        queryWrapper.eq((Object)"IS_DELE_", (Object)0);
        queryWrapper.orderByDesc((Object[])new String[]{"FILL_DATE_", "CREATE_TIME_"});
        queryWrapper.last(" limit 1");
        PilotProjectFill pilotProjectFill = (PilotProjectFill)((Object)((PilotProjectFillDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        return pilotProjectFill;
    }

    @Override
    public PilotProjectFill getHistoryPilotProjectFill(String projectId, Integer flowType) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"PROJECT_ID_", (Object)projectId);
        queryWrapper.in((Object)"STATUS_", new Object[]{2, 4, 5});
        queryWrapper.eq((Object)"IS_DELE_", (Object)0);
        queryWrapper.eq((Object)"FLOW_TYPE_", (Object)flowType);
        queryWrapper.orderByDesc((Object[])new String[]{"FILL_DATE_", "CREATE_TIME_"});
        queryWrapper.last(" limit 1");
        PilotProjectFill pilotProjectFill = (PilotProjectFill)((Object)((PilotProjectFillDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        return pilotProjectFill;
    }

    @Override
    public PilotProjectFill getHistoryPilotProjectFill(String projectId, Integer flowType, LocalDate fillDate) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        if (null == fillDate) {
            fillDate = LocalDate.now();
        }
        LocalDate end = fillDate.with(TemporalAdjusters.lastDayOfMonth());
        LocalDate start = fillDate.with(TemporalAdjusters.firstDayOfMonth());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"PROJECT_ID_", (Object)projectId);
        queryWrapper.in((Object)"STATUS_", new Object[]{2, 4, 5});
        queryWrapper.eq((Object)"IS_DELE_", (Object)0);
        queryWrapper.eq((Object)"FLOW_TYPE_", (Object)flowType);
        queryWrapper.ge((Object)"FILL_DATE_", (Object)start);
        queryWrapper.le((Object)"FILL_DATE_", (Object)end);
        queryWrapper.orderByDesc((Object[])new String[]{"FILL_DATE_", "CREATE_TIME_"});
        queryWrapper.last(" limit 1");
        PilotProjectFill pilotProjectFill = (PilotProjectFill)((Object)((PilotProjectFillDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        return pilotProjectFill;
    }

    @Override
    public void createLog(PilotProjectFill pilotProjectFill, String title) {
        List<Integer> statusList = Arrays.asList(0, 1, 3, 5);
        List shzt = this.sysDictionaryManager.queryDictListItemsByCode("shzt");
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(pilotProjectFill.getId());
        logVo.setModeType(2);
        if (pilotProjectFill.getFlowType() == 1) {
            logVo.setBizType("6-1");
        } else if (pilotProjectFill.getFlowType() == 2) {
            logVo.setBizType("6-2");
        } else if (pilotProjectFill.getFlowType() == 3) {
            logVo.setBizType("6-3");
        } else if (pilotProjectFill.getFlowType() == 4) {
            logVo.setBizType("6-4");
        }
        logVo.setModuleTableName("BIZ_PILOT_PROJECT_FILL");
        logVo.setStatus(String.valueOf(pilotProjectFill.getStatus()));
        logVo.setOperateInfo(BizUtils.getDicValueByCode((List<DictModel>)shzt, pilotProjectFill.getStatus()));
        if (BeanUtils.isNotEmpty((Object)pilotProjectFill.getApprovalResults()) && pilotProjectFill.getApprovalResults() == 2) {
            if (pilotProjectFill.getStatus() == 0) {
                logVo.setItemTitle(title + "\u64a4\u56de\u4e3a\u8349\u7a3f");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u8349\u7a3f");
            } else if (pilotProjectFill.getStatus() == 1) {
                logVo.setItemTitle(title + "\u64a4\u56de\u4e3a\u63d0\u4ea4\u5f85\u5ba1\u6838");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u63d0\u4ea4\u5f85\u5ba1\u6838");
            } else if (pilotProjectFill.getStatus() == 3) {
                logVo.setItemTitle(title + "\u64a4\u56de\u4e3a\u5ba1\u6838\u901a\u8fc7");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u5ba1\u6838\u901a\u8fc7");
            }
            logVo.setApprovalResults(2);
        } else {
            if (null != pilotProjectFill.getStatus() && statusList.contains(pilotProjectFill.getStatus())) {
                logVo.setApprovalResults(0);
            } else {
                logVo.setApprovalResults(1);
            }
            logVo.setItemTitle(title + BizUtils.getDicValueByCode((List<DictModel>)shzt, pilotProjectFill.getStatus()));
            logVo.setOperateInfo(BizUtils.getDicValueByCode((List<DictModel>)shzt, pilotProjectFill.getStatus()));
        }
        Integer status = pilotProjectFill.getStatus();
        if (null != status && status == 5) {
            logVo.setFinish(true);
        } else {
            logVo.setFinish(false);
        }
        logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        logVo.setApprovalComments(pilotProjectFill.getApprovalComments());
        logVo.setModeType(0);
        logVo.setPriority(0);
        this.achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }

    public static Map beanToMap(Object object) throws IllegalAccessException {
        Field[] fields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(object));
        }
        return map;
    }
}

