/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.majorProjects.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.reform.majorProjects.manager.PilotSpecificMeasuresManager;
import com.artfess.reform.majorProjects.model.PilotSpecificMeasures;
import com.artfess.reform.majorProjects.model.PilotSpecificMeasuresHistory;
import com.artfess.reform.majorProjects.vo.IterationExamine;
import com.artfess.reform.majorProjects.vo.IterationExamineAndProjectVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/majorProjects/pilotSpecificMeasures/v1/"})
@Api(tags={"\u5e02\u7ea7\u91cd\u5927\u6539\u9769\u9879\u76ee\u7ba1\u7406-\u6539\u9769\u65b9\u6848\u660e\u786e\u7684\u5177\u4f53\u4e3e\u63aa"})
@ApiGroup(group={"group_biz"})
public class PilotSpecificMeasuresController
extends BaseController<PilotSpecificMeasuresManager, PilotSpecificMeasures> {
    @Resource
    private PilotSpecificMeasuresManager pilotSpecificMeasuresManager;

    @PutMapping(value={"/iterationAddSave"})
    @ApiOperation(value="\u4e3e\u63aa\u8fed\u4ee3\u5ba1\u6838[\u65b0\u589e\u4e3e\u63aa]\u4fdd\u5b58\u63a5\u53e3")
    public CommonResult<String> iterationAddSave(@RequestBody List<PilotSpecificMeasuresHistory> pilotSpecificMeasuresList) {
        this.pilotSpecificMeasuresManager.iterationAddSave(pilotSpecificMeasuresList);
        return CommonResult.success(pilotSpecificMeasuresList, (String)"\u6570\u636e\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @PutMapping(value={"/iterationSaveAndCommit"})
    @ApiOperation(value="\u4e3e\u63aa\u8fed\u4ee3\u5ba1\u6838\u63d0\u4ea4\u63a5\u53e3")
    public CommonResult<String> iterationSaveAndCommit(@RequestBody List<PilotSpecificMeasuresHistory> pilotSpecificMeasuresList) {
        this.pilotSpecificMeasuresManager.iterationSaveAndCommit(pilotSpecificMeasuresList);
        return CommonResult.success(pilotSpecificMeasuresList, (String)"\u6570\u636e\u63d0\u4ea4\u6210\u529f\uff01");
    }

    @PostMapping(value={"/iteration"})
    @ApiOperation(value="\u4e3e\u63aa\u8fed\u4ee3\u90e8\u95e8\u5ba1\u6838\u63a5\u53e3")
    public CommonResult<String> iteration(@RequestBody IterationExamine iteration) {
        this.pilotSpecificMeasuresManager.iterationCommit(iteration);
        return CommonResult.success((Object)iteration, (String)"\u6570\u636e\u63d0\u4ea4\u6210\u529f\uff01");
    }

    @PostMapping(value={"/iterationListByPage"})
    @ApiOperation(value="\u4e3e\u63aa\u8fed\u4ee3\u5ba1\u6838\u5217\u8868\u5206\u9875\u67e5\u8be2")
    public PageList<IterationExamineAndProjectVo> iterationListByPage(@RequestBody QueryFilter<PilotSpecificMeasuresHistory> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        PageList<IterationExamineAndProjectVo> queryList = this.pilotSpecificMeasuresManager.iterationListByPage(queryFilter);
        return queryList;
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        int count = this.pilotSpecificMeasuresManager.countPilotSpecificMeasuresByParentId(id);
        if (count > 0) {
            throw new BaseException("\u4e3e\u63aa\u5df2\u5728\u8fed\u4ee3\u5ba1\u6838\u4e2d\uff0c\u4e0d\u80fd\u5220\u9664\u8be5\u4e3e\u63aa\uff01");
        }
        boolean result = ((PilotSpecificMeasuresManager)this.baseService).deleteMeasuresById(id);
        return CommonResult.success((Object)id, (String)"\u6570\u636e\u5220\u9664\u6210\u529f\uff01");
    }
}

