/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.fill.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.dao.BizWorkNewsDao;
import com.artfess.reform.fill.manager.BizWorkNewsManager;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizWorkNews;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import net.hasor.db.transaction.interceptor.Transactional;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class BizWorkNewsManagerImpl
extends BaseManagerImpl<BizWorkNewsDao, BizWorkNews>
implements BizWorkNewsManager {
    @Resource
    private UniversalWayManager universalWayManager;
    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;

    @Override
    @Transactional
    public void deleteInfo(String ids) {
        String[] res;
        Assert.notNull((Object)ids, (String)"\u9700\u8981\u5220\u9664\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
        for (String id : res = ids.split(",")) {
            if (((BizWorkNews)((Object)super.getById((Serializable)((Object)id)))).getStatus() != 0) {
                throw new BaseException("\u65e0\u6cd5\u5220\u9664\u5ba1\u6838\u4e2d\u6570\u636e\uff01");
            }
            super.removeById((Serializable)((Object)id));
            this.universalWayManager.deleteFiles(id);
        }
    }

    @Override
    @Transactional
    public boolean saveOrUpdateEntity(BizWorkNews bizWorkNews) {
        boolean check = this.check(bizWorkNews);
        boolean res = super.saveOrUpdate((Object)bizWorkNews);
        if (check) {
            this.setApprovalLog(bizWorkNews);
        }
        this.universalWayManager.attachmentUpdates(bizWorkNews.getIds(), bizWorkNews.getId());
        return res;
    }

    @Override
    @Transactional
    public boolean updateInfo(BizWorkNews bizWorkNews) {
        Assert.notNull((Object)bizWorkNews.getId(), (String)"\u9700\u8981\u4fee\u6539\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
        boolean check = this.check(bizWorkNews);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)((UpdateWrapper)updateWrapper.eq((Object)"ID_", (Object)bizWorkNews.getId())).eq((Object)"IS_DELE_", (Object)"0")).set((Object)"STATUS_", (Object)bizWorkNews.getStatus());
        super.update((Model)bizWorkNews);
        if (check) {
            this.setApprovalLog(bizWorkNews);
        }
        return bizWorkNews.getId() != null;
    }

    @Override
    public PageList<BizWorkNews> queryInfo(QueryFilter<BizWorkNews> queryFilter, boolean isAffirm) {
        if (!ContextUtil.getCurrentUser().isAdmin() && !isAffirm) {
            queryFilter.addFilter("CREATE_ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<BizWorkNews> iPage = ((BizWorkNewsDao)this.baseMapper).queryInfo((IPage<BizWorkNews>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizWorkNews>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    public PageList<BizWorkNews> screenInfo(QueryFilter<BizWorkNews> queryFilter) {
        queryFilter.addFilter("n.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<BizWorkNews> iPage = ((BizWorkNewsDao)this.baseMapper).screenInfo((IPage<BizWorkNews>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizWorkNews>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Transactional
    public void setApprovalLog(BizWorkNews bizWorkNews) {
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(bizWorkNews.getId());
        logVo.setModeType(1);
        logVo.setBizType("10");
        logVo.setApprovalComments(bizWorkNews.getApprovalComments());
        logVo.setModuleTableName("BIZ_WORK_NEWS");
        if (bizWorkNews.getApprovalResults() != null && bizWorkNews.getApprovalResults() == 2) {
            if (bizWorkNews.getStatus() == 0) {
                logVo.setItemTitle("\u3010" + bizWorkNews.getTitle() + "\u3011\u64a4\u56de\u4e3a\u8349\u7a3f\uff01");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u8349\u7a3f");
            } else if (bizWorkNews.getStatus() == 1) {
                logVo.setItemTitle("\u3010" + bizWorkNews.getTitle() + "\u3011\u64a4\u56de\u4e3a\u63d0\u4ea4\u5f85\u5ba1\u6838\uff01");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u63d0\u4ea4\u5f85\u5ba1\u6838");
            } else if (bizWorkNews.getStatus() == 3) {
                logVo.setItemTitle("\u3010" + bizWorkNews.getTitle() + "\u3011\u64a4\u56de\u4e3a\u533a\u53bf\u5ba1\u6838\u901a\u8fc7\uff01");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u533a\u53bf\u5ba1\u6838\u901a\u8fc7");
            }
            logVo.setApprovalResults(2);
        } else if (bizWorkNews.getStatus() == 0) {
            logVo.setItemTitle("\u3010" + bizWorkNews.getTitle() + "\u3011\u4fe1\u606f\u5f55\u5165\uff01");
            logVo.setOperateInfo("\u5de5\u4f5c\u52a8\u6001\u4fe1\u606f\u5f55\u5165");
            logVo.setApprovalResults(0);
        } else if (bizWorkNews.getStatus() == 1) {
            logVo.setItemTitle("\u3010" + bizWorkNews.getTitle() + "\u3011\u63d0\u4ea4\u5f85\u5ba1\u6838\uff01");
            logVo.setOperateInfo("\u63d0\u4ea4\u5f85\u5ba1\u6838");
            logVo.setApprovalResults(0);
        } else if (bizWorkNews.getStatus() == 2) {
            logVo.setItemTitle("\u3010" + bizWorkNews.getTitle() + "\u3011\u533a\u53bf\u5ba1\u6838\u9a73\u56de\uff01");
            logVo.setOperateInfo("\u533a\u53bf\u5ba1\u6838\u9a73\u56de");
            logVo.setApprovalResults(1);
        } else if (bizWorkNews.getStatus() == 3) {
            logVo.setItemTitle("\u3010" + bizWorkNews.getTitle() + "\u3011\u533a\u53bf\u5ba1\u6838\u901a\u8fc7\uff01");
            logVo.setOperateInfo("\u533a\u53bf\u5ba1\u6838\u901a\u8fc7");
            logVo.setApprovalResults(0);
        } else if (bizWorkNews.getStatus() == 4) {
            logVo.setItemTitle("\u3010" + bizWorkNews.getTitle() + "\u3011\u6539\u9769\u529e\u5ba1\u6838\u9a73\u56de\uff01");
            logVo.setOperateInfo("\u6539\u9769\u529e\u5ba1\u6838\u9a73\u56de");
            logVo.setApprovalResults(1);
        } else if (bizWorkNews.getStatus() == 5) {
            logVo.setItemTitle("\u3010" + bizWorkNews.getTitle() + "\u3011\u6539\u9769\u529e\u5ba1\u6838\u901a\u8fc7\uff01");
            logVo.setOperateInfo("\u6539\u9769\u529e\u5ba1\u6838\u901a\u8fc7");
            logVo.setApprovalResults(0);
        }
        logVo.setStatus(bizWorkNews.getStatus().toString());
        logVo.setModeType(0);
        logVo.setPriority(0);
        logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        this.achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }

    boolean check(BizWorkNews bizWorkNews) {
        BizWorkNews entity = (BizWorkNews)((Object)super.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ID_", (Object)bizWorkNews.getId())).eq((Object)"IS_DELE_", (Object)"0"), false));
        return entity == null || entity.getStatus() != bizWorkNews.getStatus();
    }
}

