/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.fill.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.dao.BizReformRiskManagementDao;
import com.artfess.reform.fill.manager.BizReformRiskInvolvedDistrictsManager;
import com.artfess.reform.fill.manager.BizReformRiskManagementManager;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizReformRiskInvolvedDistricts;
import com.artfess.reform.fill.model.BizReformRiskManagement;
import com.artfess.reform.fill.vo.StateVO;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizReformRiskManagementManagerImpl
extends BaseManagerImpl<BizReformRiskManagementDao, BizReformRiskManagement>
implements BizReformRiskManagementManager {
    @Resource
    BizReformRiskInvolvedDistrictsManager bizReformRiskInvolvedDistrictsManager;
    @Resource
    UniversalWayManager universalWayManager;
    @Resource
    SysDictionaryManager sysDictionaryManager;
    @Resource
    AchieveStatusLogManager achieveStatusLogManager;
    @Resource
    FileManager fileManager;

    @Override
    @Transactional
    public void removeById(String id) {
        String[] ids;
        Assert.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        for (String res : ids = id.split(",")) {
            this.bizReformRiskInvolvedDistrictsManager.remove((Wrapper)new QueryWrapper().eq(StringUtil.isNotEmpty((String)res), (Object)"RISK_ID_", (Object)res));
            ArrayList listStatus = new ArrayList();
            Collections.addAll(listStatus, 0);
            List list = this.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ID_", (Object)res)).eq((Object)"IS_DELE_", (Object)0)).notIn((Object)"STATUS_", listStatus));
            if (list.size() > 0) {
                throw new BaseException("\u5df2\u4e0a\u62a5\u7684\u65b9\u6848\u65e0\u6cd5\u5220\u9664!");
            }
            this.universalWayManager.deleteFiles(res);
            this.removeByIds(new String[]{res});
        }
    }

    @Override
    @Transactional
    public void updateById(StateVO stateVO) {
        String[] ids;
        for (String res : ids = stateVO.getId().split(",")) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((UpdateWrapper)updateWrapper.eq((Object)"ID_", (Object)res)).set((Object)"STATUS_", (Object)stateVO.getStatus());
            BizReformRiskManagement entity = (BizReformRiskManagement)((Object)super.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ID_", (Object)res)).eq((Object)"IS_DELE_", (Object)"0")).last("LIMIT 1")));
            boolean check = entity == null || entity.getStatus() != stateVO.getStatus();
            super.update((Wrapper)updateWrapper);
            if (!check) continue;
            this.setApprovalLog(stateVO);
        }
    }

    @Override
    @Transactional
    public void insertOrUpdateInfo(BizReformRiskManagement bizReformRiskManagement) {
        if (bizReformRiskManagement != null) {
            bizReformRiskManagement.setCreateOrgId(ContextUtil.getCurrentOrgId());
            if (bizReformRiskManagement.getRiskDate() != null) {
                Map<String, Integer> map = this.universalWayManager.setDate(bizReformRiskManagement.getRiskDate());
                bizReformRiskManagement.setRiskYear(map.get("year"));
                bizReformRiskManagement.setRiskMonth(map.get("month"));
                bizReformRiskManagement.setRiskQuarter(map.get("quarter"));
            }
            bizReformRiskManagement.setIsDele("0");
            super.saveOrUpdate((Object)bizReformRiskManagement);
            if (bizReformRiskManagement.getBizReformRiskInvolvedDistrictsList().size() > 0) {
                List<BizReformRiskInvolvedDistricts> bizReformRiskInvolvedDistrictsList = bizReformRiskManagement.getBizReformRiskInvolvedDistrictsList();
                this.bizReformRiskInvolvedDistrictsManager.remove((Wrapper)new QueryWrapper().eq(StringUtil.isNotEmpty((String)bizReformRiskManagement.getId()), (Object)"RISK_ID_", (Object)bizReformRiskManagement.getId()));
                for (BizReformRiskInvolvedDistricts reformRiskInvolvedDistricts : bizReformRiskInvolvedDistrictsList) {
                    reformRiskInvolvedDistricts.setSignificant(bizReformRiskManagement.getSignificant());
                    reformRiskInvolvedDistricts.setRiskId(bizReformRiskManagement.getId());
                    this.bizReformRiskInvolvedDistrictsManager.saveOrUpdate(reformRiskInvolvedDistricts);
                }
            }
            if (BeanUtils.isNotEmpty(bizReformRiskManagement.getIds())) {
                this.universalWayManager.attachmentUpdates(bizReformRiskManagement.getIds(), bizReformRiskManagement.getId());
            }
        }
    }

    @Override
    public PageList<BizReformRiskManagement> pageList(QueryFilter<BizReformRiskManagement> queryFilter, boolean isAffirm) {
        queryFilter.addFilter("r.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("r.STATUS_", Direction.ASC));
        sorter.add(new FieldSort("r.LAST_TIME_", Direction.DESC));
        queryFilter.setSorter(sorter);
        if (!ContextUtil.getCurrentUser().isAdmin() && !isAffirm) {
            queryFilter.addFilter("r.CREATE_ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        IPage<BizReformRiskManagement> iPage = ((BizReformRiskManagementDao)this.baseMapper).queryByPage((IPage<BizReformRiskManagement>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizReformRiskManagement>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    public BizReformRiskManagement findById(String id) {
        Assert.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        BizReformRiskManagement model = (BizReformRiskManagement)((Object)((BizReformRiskManagementDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (BeanUtils.isNotEmpty((Object)((Object)model))) {
            AchieveStatusLog log = (AchieveStatusLog)((Object)this.achieveStatusLogManager.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"BIZ_ID_", (Object)model.getId())).orderByDesc((Object)"OPERATE_DATE_")).last("LIMIT 1")));
            if (BeanUtils.isNotEmpty((Object)((Object)log))) {
                model.setApprovalComments(log.getApprovalComments());
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"RISK_ID_", (Object)model.getId());
            model.setBizReformRiskInvolvedDistrictsList(this.bizReformRiskInvolvedDistrictsManager.list((Wrapper)queryWrapper));
            List fileList = this.fileManager.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"BIZ_ID_", (Object)id)).eq((Object)"IS_DEL_", (Object)"0"));
            model.setFileList(fileList);
        }
        return model;
    }

    private void setApprovalLog(StateVO stateVO) {
        BizReformRiskManagement model = (BizReformRiskManagement)((Object)super.getById((Serializable)((Object)stateVO.getId())));
        List fm_shzt = this.sysDictionaryManager.queryDictListItemsByCode("fm_shzt");
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(stateVO.getId());
        logVo.setModeType(1);
        logVo.setBizType("8");
        logVo.setModuleTableName("BIZ_REFORM_RISK_MANAGEMENT");
        if (stateVO.getApprovalResults() != null && stateVO.getApprovalResults() == 2) {
            if (stateVO.getStatus() == 0) {
                logVo.setItemTitle("\u3010" + model.getRiskName() + "\u3011\u64a4\u56de\u4e3a\u8349\u7a3f");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u8349\u7a3f");
            } else if (stateVO.getStatus() == 1) {
                logVo.setItemTitle("\u3010" + model.getRiskName() + "\u3011\u64a4\u56de\u4e3a\u63d0\u4ea4\u5f85\u5ba1\u6838");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u63d0\u4ea4\u5f85\u5ba1\u6838");
            } else if (stateVO.getStatus() == 3) {
                logVo.setItemTitle("\u3010" + model.getRiskName() + "\u3011\u64a4\u56de\u4e3a\u5ba1\u6838\u901a\u8fc7");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u5ba1\u6838\u901a\u8fc7");
            }
            logVo.setApprovalResults(2);
        } else {
            if (stateVO.getStatus() == 0) {
                logVo.setItemTitle("\u3010" + model.getRiskName() + "\u3011\u98ce\u9669\u5f55\u5165");
            } else if (stateVO.getStatus() == 1) {
                logVo.setItemTitle("\u3010" + model.getRiskName() + "\u3011\u63d0\u4ea4\u5f85\u5ba1\u6838");
            } else if (stateVO.getStatus() == 2) {
                logVo.setItemTitle("\u3010" + model.getRiskName() + "\u3011\u5ba1\u6838\u9a73\u56de");
            } else if (stateVO.getStatus() == 3) {
                logVo.setItemTitle("\u3010" + model.getRiskName() + "\u3011\u5ba1\u6838\u901a\u8fc7");
            } else if (stateVO.getStatus() == 4) {
                logVo.setItemTitle("\u3010" + model.getRiskName() + "\u3011\u786e\u8ba4\u9a73\u56de");
            } else if (stateVO.getStatus() == 5) {
                logVo.setItemTitle("\u3010" + model.getRiskName() + "\u3011\u786e\u8ba4\u901a\u8fc7");
            }
            if (stateVO.getStatus() % 2 == 0) {
                logVo.setApprovalResults(1);
            } else {
                logVo.setApprovalResults(0);
            }
            logVo.setOperateInfo(BizUtils.getDicValueByCode((List<DictModel>)fm_shzt, stateVO.getStatus()));
        }
        logVo.setStatus(stateVO.getStatus().toString());
        if (stateVO.getStatus() == 2 || stateVO.getStatus() == 4) {
            logVo.setApprovalComments(stateVO.getApprovalComments());
        } else if (stateVO.getStatus() == 1) {
            logVo.setApprovalComments(null);
        }
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        logVo.setModeType(0);
        logVo.setPriority(0);
        this.achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }
}

