/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.fill.manager.impl;

import cn.hutool.core.lang.Assert;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.dao.BizReformPilotCityManagementDao;
import com.artfess.reform.fill.manager.BizPilotAdvanceCityRecordManager;
import com.artfess.reform.fill.manager.BizPilotAdvanceCityResultManager;
import com.artfess.reform.fill.manager.BizReformPilotCityManagementManager;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizPilotAdvanceCityRecord;
import com.artfess.reform.fill.model.BizPilotAdvanceCityResult;
import com.artfess.reform.fill.model.BizReformPilotCityManagement;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizReformPilotCityManagementManagerImpl
extends BaseManagerImpl<BizReformPilotCityManagementDao, BizReformPilotCityManagement>
implements BizReformPilotCityManagementManager {
    @Resource
    UniversalWayManager universalWayManager;
    @Resource
    BizPilotAdvanceCityRecordManager bizPilotAdvanceCityRecordManager;
    @Resource
    BizPilotAdvanceCityResultManager bizPilotAdvanceCityResultManager;
    @Resource
    SysDictionaryManager sysDictionaryManager;
    @Resource
    AchieveStatusLogManager achieveStatusLogManager;
    @Resource
    FileManager fileManager;
    @Resource
    SysDictionaryDetailManager sysDictionaryDetailManager;

    @Override
    @Transactional
    public boolean saveOrUpdateInfo(BizReformPilotCityManagement bizReformPilotCityManagement) {
        List<String> fileIds;
        Assert.notNull((Object)((Object)bizReformPilotCityManagement), (String)"\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)((Object)bizReformPilotCityManagement.getRecord()), (String)"\u63a8\u8fdb\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BizPilotAdvanceCityRecord record = bizReformPilotCityManagement.getRecord();
        String docNo = bizReformPilotCityManagement.getDocName().replaceAll(" ", "") + "\u3010" + bizReformPilotCityManagement.getDocYear() + "\u3011" + bizReformPilotCityManagement.getDocNum() + "\u53f7";
        bizReformPilotCityManagement.setDocNo(docNo);
        if (bizReformPilotCityManagement.getTimePeriod() == 0) {
            bizReformPilotCityManagement.setAcceptanceTime(null);
        }
        boolean res = super.saveOrUpdate((Object)bizReformPilotCityManagement);
        if (bizReformPilotCityManagement.getFiles() != null && bizReformPilotCityManagement.getFiles().size() > 0) {
            fileIds = bizReformPilotCityManagement.getFiles().stream().map(DefaultFile::getId).collect(Collectors.toList());
            this.universalWayManager.attachmentUpdates(fileIds, bizReformPilotCityManagement.getId());
        }
        record.setPilotId(bizReformPilotCityManagement.getId());
        fileIds = null;
        if (BeanUtils.isNotEmpty(record.getFiles())) {
            fileIds = record.getFiles().stream().map(DefaultFile::getId).collect(Collectors.toList());
            if (BeanUtils.isEmpty((Object)record.getId())) {
                List files = this.fileManager.list((Wrapper)new QueryWrapper().in((Object)"ID_", fileIds));
                for (DefaultFile file : files) {
                    if (!BeanUtils.isNotEmpty((Object)file.getBizId())) continue;
                    file.setId(null);
                    this.fileManager.save((Object)file);
                }
            }
        }
        BizPilotAdvanceCityRecord oldRecord = (BizPilotAdvanceCityRecord)((Object)this.bizPilotAdvanceCityRecordManager.getById((Serializable)((Object)record.getId())));
        if (record.getPropulsiveStatus() != 3) {
            record.setActualTime(null);
        }
        if (oldRecord == null) {
            this.bizPilotAdvanceCityRecordManager.saveOrUpdate((Object)bizReformPilotCityManagement.getRecord());
            this.setApprovalLog(bizReformPilotCityManagement.getRecord());
        } else {
            if (record.getId() == null || oldRecord.getStatus() != record.getStatus()) {
                this.setApprovalLog(bizReformPilotCityManagement.getRecord());
            }
            this.bizPilotAdvanceCityRecordManager.saveOrUpdate((Object)bizReformPilotCityManagement.getRecord());
        }
        if (BeanUtils.isNotEmpty(fileIds)) {
            this.universalWayManager.attachmentUpdates(fileIds, record.getId());
        }
        if (record.getResults() != null && record.getResults().size() > 0) {
            List<BizPilotAdvanceCityResult> results = record.getResults();
            results.stream().forEach(p -> {
                List<String> recFileIds = null;
                if (p.getFiles() != null && p.getFiles().size() > 0) {
                    recFileIds = p.getFiles().stream().map(DefaultFile::getId).collect(Collectors.toList());
                    if (BeanUtils.isEmpty((Object)p.getId())) {
                        List files = this.fileManager.list((Wrapper)new QueryWrapper().in((Object)"ID_", recFileIds));
                        for (DefaultFile file : files) {
                            if (!BeanUtils.isNotEmpty((Object)file.getBizId())) continue;
                            file.setId(null);
                            this.fileManager.save((Object)file);
                        }
                    }
                }
                p.setPilotId(bizReformPilotCityManagement.getId());
                p.setRecordId(record.getId());
                this.bizPilotAdvanceCityResultManager.saveOrUpdate(p);
                if (recFileIds != null && recFileIds.size() > 0) {
                    this.universalWayManager.attachmentUpdates(recFileIds, p.getId());
                }
            });
        }
        return res;
    }

    @Override
    public boolean isSameExists(String id, String docNo) {
        Assert.notNull((Object)docNo, (String)"\u9700\u8981\u9a8c\u8bc1\u7684\u6587\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BizReformPilotCityManagement entity = (BizReformPilotCityManagement)((Object)super.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DOC_NO_", (Object)docNo)).eq((Object)"IS_DELE_", (Object)"0"), false));
        if (BeanUtils.isNotEmpty((Object)((Object)entity))) {
            return BeanUtils.isNotEmpty((Object)id) && id.equals(entity.getId());
        }
        return true;
    }

    @Override
    @Transactional
    public void deleteInfo(String ids) {
        Assert.notNull((Object)ids, (String)"\u9700\u8981\u5220\u9664\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<String> idList = Arrays.asList(ids.split(","));
        idList.stream().forEach(p -> {
            int num = this.bizPilotAdvanceCityRecordManager.count((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PILOT_ID_", p)).eq((Object)"IS_DELE_", (Object)"0")).last("AND STATUS_ >1"));
            if (num > 0) {
                throw new BaseException("\u8bd5\u70b9\u9879\u76ee\u4e2d\u5b58\u5728\u5df2\u88ab\u5ba1\u6838\u5458\u5ba1\u6838\u8fc7\u6570\u636e!");
            }
            super.remove((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"IS_DELE_", (Object)"0")).eq((Object)"ID_", p));
            this.bizPilotAdvanceCityRecordManager.remove((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PILOT_ID_", p)).eq((Object)"IS_DELE_", (Object)"0"));
            this.bizPilotAdvanceCityResultManager.remove((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PILOT_ID_", p)).eq((Object)"IS_DELE_", (Object)"0"));
        });
    }

    @Override
    @Transactional
    public boolean updateByStatus(BizPilotAdvanceCityRecord entity) {
        Assert.notNull((Object)entity.getId(), (String)"\u9700\u8981\u4fee\u6539\u7684\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)entity.getStatus(), (String)"\u9700\u8981\u4fee\u6539\u7684\u5ba1\u6838\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BizPilotAdvanceCityRecord oldRecord = (BizPilotAdvanceCityRecord)((Object)this.bizPilotAdvanceCityRecordManager.getById((Serializable)((Object)entity.getId())));
        if (oldRecord.getStatus() != entity.getStatus()) {
            this.setApprovalLog(entity);
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"STATUS_", (Object)entity.getStatus());
        ((UpdateWrapper)updateWrapper.eq((Object)"ID_", (Object)entity.getId())).eq((Object)"IS_DELE_", (Object)"0");
        return this.bizPilotAdvanceCityRecordManager.update((Wrapper)updateWrapper);
    }

    @Override
    public PageList<BizReformPilotCityManagement> queryPage(QueryFilter<BizReformPilotCityManagement> queryFilter, boolean isAffirm) {
        if (!ContextUtil.getCurrentUser().isAdmin() && !isAffirm) {
            queryFilter.addFilter("M.CREATE_ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        queryFilter.addFilter("M.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<BizReformPilotCityManagement> iPage = ((BizReformPilotCityManagementDao)this.baseMapper).queryPageInfo((IPage<BizReformPilotCityManagement>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizReformPilotCityManagement>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    public PageList<BizReformPilotCityManagement> queryGroupPage(QueryFilter<BizReformPilotCityManagement> queryFilter) {
        if (!ContextUtil.getCurrentUser().isAdmin()) {
            queryFilter.addFilter("M.UNIT_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        queryFilter.addFilter("M.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<BizReformPilotCityManagement> iPage = ((BizReformPilotCityManagementDao)this.baseMapper).queryPageInfo((IPage<BizReformPilotCityManagement>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizReformPilotCityManagement>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    public void pilotExport(HttpServletResponse response, QueryFilter<BizReformPilotCityManagement> queryFilter) throws Exception {
        ArrayList list = new ArrayList();
        List models = ((BizReformPilotCityManagementDao)this.baseMapper).queryPageExcel((IPage<BizReformPilotCityManagement>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizReformPilotCityManagement>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (BeanUtils.isNotEmpty((Object)models)) {
            models.stream().forEach(p -> {
                try {
                    String jsonStr = JsonUtil.toJson((Object)p);
                    Map map = JsonUtil.toMap((String)jsonStr);
                    if (map.get("status") != null) {
                        String status = map.get("status").toString();
                        String statusText = this.sysDictionaryDetailManager.getTextByValue("ggsd_sjshzt", status);
                        map.put("statusText", statusText);
                    } else {
                        map.put("statusText", "");
                    }
                    if (map.get("timePeriod") != null) {
                        String timePeriod = map.get("timePeriod").toString();
                        if (timePeriod.equals("0")) {
                            map.put("timePeriodText", "\u957f\u671f");
                        } else {
                            map.put("timePeriodText", "\u9650\u65f6");
                        }
                    } else {
                        map.put("timePeriodText", "");
                    }
                    if (map.get("pilotSupervisor") != null) {
                        String pilotSupervisor = map.get("pilotSupervisor").toString();
                        String pilotSupervisorText = this.sysDictionaryDetailManager.getTextByValue("zgbw", pilotSupervisor);
                        map.put("pilotSupervisorText", pilotSupervisorText);
                    } else {
                        map.put("pilotSupervisorText", "");
                    }
                    if (map.get("pilotField") != null) {
                        String pilotField = map.get("pilotField").toString();
                        String pilotFieldText = this.sysDictionaryDetailManager.getTextByValue("ggbb_ssly", pilotField);
                        map.put("pilotFieldText", pilotFieldText);
                    } else {
                        map.put("pilotFieldText", "");
                    }
                    if (map.get("pilotRunway") != null) {
                        String pilotRunway = map.get("pilotRunway").toString();
                        String pilotRunwayText = this.sysDictionaryDetailManager.getTextByValue("ggbb_sspd", pilotRunway);
                        map.put("pilotRunwayText", pilotRunwayText);
                    } else {
                        map.put("pilotRunwayText", "");
                    }
                    if (map.get("propulsiveStatus") != null) {
                        String propulsiveStatus = map.get("propulsiveStatus").toString();
                        String propulsiveStatusText = this.sysDictionaryDetailManager.getTextByValue("sd_tjzt", propulsiveStatus);
                        map.put("propulsiveStatusText", propulsiveStatusText);
                    } else {
                        map.put("propulsiveStatusText", "");
                    }
                    if (map.get("resultForm") != null) {
                        String resultForm = map.get("resultForm").toString();
                        String resultFormText = this.sysDictionaryDetailManager.getTextByValue("cgxs", resultForm);
                        map.put("resultFormText", resultFormText);
                    } else {
                        map.put("resultFormText", "");
                    }
                    list.add(map);
                }
                catch (Exception e) {
                    throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
                }
            });
            String tempName = "\u6539\u9769\u8bd5\u70b9\u5e02\u7ea7\u9879\u76ee";
            LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
            exportMaps.put("pilotProjectName", "\u8bd5\u70b9\u9879\u76ee\u540d\u79f0");
            exportMaps.put("docNo", "\u8bd5\u70b9\u6587\u4ef6\u6587\u53f7");
            exportMaps.put("documentBasis", "\u6587\u4ef6\u4f9d\u636e");
            exportMaps.put("pilotSupervisorText", "\u56fd\u5bb6\u7ea7\u4e3b\u7ba1\u90e8\u59d4");
            exportMaps.put("leadUnitName", "\u5e02\u7ea7\u7275\u5934\u90e8\u95e8");
            exportMaps.put("groupName", "\u4e13\u9879\u5c0f\u7ec4");
            exportMaps.put("unitName", "\u8d23\u4efb\u5355\u4f4d");
            exportMaps.put("pilotFieldText", "\u6240\u5c5e\u9886\u57df");
            exportMaps.put("pilotRunwayText", "\u6240\u5c5e\u8dd1\u9053");
            exportMaps.put("startTime", "\u5f00\u59cb\u65f6\u95f4");
            exportMaps.put("timePeriodText", "\u8bd5\u70b9\u671f\u9650");
            exportMaps.put("acceptanceTime", "\u9a8c\u6536\u65f6\u95f4");
            exportMaps.put("pilotRange", "\u8bd5\u70b9\u8303\u56f4");
            exportMaps.put("pilotTarget", "\u8bd5\u70b9\u76ee\u6807");
            exportMaps.put("taskDetails", "\u4efb\u52a1\u8be6\u60c5");
            exportMaps.put("propulsiveStatusText", "\u63a8\u8fdb\u72b6\u6001");
            exportMaps.put("actualTime", "\u9a8c\u6536\u65f6\u95f4");
            exportMaps.put("propulsiveDetails", "\u5df2\u5f00\u5c55\u5de5\u4f5c");
            exportMaps.put("existingProblems", "\u5b58\u5728\u95ee\u9898");
            exportMaps.put("workPlan", "\u4e0b\u4e00\u6b65\u5de5\u4f5c\u8ba1\u5212");
            exportMaps.put("resultName", "\u6210\u679c\u540d\u79f0");
            exportMaps.put("resultFormText", "\u6210\u679c\u5f62\u5f0f");
            exportMaps.put("resultDate", "\u6210\u679c\u5f62\u6210\u65e5\u671f");
            exportMaps.put("solveProblem", "\u5177\u4f53\u4e3e\u63aa\u53ca\u89e3\u51b3\u95ee\u9898");
            exportMaps.put("actualEffect", "\u5177\u4f53\u6210\u6548");
            HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)14, exportMaps, list);
            ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
        }
    }

    @Transactional
    public void setApprovalLog(BizPilotAdvanceCityRecord record) {
        BizPilotAdvanceCityRecord r = (BizPilotAdvanceCityRecord)((Object)this.bizPilotAdvanceCityRecordManager.getById((Serializable)((Object)record.getId())));
        BizReformPilotCityManagement entity = (BizReformPilotCityManagement)((Object)super.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ID_", (Object)r.getPilotId())).eq((Object)"IS_DELE_", (Object)"0"), false));
        Assert.notNull((Object)((Object)record), (String)"\u63a8\u8fdb\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List ggsd_sjshzt = this.sysDictionaryManager.queryDictListItemsByCode("ggsd_sjshzt");
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(record.getId());
        logVo.setModeType(1);
        logVo.setModuleTableName("BIZ_REFORM_PILOT_CITY_MANAGEMENT");
        if (BeanUtils.isEmpty((Object)record.getApprovalResults()) || record.getApprovalResults() == 0 || record.getApprovalResults() == 1) {
            if (record.getStatus() % 2 == 0 && record.getStatus() != 0) {
                logVo.setApprovalResults(1);
            } else {
                logVo.setApprovalResults(0);
            }
            if (record.getStatus() == 0) {
                logVo.setItemTitle("\u3010" + entity.getPilotProjectName() + "\u3011\u4fdd\u5b58\u4e3a\u8349\u7a3f");
            } else if (record.getStatus() == 1) {
                logVo.setItemTitle("\u3010" + entity.getPilotProjectName() + "\u3011\u63d0\u4ea4\u5f85\u5ba1\u6838");
            } else if (record.getStatus() == 2) {
                logVo.setItemTitle("\u3010" + entity.getPilotProjectName() + "\u3011\u5ba1\u6838\u9a73\u56de");
            } else if (record.getStatus() == 3) {
                logVo.setItemTitle("\u3010" + entity.getPilotProjectName() + "\u3011\u5ba1\u6838\u901a\u8fc7");
            } else if (record.getStatus() == 4) {
                logVo.setItemTitle("\u3010" + entity.getPilotProjectName() + "\u3011\u786e\u8ba4\u9a73\u56de");
            } else if (record.getStatus() == 5) {
                logVo.setItemTitle("\u3010" + entity.getPilotProjectName() + "\u3011\u786e\u8ba4\u901a\u8fc7");
            } else if (record.getStatus() == 6) {
                logVo.setItemTitle("\u3010" + entity.getPilotProjectName() + "\u3011\u6838\u51c6\u9a73\u56de");
            } else {
                logVo.setItemTitle("\u3010" + entity.getPilotProjectName() + "\u3011\u6838\u51c6\u901a\u8fc7");
            }
            logVo.setOperateInfo(BizUtils.getDicValueByCode((List<DictModel>)ggsd_sjshzt, record.getStatus()));
        } else if (record.getApprovalResults() == 2) {
            if (record.getStatus() == 0) {
                logVo.setItemTitle("\u3010" + entity.getPilotProjectName() + "\u3011\u64a4\u56de\u4e3a\u8349\u7a3f");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u8349\u7a3f");
            } else if (record.getStatus() == 1) {
                logVo.setItemTitle("\u3010" + entity.getPilotProjectName() + "\u3011\u64a4\u56de\u4e3a\u63d0\u4ea4\u5f85\u5ba1\u6838");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u63d0\u4ea4\u5f85\u5ba1\u6838");
            } else if (record.getStatus() == 3) {
                logVo.setItemTitle("\u3010" + entity.getPilotProjectName() + "\u3011\u64a4\u56de\u4e3a\u5ba1\u6838\u901a\u8fc7");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u5ba1\u6838\u901a\u8fc7");
            } else if (record.getStatus() == 5) {
                logVo.setItemTitle("\u3010" + entity.getPilotProjectName() + "\u3011\u64a4\u56de\u4e3a\u786e\u8ba4\u901a\u8fc7");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u786e\u8ba4\u901a\u8fc7");
            }
            logVo.setApprovalResults(2);
        }
        logVo.setStatus(record.getStatus().toString());
        logVo.setApprovalComments(record.getApprovalComments());
        logVo.setBizType("5");
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        logVo.setModeType(0);
        logVo.setPriority(0);
        if (BeanUtils.isNotEmpty((Object)((Object)logVo))) {
            this.achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
        }
    }
}

