/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.fill.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.fill.dao.BizReformDemandAssignmentDao;
import com.artfess.reform.fill.manager.BizProjectCooperativeUnitManager;
import com.artfess.reform.fill.manager.BizReformDemandAssignmentManager;
import com.artfess.reform.fill.manager.BizReformDemandAssignmentRecordManager;
import com.artfess.reform.fill.model.BizProjectCooperativeUnit;
import com.artfess.reform.fill.model.BizReformDemandAssignment;
import com.artfess.reform.fill.model.BizReformDemandAssignmentRecord;
import com.artfess.reform.fill.vo.DemandAssignmentVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizReformDemandAssignmentManagerImpl
extends BaseManagerImpl<BizReformDemandAssignmentDao, BizReformDemandAssignment>
implements BizReformDemandAssignmentManager {
    @Resource
    private BizReformDemandAssignmentRecordManager bizReformDemandAssignmentRecordManager;
    @Resource
    private BizProjectCooperativeUnitManager bizProjectCooperativeUnitManager;
    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;
    @Resource
    private FileManager fileManager;

    @Override
    public PageList<BizReformDemandAssignment> queryPageList(QueryFilter<BizReformDemandAssignment> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizReformDemandAssignment> result = ((BizReformDemandAssignmentDao)this.baseMapper).queryPageList((IPage<BizReformDemandAssignment>)this.convert2IPage(pageBean), (Wrapper<BizReformDemandAssignment>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public String insertAssignment(BizReformDemandAssignment assignment) {
        String orgGrand = assignment.getResponsibleUnitGrade();
        if (orgGrand.equals("1")) {
            assignment.setResponsibleUnitType("1");
        } else {
            assignment.setResponsibleUnitType("2");
        }
        assignment.setPropulsiveYear(assignment.getMeetingDate().getYear());
        assignment.setPropulsiveMonth(assignment.getMeetingDate().getMonthValue());
        assignment.setPropulsiveQuarter(Integer.valueOf(assignment.getMeetingDate().getMonthValue() + 2) / 3);
        ((BizReformDemandAssignmentDao)this.baseMapper).insert((Object)assignment);
        List<BizProjectCooperativeUnit> coordination = assignment.getCoordination();
        if (BeanUtils.isNotEmpty(coordination)) {
            coordination.stream().forEach(p -> {
                p.setProjectId(assignment.getId());
                p.setMaiinType(2);
                this.bizProjectCooperativeUnitManager.create((Model)p);
            });
        }
        return assignment.getId();
    }

    @Override
    public List<BizReformDemandAssignmentRecord> records(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"PROJECT_ID_", (Object)projectId);
        return this.bizReformDemandAssignmentRecordManager.list((Wrapper)queryWrapper);
    }

    @Override
    public PageList<BizReformDemandAssignment> queryAudit(QueryFilter<BizReformDemandAssignment> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizReformDemandAssignment> result = ((BizReformDemandAssignmentDao)this.baseMapper).queryAudit((IPage<BizReformDemandAssignment>)this.convert2IPage(pageBean), (Wrapper<BizReformDemandAssignment>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<DemandAssignmentVo> queryDemandAssignment(QueryFilter<BizReformDemandAssignment> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<DemandAssignmentVo> result = ((BizReformDemandAssignmentDao)this.baseMapper).queryDemandAssignment((IPage<BizReformDemandAssignment>)this.convert2IPage(pageBean), (Wrapper<BizReformDemandAssignment>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public BizReformDemandAssignment queryById(String id) {
        Assert.hasText((String)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BizReformDemandAssignment assignment = (BizReformDemandAssignment)((Object)((BizReformDemandAssignmentDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (assignment != null) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"PROJECT_ID_", (Object)id);
            queryWrapper.orderByDesc((Object)"CREATE_TIME_");
            queryWrapper.last("LIMIT 2");
            List records = this.bizReformDemandAssignmentRecordManager.list((Wrapper)queryWrapper);
            for (BizReformDemandAssignmentRecord record : records) {
                if (record.getStatus() == 5) {
                    record.setIsHis(true);
                } else {
                    record.setIsHis(false);
                }
                if (record.getStatus() == 2 || record.getStatus() == 4) {
                    AchieveStatusLog log = this.achieveStatusLogManager.queryAchieveStatusLogByBizIdAndStatus(record.getId(), record.getStatus());
                    record.setApprovalComments(log.getApprovalComments());
                }
                QueryWrapper fileQuery = new QueryWrapper();
                fileQuery.eq((Object)"biz_id_", (Object)record.getId());
                record.setFiles(this.fileManager.list((Wrapper)fileQuery));
            }
            assignment.setRecords(records);
        }
        return assignment;
    }

    @Override
    public boolean updateDemandStatus(String id, Integer demandStatus) {
        Assert.hasText((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)demandStatus, (String)"\u63a8\u8fdb\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.eq((Object)"id_", (Object)id)).set((Object)"DEMAND_STATUS_", (Object)demandStatus);
        int num = ((BizReformDemandAssignmentDao)this.baseMapper).update(null, (Wrapper)updateWrapper);
        return num > 0;
    }
}

