/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.fill.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.dao.BizReformDemandAnalysisLibraryDao;
import com.artfess.reform.fill.manager.BizReformDemandAnalysisLibraryManager;
import com.artfess.reform.fill.model.BizReformDemandAnalysisLibrary;
import com.artfess.reform.statistics.vo.CountyChartVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizReformDemandAnalysisLibraryManagerImpl
extends BaseManagerImpl<BizReformDemandAnalysisLibraryDao, BizReformDemandAnalysisLibrary>
implements BizReformDemandAnalysisLibraryManager {
    @Resource
    AchieveStatusLogManager achieveStatusLogManager;

    @Override
    @Transactional
    public String insertDemand(BizReformDemandAnalysisLibrary demand) {
        LocalDateTime localDateTime = LocalDateTime.now();
        if (demand.getStatus() == null) {
            demand.setStatus(0);
        }
        demand.setDemandDate(new Date());
        demand.setDemandYear(localDateTime.getYear());
        demand.setDemandMonth(localDateTime.getMonthValue());
        demand.setDemandQuarter(Integer.valueOf(localDateTime.getMonthValue() + 2) / 3);
        demand.setReportUnitId(ContextUtil.getCurrentOrgId());
        demand.setReportUnitName(ContextUtil.getCurrentOrgName());
        demand.setResponsibleUnitCode(ContextUtil.getCurrentOrgCode());
        demand.setResponsibleUnitGrade(ContextUtil.getCurrentOrgGrade());
        ((BizReformDemandAnalysisLibraryDao)this.baseMapper).insert((Object)demand);
        this.setApprovalLog(demand.getId(), demand.getStatus(), "", demand.getApprovalResults());
        return demand.getId();
    }

    @Override
    @Transactional
    public String updateDemand(BizReformDemandAnalysisLibrary demand) {
        boolean check;
        BizReformDemandAnalysisLibrary old = (BizReformDemandAnalysisLibrary)((Object)((BizReformDemandAnalysisLibraryDao)this.baseMapper).selectById((Serializable)((Object)demand.getId())));
        boolean bl = check = old == null || old.getStatus() != demand.getStatus();
        if (old.getStatus() == 0 || old.getStatus() == 2 || old.getStatus() == 4) {
            ((BizReformDemandAnalysisLibraryDao)this.baseMapper).updateById((Object)demand);
            if (check) {
                this.setApprovalLog(demand.getId(), demand.getStatus(), "", demand.getApprovalResults());
            }
        } else {
            throw new ApplicationException("\u5df2\u5f00\u59cb\u5ba1\u6838\u4e0d\u80fd\u4fee\u6539\uff01");
        }
        return demand.getId();
    }

    @Override
    @Transactional
    public String updateAuditStatus(BizReformDemandAnalysisLibrary demand) {
        BizReformDemandAnalysisLibrary entity;
        if (demand.getStatus() == 3) {
            demand.setAuditDate(new Date());
            demand.setAuditYear(LocalDateTime.now().getYear());
            demand.setAuditMonth(LocalDateTime.now().getMonthValue());
            demand.setAuditQuarter(Integer.valueOf(LocalDateTime.now().getMonthValue() + 2) / 3);
        }
        boolean check = (entity = (BizReformDemandAnalysisLibrary)((Object)this.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ID_", (Object)demand.getId())).eq((Object)"IS_DELE_", (Object)"0"), false))) == null || entity.getStatus() != demand.getStatus();
        ((BizReformDemandAnalysisLibraryDao)this.baseMapper).updateById((Object)demand);
        if (check) {
            this.setApprovalLog(demand.getId(), demand.getStatus(), demand.getApprovalComments(), demand.getApprovalResults());
        }
        return demand.getId();
    }

    @Override
    @Transactional
    public String updateAdoptStatus(BizReformDemandAnalysisLibrary demand) {
        if (demand.getStatus() != 5) {
            throw new ApplicationException("\u6539\u9769\u529e\u5c1a\u672a\u786e\u8ba4\uff01");
        }
        ((BizReformDemandAnalysisLibraryDao)this.baseMapper).updateById((Object)demand);
        return demand.getId();
    }

    @Override
    @Transactional
    public boolean deleteBatchByIds(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.in((Object)"ID_", ids)).and(qr -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)qr.eq((Object)"STATUS_", (Object)0)).or()).eq((Object)"STATUS_", (Object)2)).or()).eq((Object)"STATUS_", (Object)4);
        });
        List list = ((BizReformDemandAnalysisLibraryDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (list.size() != ids.size()) {
            throw new ApplicationException("\u975e\u8349\u7a3f\u72b6\u6001\u7684\u6570\u636e\u4e0d\u80fd\u5220\u9664\uff01");
        }
        ((BizReformDemandAnalysisLibraryDao)this.baseMapper).deleteBatchIds(ids);
        return true;
    }

    @Transactional
    public void setApprovalLog(String id, Integer status, String approvalComments, Integer approvalResults) {
        BizReformDemandAnalysisLibrary demand = (BizReformDemandAnalysisLibrary)((Object)((BizReformDemandAnalysisLibraryDao)this.baseMapper).selectById((Serializable)((Object)id)));
        String title = demand.getDemandTopic();
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(id);
        logVo.setModeType(1);
        logVo.setBizType("1");
        logVo.setModuleTableName("biz_reform_demand_analysis_library");
        logVo.setApprovalComments(approvalComments);
        if (approvalResults != null && approvalResults == 2) {
            if (status == 0) {
                logVo.setItemTitle("\u3010" + title + "\u3011\u64a4\u56de\u4e3a\u8349\u7a3f\uff01");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u8349\u7a3f\uff01");
            } else if (status == 1) {
                logVo.setItemTitle("\u3010" + title + "\u3011\u64a4\u56de\u4e3a\u63d0\u4ea4\u5ba1\u6838\uff01");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u63d0\u4ea4\u5ba1\u6838\uff01");
            } else if (status == 3) {
                logVo.setItemTitle("\u3010" + title + "\u3011\u64a4\u56de\u4e3a\u5ba1\u6838\u901a\u8fc7\uff01");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u5ba1\u6838\u901a\u8fc7\uff01");
            }
            logVo.setApprovalResults(2);
        } else if (status == 0) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u5f55\u5165\uff01");
            logVo.setOperateInfo("\u6539\u9769\u9700\u6c42\u4fe1\u606f\u5f55\u5165\uff01");
            logVo.setApprovalResults(0);
        } else if (status == 1) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u63d0\u4ea4\u5ba1\u6838\uff01");
            logVo.setOperateInfo("\u63d0\u4ea4\u5ba1\u6838");
            logVo.setApprovalResults(0);
        } else if (status == 2) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u5ba1\u6838\u9a73\u56de\uff01");
            logVo.setOperateInfo("\u5ba1\u6838\u9a73\u56de");
            logVo.setApprovalResults(1);
        } else if (status == 3) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u5ba1\u6838\u901a\u8fc7\uff01");
            logVo.setOperateInfo("\u5ba1\u6838\u901a\u8fc7");
            logVo.setApprovalResults(0);
        } else if (status == 4) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u6539\u9769\u529e\u9a73\u56de\uff01");
            logVo.setOperateInfo("\u6539\u9769\u529e\u9a73\u56de");
            logVo.setApprovalResults(1);
        } else if (status == 5) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u6539\u9769\u529e\u901a\u8fc7\uff01");
            logVo.setOperateInfo("\u6539\u9769\u529e\u901a\u8fc7");
            logVo.setApprovalResults(0);
        }
        logVo.setStatus(status.toString());
        logVo.setModeType(0);
        logVo.setPriority(0);
        logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        this.achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }

    @Override
    public List<CountyChartVo> chartDataForLargeScreen(Integer year, Integer month) {
        return ((BizReformDemandAnalysisLibraryDao)this.baseMapper).chartDataForLargeScreen(year, month);
    }

    @Override
    public PageList<BizReformDemandAnalysisLibrary> queryByPage(QueryFilter<BizReformDemandAnalysisLibrary> queryFilter) {
        IPage<BizReformDemandAnalysisLibrary> iPage = ((BizReformDemandAnalysisLibraryDao)this.baseMapper).queryByPage((IPage<BizReformDemandAnalysisLibrary>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizReformDemandAnalysisLibrary>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }
}

