/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.fill.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.fill.dao.BizMeetingEventDao;
import com.artfess.reform.fill.manager.BizMeetingEventDetailsManager;
import com.artfess.reform.fill.manager.BizMeetingEventDetailsUnitManager;
import com.artfess.reform.fill.manager.BizMeetingEventManager;
import com.artfess.reform.fill.manager.BizMeetingEventPushManager;
import com.artfess.reform.fill.model.BizMeetingEvent;
import com.artfess.reform.fill.model.BizMeetingEventDetails;
import com.artfess.reform.fill.model.BizMeetingEventDetailsUnit;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizMeetingEventManagerImpl
extends BaseManagerImpl<BizMeetingEventDao, BizMeetingEvent>
implements BizMeetingEventManager {
    @Resource
    FileManager fileManager;
    @Resource
    private BizMeetingEventDetailsManager bizMeetingEventDetailsManager;
    @Resource
    private BizMeetingEventDetailsUnitManager bizMeetingEventDetailsUnitManager;
    @Resource
    private BizMeetingEventPushManager bizMeetingEventPushManager;

    @Override
    public PageList<BizMeetingEvent> queryByPage(QueryFilter<BizMeetingEvent> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        PageList result = super.query(queryFilter);
        return result;
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(BizMeetingEvent bizMeetingEvent) {
        List<BizMeetingEventDetails> bizMeetingEventDetailsList = bizMeetingEvent.getBizMeetingEventDetailsList();
        super.saveOrUpdate((Object)bizMeetingEvent);
        List<DefaultFile> files = bizMeetingEvent.getFiles();
        if (null != files && files.size() > 0) {
            List fileList = files.stream().map(f -> f.getId()).collect(Collectors.toList());
            this.fileManager.updateFileBizIdByIds(fileList, bizMeetingEvent.getId());
        }
        if (BeanUtils.isNotEmpty(bizMeetingEventDetailsList) && bizMeetingEventDetailsList.size() > 0) {
            bizMeetingEventDetailsList.stream().forEach(s -> {
                s.setAbutmentStatus(1);
                s.setMeetingEventId(bizMeetingEvent.getId());
                String cUnitNameList = s.getBizMeetingEventDetailsUnitList().stream().map(p -> p.getUnitName()).collect(Collectors.toList()).toString();
                String recUnitName = cUnitNameList.replace("[", "").replace("]", "");
                s.setCooperativeUnitName(recUnitName);
                String mUnitNameList = s.getMainUnitList().stream().map(p -> p.getUnitName()).collect(Collectors.toList()).toString();
                String remUnitName = mUnitNameList.replace("[", "").replace("]", "");
                s.setMainUnitName(remUnitName);
                if (s.getTimePeriod() != null && s.getTimePeriod() == 0) {
                    s.setUpdateRate(null);
                } else if (s.getTimePeriod() != null && s.getTimePeriod() == 1) {
                    s.setFeedbackTimeLimit(null);
                }
                this.bizMeetingEventDetailsManager.saveOrUpdate(s);
                this.bizMeetingEventDetailsUnitManager.remove((Wrapper)new QueryWrapper().eq((Object)"EVENT_DETAILS_ID_", (Object)s.getId()));
                List<BizMeetingEventDetailsUnit> mainUnitList = s.getMainUnitList();
                mainUnitList.stream().forEach(p -> {
                    p.setEventId(bizMeetingEvent.getId());
                    p.setEventDetailsId(s.getId());
                    p.setUnitType("1");
                });
                List mainUnitIds = mainUnitList.stream().map(BizMeetingEventDetailsUnit::getUnitId).collect(Collectors.toList());
                this.bizMeetingEventPushManager.remove((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DETAILS_ID_", (Object)s.getId())).notIn(BeanUtils.isNotEmpty(mainUnitIds), (Object)"UNIT_ID_", mainUnitIds)).eq((Object)"IS_DELE_", (Object)"0"));
                this.bizMeetingEventDetailsUnitManager.saveOrUpdateBatch(mainUnitList);
                List<BizMeetingEventDetailsUnit> detailsUnitList = s.getBizMeetingEventDetailsUnitList();
                detailsUnitList.stream().forEach(p -> {
                    p.setEventId(bizMeetingEvent.getId());
                    p.setEventDetailsId(s.getId());
                    p.setUnitType("2");
                });
                this.bizMeetingEventDetailsUnitManager.saveOrUpdateBatch(detailsUnitList);
            });
        }
    }

    @Override
    @Transactional
    public boolean modifySendStatus(String ids, String status) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"SEND_STATUS_", (Object)status);
        if (status.equals("1")) {
            updateWrapper.set((Object)"SEND_TIME_", (Object)LocalDateTime.now());
        }
        updateWrapper.in((Object)"ID_", Arrays.asList(ids.split(",")));
        return super.update((Wrapper)updateWrapper);
    }

    @Override
    public BizMeetingEvent detailedById(String id, String unitId) {
        BizMeetingEvent result = (BizMeetingEvent)((Object)super.getById((Serializable)((Object)id)));
        result.setFiles(this.fileManager.queryFileByBizId(id));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"MEETING_EVENT_ID_", (Object)id);
        List list = this.bizMeetingEventDetailsManager.list((Wrapper)queryWrapper);
        result.setBizMeetingEventDetailsList(list);
        list.stream().forEach(p -> {
            QueryWrapper mainUnitQuery = (QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"UNIT_TYPE_", (Object)"1")).eq((Object)"EVENT_DETAILS_ID_", (Object)p.getId())).eq(BeanUtils.isNotEmpty((Object)unitId), (Object)"UNIT_ID_", (Object)unitId);
            List mainUnitList = this.bizMeetingEventDetailsUnitManager.list((Wrapper)mainUnitQuery);
            p.setMainUnitList(mainUnitList);
            QueryWrapper unitQuery = (QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"UNIT_TYPE_", (Object)"2")).eq((Object)"EVENT_DETAILS_ID_", (Object)p.getId())).eq(BeanUtils.isNotEmpty((Object)unitId), (Object)"UNIT_ID_", (Object)unitId);
            List unitList = this.bizMeetingEventDetailsUnitManager.list((Wrapper)unitQuery);
            p.setBizMeetingEventDetailsUnitList(unitList);
        });
        return result;
    }

    @Override
    public boolean isExists(String id, String meetingName) {
        BizMeetingEvent entity = (BizMeetingEvent)((Object)super.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq(BeanUtils.isNotEmpty((Object)meetingName), (Object)"MEETING_NAME_", (Object)meetingName)).eq((Object)"IS_DELE_", (Object)"0"), false));
        if (BeanUtils.isEmpty((Object)((Object)entity))) {
            return true;
        }
        if (BeanUtils.isNotEmpty((Object)id) && BeanUtils.isNotEmpty((Object)((Object)entity))) {
            return entity.getId().equals(id);
        }
        return false;
    }
}

