/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.fill.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.reform.fill.manager.BizProjectCooperativeUnitManager;
import com.artfess.reform.fill.manager.BizReformDemandAnalysisLibraryManager;
import com.artfess.reform.fill.manager.BizReformDemandAssignmentManager;
import com.artfess.reform.fill.model.BizReformDemandAnalysisLibrary;
import com.artfess.reform.fill.model.BizReformDemandAssignment;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizReformDemandAssignment/v1/"})
@Api(tags={"\u6539\u9769\u9700\u6c42\u4ea4\u529e\u6a21\u5757"})
@ApiGroup(group={"group_biz"})
public class BizReformDemandAssignmentController
extends BaseController<BizReformDemandAssignmentManager, BizReformDemandAssignment> {
    @Resource
    private BizReformDemandAnalysisLibraryManager bizReformDemandAnalysisLibraryManager;
    @Resource
    private BizProjectCooperativeUnitManager bizProjectCooperativeUnitManager;

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5f55\u5165\u5206\u9875\u67e5\u8be2")
    public PageList<BizReformDemandAssignment> query(@RequestBody QueryFilter<BizReformDemandAssignment> queryFilter) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin()) {
            queryFilter.addFilter("CREATE_ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        return ((BizReformDemandAssignmentManager)this.baseService).queryPageList(queryFilter);
    }

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@RequestBody BizReformDemandAssignment bizReformDemandAssignment) {
        String id = ((BizReformDemandAssignmentManager)this.baseService).insertAssignment(bizReformDemandAssignment);
        if (StringUtil.isEmpty((String)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f\uff01", (Object)id);
    }

    @PostMapping(value={"/updateInfo"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateInfo(@RequestBody BizReformDemandAssignment bizReformDemandAssignment) {
        if (((BizReformDemandAssignmentManager)this.baseService).records(bizReformDemandAssignment.getId()).size() > 0) {
            return new CommonResult(false, "\u5df2\u63d0\u4ea4\u63a8\u8fdb\u8bb0\u5f55\u7684\u4ea4\u529e\u65e0\u6cd5\u4fee\u6539");
        }
        return super.updateById((Model)bizReformDemandAssignment);
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        if (((BizReformDemandAssignmentManager)this.baseService).records(id).size() > 0) {
            return new CommonResult(false, "\u5df2\u63d0\u4ea4\u63a8\u8fdb\u8bb0\u5f55\u7684\u4ea4\u529e\u65e0\u6cd5\u5220\u9664\uff01");
        }
        boolean result = ((BizReformDemandAssignmentManager)this.baseService).removeById((Serializable)((Object)id));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("PROJECT_ID_", id);
        this.bizProjectCooperativeUnitManager.removeByMap(map);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/getAssignmentList"})
    @ApiOperation(value="\u4ea4\u529e\u5165\u5e93\u5206\u9875\u67e5\u8be2")
    public CommonResult<PageList<BizReformDemandAnalysisLibrary>> getAssignmentList(@RequestBody QueryFilter<BizReformDemandAnalysisLibrary> queryFilter) {
        queryFilter.addFilter("STATUS_", (Object)5, QueryOP.EQUAL);
        queryFilter.addFilter("DEMAND_ADOPTION_STATUS_", (Object)2, QueryOP.EQUAL);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)this.bizReformDemandAnalysisLibraryManager.query(queryFilter));
    }

    @PostMapping(value={"/queryAudit"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5ba1\u6838\u5206\u9875\u67e5\u8be2")
    public PageList<BizReformDemandAssignment> queryAudit(@RequestBody QueryFilter<BizReformDemandAssignment> queryFilter, @RequestParam(name="isAffirm", required=true) Boolean isAffirm) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin() && !isAffirm.booleanValue()) {
            queryFilter.addFilter("a.RESPONSIBLE_UNIT_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        queryFilter.addFilter("a.is_dele_", (Object)"0", QueryOP.EQUAL);
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("r.last_time_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return ((BizReformDemandAssignmentManager)this.baseService).queryAudit(queryFilter);
    }

    @PostMapping(value={"/queryById"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u4ea4\u529e\u8be6\u60c5\u4e0e\u63a8\u8fdb\u5ba1\u6279\u8bb0\u5f55")
    public BizReformDemandAssignment queryById(@RequestParam(name="id", required=true) String id) {
        BizReformDemandAssignment assignment = ((BizReformDemandAssignmentManager)this.baseService).queryById(id);
        return assignment;
    }

    @PostMapping(value={"/updateDemandStatus"})
    @ApiOperation(value="\u4fee\u6539\u9700\u6c42\u4ea4\u529e\u63a8\u8fdb\u66f4\u65b0\u72b6\u6001")
    public CommonResult<String> updateDemandStatus(@RequestParam(name="id", required=true) String id, @RequestParam(name="demandStatus", required=true) Integer demandStatus) {
        boolean flag = ((BizReformDemandAssignmentManager)this.baseService).updateDemandStatus(id, demandStatus);
        if (flag) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult(true, "\u4fee\u6539\u6210\u529f\uff01", (Object)id);
    }
}

