/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.fill.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.reform.fill.manager.BizEffectDryingCompetitionManager;
import com.artfess.reform.fill.model.BizEffectDryingCompetition;
import com.artfess.reform.fill.model.BizEffectEffectiveness;
import com.artfess.reform.fill.vo.EffectDryingCompetitionExportVo;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizEffectDryingCompetition/v1/"})
@Api(tags={"\u6210\u6548\u667e\u6652\u4e3b\u8868"})
@ApiGroup(group={"group_biz"})
public class BizEffectDryingCompetitionController
extends BaseController<BizEffectDryingCompetitionManager, BizEffectDryingCompetition> {
    @Autowired
    SysDictionaryDetailManager sysDictionaryDetailManager;

    @PostMapping(value={"/queryAudit"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6210\u6548\u667e\u6652\u5206\u9875\u67e5\u8be2")
    public PageList<EffectDryingCompetitionExportVo> queryAudit(@RequestBody QueryFilter<BizEffectDryingCompetition> queryFilter, @RequestParam(name="isAffirm", required=true) Boolean isAffirm) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin() && !isAffirm.booleanValue()) {
            queryFilter.addFilter("a.CREATE_ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        queryFilter.addFilter("a.is_dele_", (Object)"0", QueryOP.EQUAL);
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("r.last_time_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return ((BizEffectDryingCompetitionManager)this.baseService).queryAudit(queryFilter);
    }

    @PostMapping(value={"/inserInfo"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@RequestBody BizEffectDryingCompetition bizEffectDryingCompetition) {
        String id = ((BizEffectDryingCompetitionManager)this.baseService).inertInfo(bizEffectDryingCompetition);
        if (StringUtil.isEmpty((String)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult(true, "\u6210\u529f\uff01", (Object)id);
    }

    @PostMapping(value={"/updateById"})
    @ApiOperation(value="\u6210\u6548\u4fee\u6539")
    public CommonResult<String> updateById(@RequestBody BizEffectDryingCompetition bizEffectDryingCompetition) {
        return ((BizEffectDryingCompetitionManager)this.baseService).updateInfo(bizEffectDryingCompetition);
    }

    @DeleteMapping(value={"delete/{id}"})
    @ApiOperation(value="\u6210\u6548\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((BizEffectDryingCompetitionManager)this.baseService).deleteById(id);
    }

    @PostMapping(value={"/queryById"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u4ea4\u529e\u8be6\u60c5\u4e0e\u63a8\u8fdb\u5ba1\u6279\u8bb0\u5f55")
    public BizEffectDryingCompetition queryById(@RequestParam(name="id", required=true) String id) {
        BizEffectDryingCompetition effectDryingCompetition = ((BizEffectDryingCompetitionManager)this.baseService).queryById(id);
        return effectDryingCompetition;
    }

    @PostMapping(value={"/updateAuditStatus"})
    @ApiOperation(value="\u5ba1\u6279\u72b6\u6001\u4fee\u6539")
    public CommonResult<String> updateAuditStatus(@RequestBody BizEffectEffectiveness bizEffectEffectiveness) {
        ((BizEffectDryingCompetitionManager)this.baseService).updateAuditStatus(bizEffectEffectiveness);
        return new CommonResult();
    }

    @RequestMapping(value={"exportList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6539\u9769\u6210\u6548\u5217\u8868", httpMethod="POST", notes="\u5bfc\u51fa\u6539\u9769\u6210\u6548\u5217\u8868")
    public void exportList(HttpServletResponse response, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BizEffectDryingCompetition> queryFilter) throws Exception {
        try {
            queryFilter.addFilter("a.is_dele_", (Object)"0", QueryOP.EQUAL);
            List sorter = queryFilter.getSorter();
            sorter.add(new FieldSort("r.last_time_", Direction.DESC));
            queryFilter.setSorter(sorter);
            PageList<EffectDryingCompetitionExportVo> pageList = ((BizEffectDryingCompetitionManager)this.baseService).queryAudit(queryFilter);
            ArrayList<Map> list = new ArrayList<Map>();
            if (BeanUtils.isNotEmpty((Object)pageList.getRows())) {
                int i = 1;
                for (EffectDryingCompetitionExportVo effect : pageList.getRows()) {
                    String jsonStr = JsonUtil.toJson((Object)((Object)effect));
                    Map map = JsonUtil.toMap((String)jsonStr);
                    map.put("sn", i);
                    ++i;
                    if (map.get("effectForm") != null) {
                        String effectForm = map.get("effectForm").toString();
                        String effectFormText = this.sysDictionaryDetailManager.getTextByValue("cxxs", effectForm);
                        map.put("effectFormText", effectFormText);
                    } else {
                        map.put("effectFormText", "");
                    }
                    if (map.get("specificDetails") != null) {
                        String specificDetails = map.get("specificDetails").toString();
                        String specificDetailsText = this.sysDictionaryDetailManager.getTextByValue("cxxs-jtqx", specificDetails);
                        map.put("specificDetailsText", specificDetailsText);
                    } else {
                        map.put("specificDetailsText", "");
                    }
                    list.add(map);
                }
            }
            String tempName = "\u6539\u9769\u6210\u6548\u5217\u8868";
            LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
            exportMaps.put("sn", "\u5e8f\u53f7");
            exportMaps.put("effectCardTopic", "\u6539\u9769\u4e8b\u60c5");
            exportMaps.put("completionDate", "\u751f\u6548\u65e5\u671f");
            exportMaps.put("createOrgName", "\u586b\u62a5\u533a\u53bf");
            exportMaps.put("effectFormText", "\u6210\u6548\u5f62\u5f0f");
            exportMaps.put("specificDetailsText", "\u5177\u4f53\u60c5\u5f62");
            exportMaps.put("solveProblem", "\u89e3\u51b3\u95ee\u9898");
            exportMaps.put("result", "\u4e3b\u8981\u6210\u679c");
            HSSFWorkbook book = ExcelUtil.exportTemplateExcel((String)tempName, exportMaps, list, (int)1, (String)"excel/effectDrying.xls");
            ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

