/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.exception;

import com.artfess.base.model.CommonResult;
import com.artfess.i18n.util.I18nUtil;
import java.util.HashMap;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice(basePackages={"com.artfess.cqlt"})
public class VaildExceptionControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(VaildExceptionControllerAdvice.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public CommonResult handleValidException(MethodArgumentNotValidException e) {
        log.error("\u6570\u636e\u6821\u9a8c\u51fa\u73b0\u95ee\u9898{}, \u5f02\u5e38\u7c7b\u578b:{}", (Object)e.getMessage(), e.getClass());
        BindingResult result = e.getBindingResult();
        HashMap errorMap = new HashMap();
        StringBuffer sb = new StringBuffer();
        result.getFieldErrors().forEach(item -> {
            String message = I18nUtil.getMessage((String)item.getDefaultMessage(), (Locale)LocaleContextHolder.getLocale());
            sb.append(",");
            sb.append(message);
            errorMap.put(item.getField(), message);
        });
        String message = null;
        if (sb.length() > 0) {
            message = sb.substring(1);
        }
        return new CommonResult(false, I18nUtil.getMessage((String)"required.error", (Locale)LocaleContextHolder.getLocale()) + ":" + message, null);
    }
}

