'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isBuiltIn = isBuiltIn;
exports.default = resolveImportType;

var _lodash = require('lodash.cond');

var _lodash2 = _interopRequireDefault(_lodash);

var _builtinModules = require('builtin-modules');

var _builtinModules2 = _interopRequireDefault(_builtinModules);

var _path = require('path');

var _resolve = require('eslint-module-utils/resolve');

var _resolve2 = _interopRequireDefault(_resolve);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function constant(value) {
  return () => value;
}

function isAbsolute(name) {
  return name.indexOf('/') === 0;
}

function isBuiltIn(name, settings) {
  const extras = settings && settings['import/core-modules'] || [];
  return _builtinModules2.default.indexOf(name) !== -1 || extras.indexOf(name) > -1;
}

function isExternalPath(path, name, settings) {
  const folders = settings && settings['import/external-module-folders'] || ['node_modules'];
  return !path || folders.some(folder => -1 < path.indexOf((0, _path.join)(folder, name)));
}

const externalModuleRegExp = /^\w/;
function isExternalModule(name, settings, path) {
  return externalModuleRegExp.test(name) && isExternalPath(path, name, settings);
}

const scopedRegExp = /^@\w+\/\w+/;
function isScoped(name) {
  return scopedRegExp.test(name);
}

function isInternalModule(name, settings, path) {
  return externalModuleRegExp.test(name) && !isExternalPath(path, name, settings);
}

function isRelativeToParent(name) {
  return name.indexOf('../') === 0;
}

const indexFiles = ['.', './', './index', './index.js'];
function isIndex(name) {
  return indexFiles.indexOf(name) !== -1;
}

function isRelativeToSibling(name) {
  return name.indexOf('./') === 0;
}

const typeTest = (0, _lodash2.default)([[isAbsolute, constant('absolute')], [isBuiltIn, constant('builtin')], [isExternalModule, constant('external')], [isScoped, constant('external')], [isInternalModule, constant('internal')], [isRelativeToParent, constant('parent')], [isIndex, constant('index')], [isRelativeToSibling, constant('sibling')], [constant(true), constant('unknown')]]);

function resolveImportType(name, context) {
  return typeTest(name, context.settings, (0, _resolve2.default)(name, context));
}
//# sourceMappingURL=data:application/json;base64,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