/**
 * 恢复暂停播放的语音
 *
 * \ **API目录**：音视频
 * \ ⚠️ 该接口需要鉴权
 *
 * @apiName 恢复暂停播放的语音
 *
 * @param localAudioId string 是 处于暂停状态的语音的本地标识
 *
 * @support
 *  - IOS v1.3.0
 *  - Android v1.3.0
 *
 * @example
 * ```typescript
 * resumeAudio({
 *    localAudioId: '1233123213'
 * })
 *   .then(res => {
 *     console.log(res);
 *   })
 *   .catch(err => {
 *     console.log(err);
 *   });
 * ```
 */
declare function resumeAudio(params: {
    localAudioId: string;
}): Promise<{}>;
declare namespace resumeAudio {
    var version: {
        android: string;
        ios: string;
    };
}
export default resumeAudio;
