import { View } from '@antv/g2';
import { ScatterOptions } from './types';
declare type RenderOptions = {
    view: View;
    options: ScatterOptions;
};
/**
 * 获取四象限默认配置
 * @param {number} xBaseline
 * @param {number} yBaseline
 */
export declare function getQuadrantDefaultConfig(xBaseline: number, yBaseline: number): {
    [key: string]: any;
};
export declare const getPath: (config: RenderOptions) => any[];
/**
 * 调整散点图 meta: { min, max } ① data.length === 1 ② 所有数据 y 值相等 ③ 所有数据 x 值相等
 * @param options
 * @returns
 */
export declare const getMeta: (options: Pick<ScatterOptions, 'meta' | 'xField' | 'yField' | 'data'>) => ScatterOptions['meta'];
export {};
