import { Action } from '@antv/g2';
import { ButtonCfg } from '../../types';
/**
 * Action 中的 Button 按钮配置
 *
 * 可能的使用场景：brush filter
 */
export declare const BUTTON_ACTION_CONFIG: ButtonCfg;
/**
 * @override 复写 G2 Button Action, 后续直接使用 GUI
 */
declare class ButtonAction extends Action {
    private buttonGroup;
    private buttonCfg;
    /**
     * 获取 mix 默认的配置和用户配置
     */
    private getButtonCfg;
    /**
     * 绘制 Button 和 文本
     */
    private drawButton;
    /**
     * 绘制文本
     */
    private drawText;
    private drawBackground;
    private resetPosition;
    /**
     * 显示
     */
    show(): void;
    /**
     * 隐藏
     */
    hide(): void;
    /**
     * 销毁
     */
    destroy(): void;
}
export { ButtonAction };
