interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = []
    const fixedOptionList: IOption[] = [
        {
            title: '供方名称',
            prop: 'supplierName',
            type: 'input',
            span: 4,
            value: ''
        }
    ]
    const columnsList: COption[] = [
        {
            title: '供方名称',
            prop: 'supplierName',
            minWidth: 160,
            sortable: true
        },
        {
            title: '法定代表人',
            prop: 'supplierCompanyEbe',
            minWidth: 120,
            sortable: true
        },
        {
            title: '退出原因',
            prop: 'result',
            minWidth: 160,
            sortable: true
        },
        {
            title: '退出时间',
            prop: 'outDate',
            minWidth: 120,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
