import Cookies from 'js-cookie'

export const TokenKey = 'Admin-Token'

export function getToken() {
    return Cookies.get(TokenKey)
}

export function setToken(token: string) {
    return Cookies.set(TokenKey, token, {
        expires: 7, // 7天过期
        secure: location.protocol === 'https:', // 生产环境HTTPS
        sameSite: 'strict' // 防CSRF
    })
}

export function removeToken() {
    return Cookies.remove(TokenKey)
}
