interface PageParams {
    page: number
    pageSize: number
}

interface PaginationOptions {
    params: {
        pageBean: PageParams
        [key: string]: any
    }
    loadData: () => Promise<void>
}

export function usePagination({ params, loadData }: PaginationOptions) {
    const handleSizeChange = (size: number) => {
        params.pageBean.pageSize = size
        loadData()
    }

    const handleCurrentChange = (page: number) => {
        params.pageBean.page = page
        loadData()
    }

    return {
        handleSizeChange,
        handleCurrentChange
    }
}
