import request from '@/requset/axios'

// 获得组织列表分页
export function getOrgPage(data = {}) {
    return new Promise((resolve, reject) => {
        request
            .post(`/api/org/v1/orgs/getOrgPage`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 获得组织树
export function treeDataByDem() {
    return new Promise((resolve, reject) => {
        request
            .get(`/api/org/v1/user/getOrgTree?demCode=ljjt`)
            .then((res) => resolve(res.data || []))
            .catch((err) => reject(err))
    })
}

// 岗位列表分页
export function getOrgPostPage(data: any) {
    return new Promise((resolve, reject) => {
        request
            .post(`/api/org/v1/orgPosts/getOrgPostPage`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 系统用户列表
export function getOrgUserPage(data = {}) {
    return new Promise((resolve, reject) => {
        request
            .post(`/api/user/v1/users/getOrgUserQuery`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
