import request from '@/requset/axios'

// 表格分页
export function dataTable(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierEnterpriseOut/v1/query`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}

// 表格保存
export function dataSave(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierEnterpriseOut/v1/saveModel`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 表格回显
export function dataDetail(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierEnterpriseOut/v1/getInfo?id=${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 导出excel
export function exportData(data: object) {
    return new Promise((resolve, reject) => {
        request
            .download('/biz/enterprise/exportDataToExcel', 'post', data, 'arraybuffer')
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 表格供应商回显
export function dataInfo(supplierEnterpriseId: string) {
    return new Promise((resolve, reject) => {
        request
            .get(
                `/bizSupplierEnterpriseOut/v1/getBySupplierEnterpriseId?supplierEnterpriseId=${supplierEnterpriseId}`
            )
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
