package com.artfess.application.persistence.manager;

import com.artfess.application.model.RemindConfig;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import org.quartz.SchedulerException;

/**
 * 业务提醒配置 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-12-21
 */
public interface RemindConfigManager extends BaseManager<RemindConfig> {

    PageList<RemindConfig> findByPage(QueryFilter<RemindConfig> queryFilter);

    boolean saveOrUpdateInfo(RemindConfig remindConfig) throws Exception;

    boolean deleteRemindConfigById(String id) throws SchedulerException;

    boolean toggleTriggerRun(String id) throws Exception;

    boolean executeJob(String id) throws SchedulerException;

    RemindConfig findById(String id);
}
